/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode;

import gov.gzcic.common.barcode.BarcodeClassResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultBarcodeClassResolver
implements BarcodeClassResolver {
    private Map classes;

    public DefaultBarcodeClassResolver() {
        this.registerBarcodeClass("codabar", "gov.gzcic.common.barcode.impl.codabar.Codabar");
        this.registerBarcodeClass("code39", "gov.gzcic.common.barcode.impl.code39.Code39");
        this.registerBarcodeClass("code128", "gov.gzcic.common.barcode.impl.code128.Code128");
        this.registerBarcodeClass("ean-128", "gov.gzcic.common.barcode.impl.code128.EAN128");
        this.registerBarcodeClass("ean128", "gov.gzcic.common.barcode.impl.code128.EAN128");
        this.registerBarcodeClass("2of5", "gov.gzcic.common.barcode.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("intl2of5", "gov.gzcic.common.barcode.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("interleaved2of5", "gov.gzcic.common.barcode.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("ean-13", "gov.gzcic.common.barcode.impl.upcean.EAN13");
        this.registerBarcodeClass("ean13", "gov.gzcic.common.barcode.impl.upcean.EAN13");
        this.registerBarcodeClass("ean-8", "gov.gzcic.common.barcode.impl.upcean.EAN8");
        this.registerBarcodeClass("ean8", "gov.gzcic.common.barcode.impl.upcean.EAN8");
        this.registerBarcodeClass("upc-a", "gov.gzcic.common.barcode.impl.upcean.UPCA");
        this.registerBarcodeClass("upca", "gov.gzcic.common.barcode.impl.upcean.UPCA");
        this.registerBarcodeClass("upc-e", "gov.gzcic.common.barcode.impl.upcean.UPCE");
        this.registerBarcodeClass("upce", "gov.gzcic.common.barcode.impl.upcean.UPCE");
        this.registerBarcodeClass("postnet", "gov.gzcic.common.barcode.impl.postnet.POSTNET");
        this.registerBarcodeClass("royal-mail-cbc", "gov.gzcic.common.barcode.impl.fourstate.RoyalMailCBC");
        this.registerBarcodeClass("pdf417", "gov.gzcic.common.barcode.impl.pdf417.PDF417");
        this.registerBarcodeClass("datamatrix", "gov.gzcic.common.barcode.impl.datamatrix.DataMatrix");
    }

    public void registerBarcodeClass(String name, String classname) {
        if (this.classes == null) {
            this.classes = new HashMap();
        }
        this.classes.put(name.toLowerCase(), classname);
    }

    public Class resolve(String name) throws ClassNotFoundException {
        String clazz = null;
        if (this.classes != null) {
            clazz = (String)this.classes.get(name.toLowerCase());
        }
        if (clazz == null) {
            clazz = name;
        }
        Class<?> cl = Class.forName(clazz);
        return cl;
    }

    public Class resolveBean(String name) throws ClassNotFoundException {
        String clazz = null;
        if (this.classes != null) {
            clazz = (String)this.classes.get(name.toLowerCase());
        }
        if (clazz == null) {
            clazz = name;
        }
        Class<?> cl = Class.forName(clazz + "Bean");
        return cl;
    }

    public Collection getBarcodeNames() {
        return Collections.unmodifiableCollection(this.classes.keySet());
    }
}

