/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.BarcodeDimension;
import gov.gzcic.common.barcode.ClassicBarcodeLogicHandler;
import gov.gzcic.common.barcode.HumanReadablePlacement;
import gov.gzcic.common.barcode.impl.DrawingUtil;
import gov.gzcic.common.barcode.impl.HeightVariableBarcodeBean;
import gov.gzcic.common.barcode.output.Canvas;

public abstract class AbstractVariableHeightLogicHandler
implements ClassicBarcodeLogicHandler {
    protected HeightVariableBarcodeBean bcBean;
    protected Canvas canvas;
    protected double x = 0.0;
    protected double y = 0.0;
    private String formattedMsg;

    public AbstractVariableHeightLogicHandler(HeightVariableBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg, String formattedMsg) {
        this.formattedMsg = formattedMsg;
        BarcodeDimension dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.x = this.getStartX();
    }

    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, this.y + this.bcBean.getHumanReadableHeight());
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, this.y + this.bcBean.getHeight());
            }
        }
    }

    public void startBarGroup(BarGroup barGroup, String string) {
    }

    public void endBarGroup() {
    }
}

