/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.BarcodeDimension;
import gov.gzcic.common.barcode.ClassicBarcodeLogicHandler;
import gov.gzcic.common.barcode.HumanReadablePlacement;
import gov.gzcic.common.barcode.impl.AbstractBarcodeBean;
import gov.gzcic.common.barcode.impl.DrawingUtil;
import gov.gzcic.common.barcode.output.Canvas;
import gov.gzcic.common.barcode.tools.MessagePatternUtil;

public class DefaultCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    private AbstractBarcodeBean bcBean;
    private Canvas canvas;
    private double x = 0.0;
    private String formattedMsg;
    private String lastgroup;

    public DefaultCanvasLogicHandler(AbstractBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg, String formattedMsg) {
        this.formattedMsg = MessagePatternUtil.applyCustomMessagePattern(formattedMsg, this.bcBean.getPattern());
        BarcodeDimension dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.x = this.getStartX();
    }

    public void startBarGroup(BarGroup type, String submsg) {
        this.lastgroup = submsg;
    }

    public void addBar(boolean black, int width) {
        double w = this.bcBean.getBarWidth(width);
        if (black) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                this.canvas.drawRectWH(this.x, 0.0, w, this.bcBean.getHeight());
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.canvas.drawRectWH(this.x, this.bcBean.getHumanReadableHeight(), w, this.bcBean.getBarHeight());
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.canvas.drawRectWH(this.x, 0.0, w, this.bcBean.getBarHeight());
            }
        }
        this.x += w;
    }

    public void endBarGroup() {
    }

    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                double ty = this.bcBean.getHumanReadableHeight();
                if (this.bcBean.hasFontDescender()) {
                    ty -= this.bcBean.getHumanReadableHeight() / 13.0 * 3.0;
                }
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, ty);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                double ty = this.bcBean.getHeight();
                if (this.bcBean.hasFontDescender()) {
                    ty -= this.bcBean.getHumanReadableHeight() / 13.0 * 3.0;
                }
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, ty);
            }
        }
    }
}

