/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.BarcodeDimension;
import gov.gzcic.common.barcode.TwoDimBarcodeLogicHandler;
import gov.gzcic.common.barcode.impl.AbstractBarcodeBean;
import gov.gzcic.common.barcode.output.Canvas;

public class DefaultTwoDimCanvasLogicHandler
implements TwoDimBarcodeLogicHandler {
    private AbstractBarcodeBean bcBean;
    private Canvas canvas;
    private double x = 0.0;
    private double y = 0.0;

    public DefaultTwoDimCanvasLogicHandler(AbstractBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    private double getStartY() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getVerticalQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg, String formattedMsg) {
        BarcodeDimension dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.y = this.getStartY();
    }

    public void startRow() {
        this.x = this.getStartX();
    }

    public void startBarGroup(BarGroup type, String submsg) {
    }

    public void addBar(boolean black, int width) {
        double w = this.bcBean.getBarWidth(width);
        if (black) {
            this.canvas.drawRectWH(this.x, this.y, w, this.bcBean.getBarHeight());
        }
        this.x += w;
    }

    public void endBarGroup() {
    }

    public void endRow() {
        this.y += this.bcBean.getBarHeight();
    }

    public void endBarcode() {
    }
}

