/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.code128;

public class CheckDigit {
    public static final byte CDNone = 0;
    public static final byte CD31 = 1;
    public static final byte CD11 = 2;

    public static char calcCheckdigit(String msg, int start, int end, byte type) {
        switch (type) {
            case 1: {
                return CheckDigit.calcCheckdigit(3, 1, msg, start, end);
            }
            case 2: {
                return CheckDigit.calcCheckdigit(1, 1, msg, start, end);
            }
        }
        return '0';
    }

    public static char calcCheckdigit31(String msg, int start, int end) {
        return CheckDigit.calcCheckdigit(3, 1, msg, start, end);
    }

    public static char calcCheckdigit11(String msg, int start, int end) {
        return CheckDigit.calcCheckdigit(1, 1, msg, start, end);
    }

    public static char calcCheckdigit(int oddMult, int evenMult, String msg, int start, int end) {
        int oddSum = 0;
        int evenSum = 0;
        boolean even = false;
        for (int i = end - 1; i >= start; --i) {
            if (even) {
                evenSum += Character.digit(msg.charAt(i), 10);
            } else {
                oddSum += Character.digit(msg.charAt(i), 10);
            }
            even = !even;
        }
        int check = 10 - (evenMult * evenSum + oddMult * oddSum) % 10;
        if (check >= 10) {
            check = 0;
        }
        return Character.forDigit(check, 10);
    }
}

