/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.code128;

import gov.gzcic.common.barcode.BarcodeDimension;
import gov.gzcic.common.barcode.impl.AbstractBarcodeBean;
import gov.gzcic.common.barcode.impl.DefaultCanvasLogicHandler;
import gov.gzcic.common.barcode.impl.code128.Code128LogicImpl;
import gov.gzcic.common.barcode.output.Canvas;
import gov.gzcic.common.barcode.output.CanvasProvider;

public class Code128Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.21f;

    public Code128Bean() {
        this.moduleWidth = 0.21f;
        this.quietZone = 10.0 * this.moduleWidth;
    }

    protected boolean hasFontDescender() {
        return true;
    }

    public double getBarWidth(int width) {
        if (width >= 1 && width <= 4) {
            return (double)width * this.moduleWidth;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public BarcodeDimension calcDimensions(String msg) {
        Code128LogicImpl impl = new Code128LogicImpl();
        int msgLen = impl.createEncodedMessage(msg).length + 1;
        double width = (double)(msgLen * 11 + 13) * this.getModuleWidth();
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        Code128LogicImpl impl = new Code128LogicImpl();
        impl.generateBarcodeLogic(handler, msg);
    }
}

