/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.code39;

import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.impl.ConfigurableBarcodeGenerator;
import gov.gzcic.common.barcode.impl.code39.Code39Bean;
import gov.gzcic.common.barcode.tools.Length;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class Code39
extends ConfigurableBarcodeGenerator
implements Configurable {
    public Code39() {
        this.bean = new Code39Bean();
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.19mm"), "mm");
        this.getCode39Bean().setModuleWidth(mw.getValueAsMillimeter());
        super.configure(cfg);
        this.getCode39Bean().setChecksumMode(ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName())));
        this.getCode39Bean().setWideFactor(cfg.getChild("wide-factor").getValueAsFloat(2.5f));
        Length igw = new Length(cfg.getChild("interchar-gap-width").getValue("1mw"), "mw");
        if (igw.getUnit().equalsIgnoreCase("mw")) {
            this.getCode39Bean().setIntercharGapWidth(igw.getValue() * this.getCode39Bean().getModuleWidth());
        } else {
            this.getCode39Bean().setIntercharGapWidth(igw.getValueAsMillimeter());
        }
        Configuration hr = cfg.getChild("human-readable", false);
        if (hr != null) {
            this.getCode39Bean().setDisplayStartStop(hr.getChild("display-start-stop").getValueAsBoolean(false));
            this.getCode39Bean().setDisplayChecksum(hr.getChild("display-checksum").getValueAsBoolean(false));
        }
    }

    public Code39Bean getCode39Bean() {
        return (Code39Bean)this.getBean();
    }
}

