/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.code39;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.ClassicBarcodeLogicHandler;

public class Code39LogicImpl {
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%', '*'};
    private static final char STARTSTOP = '*';
    private static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1}, {0, 0, 1, 1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1, 0, 0, 1}, {1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 1, 0, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 1, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 1, 0, 1, 0, 0, 0}, {0, 1, 0, 1, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 0, 1, 0}, {0, 1, 0, 0, 1, 0, 1, 0, 0}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;
    private boolean displayChecksum = false;

    public Code39LogicImpl(ChecksumMode mode, boolean displayStartStop, boolean displayChecksum) {
        this.checksumMode = mode;
        this.displayStartStop = displayStartStop;
        this.displayChecksum = displayChecksum;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    private static void invalidCharacter(char c) {
        if (c != '*') {
            throw new IllegalArgumentException("Invalid character: " + c);
        }
        throw new IllegalArgumentException("You may not include '*' as part of the message. This start/stop character is automatically added before and after the message.");
    }

    public static char calcChecksum(String msg) {
        int checksum = 0;
        for (int i = 0; i < msg.length(); ++i) {
            int chidx = Code39LogicImpl.getCharIndex(msg.charAt(i));
            if (chidx >= 0) {
                checksum += chidx;
                continue;
            }
            Code39LogicImpl.invalidCharacter(msg.charAt(i));
        }
        return CHARACTERS[checksum % 43];
    }

    public static boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = Code39LogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    private static int getCharIndex(char ch) {
        char effch = ch >= 'a' && ch <= 'z' ? Character.toUpperCase(ch) : ch;
        for (int i = 0; i < CHARACTERS.length; ++i) {
            if (effch != CHARACTERS[i]) continue;
            return i;
        }
        return -1;
    }

    private static boolean isValidChar(char ch) {
        if (ch == '*') {
            return false;
        }
        return Code39LogicImpl.getCharIndex(ch) >= 0;
    }

    private int widthAt(char ch, int index) {
        int chidx = Code39LogicImpl.getCharIndex(ch);
        if (chidx >= 0) {
            byte binary = CHARSET[chidx][index];
            return binary + 1;
        }
        Code39LogicImpl.invalidCharacter(ch);
        return 0;
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char c) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            int width = this.widthAt(c, i);
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
        }
        logic.endBarGroup();
    }

    private void addIntercharacterGap(ClassicBarcodeLogicHandler logic) {
        logic.addBar(false, -1);
    }

    private String handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            if (this.displayChecksum) {
                sb.append(Code39LogicImpl.calcChecksum(sb.toString()));
                return sb.toString();
            }
            String msg = sb.toString();
            sb.append(Code39LogicImpl.calcChecksum(msg));
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!Code39LogicImpl.validateChecksum(sb.toString())) {
                throw new IllegalArgumentException("Message '" + sb.toString() + "' has a bad checksum. Expected: " + Code39LogicImpl.calcChecksum(sb.toString()));
            }
            if (this.displayChecksum) {
                return sb.toString();
            }
            return sb.substring(0, sb.length() - 1);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return sb.toString();
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return sb.toString();
        }
        throw new IllegalStateException("Unknown checksum mode");
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        StringBuffer sb = new StringBuffer(msg);
        String formattedMsg = this.handleChecksum(sb);
        if (this.displayStartStop) {
            logic.startBarcode(sb.toString(), '*' + formattedMsg + '*');
        } else {
            logic.startBarcode(sb.toString(), formattedMsg);
        }
        logic.startBarGroup(BarGroup.START_CHARACTER, new Character('*').toString());
        this.encodeChar(logic, '*');
        logic.endBarGroup();
        for (int i = 0; i < sb.length(); ++i) {
            this.addIntercharacterGap(logic);
            char ch = sb.charAt(i);
            if (!Code39LogicImpl.isValidChar(ch)) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
        }
        this.addIntercharacterGap(logic);
        logic.startBarGroup(BarGroup.STOP_CHARACTER, new Character('*').toString());
        this.encodeChar(logic, '*');
        logic.endBarGroup();
        logic.endBarcode();
    }
}

