/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.datamatrix;

import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixReedSolomonFactors;
import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixSymbolInfo;

public class DataMatrixErrorCorrection
implements DataMatrixReedSolomonFactors {
    private static final int MODULO_VALUE = 301;
    private static final int[] LOG = new int[256];
    private static final int[] ALOG = new int[255];

    public static String encodeECC200(String codewords, DataMatrixSymbolInfo symbolInfo) {
        if (codewords.length() != symbolInfo.dataCapacity) {
            throw new IllegalArgumentException("The number of codewords does not match the selected symbol");
        }
        StringBuffer sb = new StringBuffer(symbolInfo.dataCapacity + symbolInfo.errorCodewords);
        sb.append(codewords);
        int blockCount = symbolInfo.getInterleavedBlockCount();
        if (blockCount == 1) {
            String ecc = DataMatrixErrorCorrection.createECCBlock(codewords, symbolInfo.errorCodewords);
            sb.append(ecc);
        } else {
            sb.setLength(sb.capacity());
            int[] dataSizes = new int[blockCount];
            int[] errorSizes = new int[blockCount];
            int[] startPos = new int[blockCount];
            for (int i = 0; i < blockCount; ++i) {
                dataSizes[i] = symbolInfo.getDataLengthForInterleavedBlock(i + 1);
                errorSizes[i] = symbolInfo.getErrorLengthForInterleavedBlock(i + 1);
                startPos[i] = 0;
                if (i <= 0) continue;
                startPos[i] = startPos[i - 1] + dataSizes[i];
            }
            for (int block = 0; block < blockCount; ++block) {
                StringBuffer temp = new StringBuffer(dataSizes[block]);
                for (int d = block; d < symbolInfo.dataCapacity; d += blockCount) {
                    temp.append(codewords.charAt(d));
                }
                String ecc = DataMatrixErrorCorrection.createECCBlock(temp.toString(), errorSizes[block]);
                int pos = 0;
                for (int e = block; e < errorSizes[block] * blockCount; e += blockCount) {
                    sb.setCharAt(symbolInfo.dataCapacity + e, ecc.charAt(pos++));
                }
            }
        }
        return sb.toString();
    }

    private static String createECCBlock(String codewords, int numECWords) {
        return DataMatrixErrorCorrection.createECCBlock(codewords, 0, codewords.length(), numECWords);
    }

    private static String createECCBlock(String codewords, int start, int len, int numECWords) {
        int i;
        int table = -1;
        for (int i2 = 0; i2 < FACTOR_SETS.length; ++i2) {
            if (FACTOR_SETS[i2] != numECWords) continue;
            table = i2;
            break;
        }
        if (table < 0) {
            throw new IllegalArgumentException("Illegal number of error correction codewords specified: " + numECWords);
        }
        int[] poly = DataMatrixReedSolomonFactors.FACTORS[table];
        char[] ecc = new char[numECWords];
        for (i = 0; i < numECWords; ++i) {
            ecc[i] = '\u0000';
        }
        for (i = start; i < start + len; ++i) {
            int m = ecc[numECWords - 1] ^ codewords.charAt(i);
            for (int k = numECWords - 1; k > 0; --k) {
                ecc[k] = m != 0 && poly[k] != 0 ? (char)(ecc[k - 1] ^ ALOG[(LOG[m] + LOG[poly[k]]) % 255]) : ecc[k - 1];
            }
            ecc[0] = m != 0 && poly[0] != 0 ? (char)ALOG[(LOG[m] + LOG[poly[0]]) % 255] : (char)'\u0000';
        }
        char[] eccReversed = new char[numECWords];
        for (int i3 = 0; i3 < numECWords; ++i3) {
            eccReversed[i3] = ecc[numECWords - i3 - 1];
        }
        return String.valueOf(eccReversed);
    }

    static {
        int p = 1;
        for (int i = 0; i < 255; ++i) {
            DataMatrixErrorCorrection.ALOG[i] = p;
            DataMatrixErrorCorrection.LOG[p] = i;
            if ((p <<= 1) < 256) continue;
            p ^= 0x12D;
        }
    }
}

