/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.datamatrix;

import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixConstants;
import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixSymbolInfo;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class DataMatrixHighLevelEncoder
implements DataMatrixConstants {
    private static final boolean DEBUG = true;
    private static final int ASCII_ENCODATION = 0;
    private static final int C40_ENCODATION = 1;
    private static final int TEXT_ENCODATION = 2;
    private static final int X12_ENCODATION = 3;
    private static final int EDIFACT_ENCODATION = 4;
    private static final int BASE256_ENCODATION = 5;
    private static final String[] ENCODATION_NAMES = new String[]{"ASCII", "C40", "Text", "ANSI X12", "EDIFACT", "Base 256"};
    private static final String DEFAULT_ASCII_ENCODING = "ISO-8859-1";
    private static final String EXTENDED_ASCII;

    public static byte[] getBytesForMessage(String msg) {
        String charset = "cp437";
        try {
            return msg.getBytes("cp437");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Incompatible JVM! The 'cp437' charset is not available!");
        }
    }

    private static char randomize253State(char ch, int codewordPosition) {
        int pseudoRandom = 149 * codewordPosition % 253 + 1;
        int tempVariable = ch + pseudoRandom;
        if (tempVariable <= 254) {
            return (char)tempVariable;
        }
        return (char)(tempVariable - 254);
    }

    private static char randomize255State(char ch, int codewordPosition) {
        int pseudoRandom = 149 * codewordPosition % 255 + 1;
        int tempVariable = ch + pseudoRandom;
        if (tempVariable <= 255) {
            return (char)tempVariable;
        }
        return (char)(tempVariable - 256);
    }

    public static String encodeHighLevel(String msg) {
        StringBuffer codewords;
        Encoder[] encoders = new Encoder[]{new ASCIIEncoder(), new C40Encoder(), new TextEncoder(), new X12Encoder(), new EdifactEncoder(), new Base256Encoder()};
        int encodingMode = 0;
        EncoderContext context = new EncoderContext(msg);
        while (context.hasMoreCharacters()) {
            encoders[encodingMode].encode(context);
            if (context.newEncoding < 0) continue;
            encodingMode = context.newEncoding;
            context.resetEncoderSignal();
        }
        int len = context.codewords.length();
        context.updateSymbolInfo();
        int capacity = ((EncoderContext)context).symbolInfo.dataCapacity;
        if (len < capacity && encodingMode != 0) {
            context.writeCodeword('\u00fe');
        }
        if ((codewords = context.codewords).length() < capacity) {
            codewords.append('\u0081');
        }
        while (codewords.length() < capacity) {
            codewords.append(DataMatrixHighLevelEncoder.randomize253State('\u0081', codewords.length() + 1));
        }
        return context.codewords.toString();
    }

    public static byte[] encodeMsg(String msg) {
        try {
            return msg.getBytes(DEFAULT_ASCII_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unsupported encoding: " + e.getMessage());
        }
    }

    private static char encodeASCIIDigits(char digit1, char digit2) {
        if (DataMatrixHighLevelEncoder.isDigit(digit1) && DataMatrixHighLevelEncoder.isDigit(digit2)) {
            int num = (digit1 - 48) * 10 + (digit2 - 48);
            return (char)(num + 130);
        }
        throw new IllegalArgumentException("not digits: " + digit1 + digit2);
    }

    private static int lookAheadTest(String msg, int startpos, int currentMode) {
        float[] charCounts;
        if (startpos >= msg.length()) {
            return currentMode;
        }
        if (currentMode == 0) {
            charCounts = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.25f};
        } else {
            charCounts = new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.25f};
            charCounts[currentMode] = 0.0f;
        }
        int charsProcessed = 0;
        while (true) {
            int[] intCharCounts;
            if (startpos + charsProcessed == msg.length() - 1) {
                int min = Integer.MAX_VALUE;
                byte[] mins = new byte[6];
                intCharCounts = new int[6];
                min = DataMatrixHighLevelEncoder.findMinimums(charCounts, intCharCounts, min, mins);
                int minCount = DataMatrixHighLevelEncoder.getMinimumCount(mins);
                if (intCharCounts[0] == min) {
                    return 0;
                }
                if (minCount == 1 && mins[5] > 0) {
                    return 5;
                }
                if (minCount == 1 && mins[4] > 0) {
                    return 4;
                }
                if (minCount == 1 && mins[2] > 0) {
                    return 2;
                }
                if (minCount == 1 && mins[3] > 0) {
                    return 3;
                }
                return 1;
            }
            char c = msg.charAt(startpos + charsProcessed);
            ++charsProcessed;
            if (DataMatrixHighLevelEncoder.isDigit(c)) {
                charCounts[0] = (float)((double)charCounts[0] + 0.5);
            } else if (DataMatrixHighLevelEncoder.isExtendedASCII(c)) {
                charCounts[0] = (int)Math.ceil(charCounts[0]);
                charCounts[0] = charCounts[0] + 2.0f;
            } else {
                charCounts[0] = (int)Math.ceil(charCounts[0]);
                charCounts[0] = charCounts[0] + 1.0f;
            }
            charCounts[1] = DataMatrixHighLevelEncoder.isNativeC40(c) ? charCounts[1] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? charCounts[1] + 2.6666667f : charCounts[1] + 1.3333334f);
            charCounts[2] = DataMatrixHighLevelEncoder.isNativeText(c) ? charCounts[2] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? charCounts[2] + 2.6666667f : charCounts[2] + 1.3333334f);
            charCounts[3] = DataMatrixHighLevelEncoder.isNativeX12(c) ? charCounts[3] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? charCounts[3] + 4.3333335f : charCounts[3] + 3.3333333f);
            charCounts[4] = DataMatrixHighLevelEncoder.isNativeEDIFACT(c) ? charCounts[4] + 0.75f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? charCounts[4] + 4.25f : charCounts[4] + 3.25f);
            charCounts[5] = DataMatrixHighLevelEncoder.isSpecialB256(c) ? charCounts[5] + 4.0f : charCounts[5] + 1.0f;
            if (charsProcessed < 4) continue;
            int min = Integer.MAX_VALUE;
            intCharCounts = new int[6];
            byte[] mins = new byte[6];
            min = DataMatrixHighLevelEncoder.findMinimums(charCounts, intCharCounts, min, mins);
            int minCount = DataMatrixHighLevelEncoder.getMinimumCount(mins);
            if (intCharCounts[0] + 1 <= intCharCounts[5] && intCharCounts[0] + 1 <= intCharCounts[1] && intCharCounts[0] + 1 <= intCharCounts[2] && intCharCounts[0] + 1 <= intCharCounts[3] && intCharCounts[0] + 1 <= intCharCounts[4]) {
                return 0;
            }
            if (intCharCounts[5] + 1 <= intCharCounts[0] || mins[1] + mins[2] + mins[3] + mins[4] == 0) {
                return 5;
            }
            if (minCount == 1 && mins[4] > 0) {
                return 4;
            }
            if (minCount == 1 && mins[2] > 0) {
                return 2;
            }
            if (minCount == 1 && mins[3] > 0) {
                return 3;
            }
            if (intCharCounts[1] + 1 >= intCharCounts[0] || intCharCounts[1] + 1 >= intCharCounts[5] || intCharCounts[1] + 1 >= intCharCounts[4] || intCharCounts[1] + 1 >= intCharCounts[2]) continue;
            if (intCharCounts[1] < intCharCounts[3]) {
                return 1;
            }
            if (intCharCounts[1] == intCharCounts[3]) break;
        }
        for (int p = startpos + charsProcessed + 1; p < msg.length(); ++p) {
            char tc = msg.charAt(p);
            if (DataMatrixHighLevelEncoder.isX12TermSep(tc)) {
                return 3;
            }
            if (!DataMatrixHighLevelEncoder.isNativeX12(tc)) break;
        }
        return 1;
    }

    private static int findMinimums(float[] charCounts, int[] intCharCounts, int min, byte[] mins) {
        Arrays.fill(mins, (byte)0);
        for (int i = 0; i < 6; ++i) {
            intCharCounts[i] = (int)Math.ceil(charCounts[i]);
            int current = intCharCounts[i];
            if (min > current) {
                min = current;
                Arrays.fill(mins, (byte)0);
            }
            if (min != current) continue;
            int n = i;
            mins[n] = (byte)(mins[n] + 1);
        }
        return min;
    }

    private static int getMinimumCount(byte[] mins) {
        int minCount = 0;
        for (int i = 0; i < 6; ++i) {
            minCount += mins[i];
        }
        return minCount;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isExtendedASCII(char ch) {
        return EXTENDED_ASCII.indexOf(ch) >= 0;
    }

    private static boolean isASCII7(char ch) {
        return ch >= '\u0000' && ch <= '\u007f';
    }

    private static boolean isNativeC40(char ch) {
        return ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isNativeText(char ch) {
        return ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z';
    }

    private static boolean isNativeX12(char ch) {
        return DataMatrixHighLevelEncoder.isX12TermSep(ch) || ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isX12TermSep(char ch) {
        return ch == '\r' || ch == '*' || ch == '>';
    }

    private static boolean isNativeEDIFACT(char ch) {
        return ch >= ' ' && ch <= '^';
    }

    private static boolean isSpecialB256(char ch) {
        return false;
    }

    public static int determineConsecutiveDigitCount(String msg, int startpos) {
        int count = 0;
        int idx = startpos;
        int len = msg.length();
        if (idx < len) {
            char ch = msg.charAt(idx);
            while (DataMatrixHighLevelEncoder.isDigit(ch) && idx < len) {
                ++count;
                if (++idx >= len) continue;
                ch = msg.charAt(idx);
            }
        }
        return count;
    }

    static {
        byte[] buf = new byte[128];
        for (int i = 0; i < 128; ++i) {
            buf[i] = (byte)(i + 128);
        }
        try {
            EXTENDED_ASCII = new String(buf, DEFAULT_ASCII_ENCODING);
            if (EXTENDED_ASCII.length() != buf.length) {
                throw new UnsupportedOperationException("Cannot deal with encodings that don't have a 1:1 character/byte relationship!");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static class Base256Encoder
    implements Encoder {
        private Base256Encoder() {
        }

        public int getEncodingMode() {
            return 5;
        }

        public void encode(EncoderContext context) {
            boolean mustPad;
            StringBuffer buffer = new StringBuffer();
            buffer.append('\u0000');
            while (context.hasMoreCharacters()) {
                char c = (char)(context.getCurrentByte() & 0xFF);
                buffer.append(c);
                context.pos++;
                int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                if (newMode == this.getEncodingMode()) continue;
                context.signalEncoderChange(newMode);
                break;
            }
            int dataCount = buffer.length() - 1;
            int lengthFieldSize = 1;
            if (dataCount > 249) {
                ++lengthFieldSize;
            }
            int currentSize = context.getCodewordCount() + dataCount + lengthFieldSize;
            context.updateSymbolInfo(currentSize);
            boolean bl = mustPad = ((EncoderContext)context).symbolInfo.dataCapacity - currentSize > 0;
            if (context.hasMoreCharacters() || mustPad) {
                if (dataCount <= 249) {
                    buffer.setCharAt(0, (char)dataCount);
                } else if (dataCount > 249 && dataCount <= 1555) {
                    buffer.setCharAt(0, (char)(dataCount / 250 + 249));
                    buffer.insert(1, (char)(dataCount % 250));
                } else {
                    throw new IllegalStateException("Message length not in valid ranges: " + dataCount);
                }
            }
            int c = buffer.length();
            for (int i = 0; i < c; ++i) {
                context.writeCodeword(DataMatrixHighLevelEncoder.randomize255State(buffer.charAt(i), context.getCodewordCount() + 1));
            }
        }
    }

    private static class EdifactEncoder
    implements Encoder {
        private EdifactEncoder() {
        }

        public int getEncodingMode() {
            return 4;
        }

        public void encode(EncoderContext context) {
            StringBuffer buffer = new StringBuffer();
            while (context.hasMoreCharacters()) {
                char c = context.getCurrentChar();
                this.encodeChar(c, buffer);
                int count = buffer.length();
                if (count >= 4) {
                    context.writeCodewords(this.encodeToCodewords(buffer, 0));
                    buffer.delete(0, 4);
                    int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                    if (newMode != this.getEncodingMode()) {
                        context.signalEncoderChange(newMode);
                    }
                }
                context.pos++;
            }
            buffer.append('\u001f');
            this.handleEOD(context, buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleEOD(EncoderContext context, StringBuffer buffer) {
            try {
                int count = buffer.length();
                if (count == 0) {
                    return;
                }
                if (count == 1) {
                    context.updateSymbolInfo();
                    int available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
                    int remaining = context.getRemainingCharacters();
                    if (remaining == 0 && available <= 2) {
                        return;
                    }
                }
                if (count > 4) {
                    throw new IllegalStateException("Count must not exceed 4");
                }
                int restChars = buffer.length() - 1;
                context.updateSymbolInfo();
                int available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
                if (available == 0) {
                    context.updateSymbolInfo(context.getCodewordCount() + 1);
                    available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
                }
                if (restChars <= available && available <= 2) {
                    context.pos -= buffer.length() - 1;
                } else {
                    context.writeCodewords(this.encodeToCodewords(buffer, 0));
                }
            }
            finally {
                context.signalEncoderChange(0);
            }
        }

        protected void encodeChar(char c, StringBuffer sb) {
            if (c >= ' ' && c <= '?') {
                sb.append(c);
            } else if (c >= '@' && c <= '^') {
                sb.append((char)(c - 64));
            } else {
                throw new IllegalArgumentException("Illegal character: " + c);
            }
        }

        protected String encodeToCodewords(StringBuffer sb, int startPos) {
            int len = sb.length() - startPos;
            if (len == 0) {
                throw new IllegalStateException("StringBuffer must not be empty");
            }
            char c1 = sb.charAt(startPos);
            char c2 = len >= 2 ? sb.charAt(startPos + 1) : (char)'\u0000';
            char c3 = len >= 3 ? sb.charAt(startPos + 2) : (char)'\u0000';
            char c4 = len >= 4 ? sb.charAt(startPos + 3) : (char)'\u0000';
            int v = (c1 << 18) + (c2 << 12) + (c3 << 6) + c4;
            char cw1 = (char)(v >> 16 & 0xFF);
            char cw2 = (char)(v >> 8 & 0xFF);
            char cw3 = (char)(v & 0xFF);
            StringBuffer res = new StringBuffer(3);
            res.append(cw1);
            if (len >= 2) {
                res.append(cw2);
            }
            if (len >= 3) {
                res.append(cw3);
            }
            return res.toString();
        }
    }

    private static class X12Encoder
    extends C40Encoder {
        private X12Encoder() {
        }

        public int getEncodingMode() {
            return 3;
        }

        public void encode(EncoderContext context) {
            StringBuffer buffer = new StringBuffer();
            while (context.hasMoreCharacters()) {
                char c = context.getCurrentChar();
                context.pos++;
                this.encodeChar(c, buffer);
                int count = buffer.length();
                if (count % 3 != 0) continue;
                this.writeNextTriplet(context, buffer);
                int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                if (newMode == this.getEncodingMode()) continue;
                context.signalEncoderChange(newMode);
                break;
            }
            this.handleEOD(context, buffer);
        }

        protected int encodeChar(char c, StringBuffer sb) {
            if (c == '\r') {
                sb.append('\u0000');
            } else if (c == '*') {
                sb.append('\u0001');
            } else if (c == '>') {
                sb.append('\u0002');
            } else if (c == ' ') {
                sb.append('\u0003');
            } else if (c >= '0' && c <= '9') {
                sb.append((char)(c - 48 + 4));
            } else if (c >= 'A' && c <= 'Z') {
                sb.append((char)(c - 65 + 14));
            } else {
                throw new IllegalArgumentException("Illegal character: " + c);
            }
            return 1;
        }

        protected void handleEOD(EncoderContext context, StringBuffer buffer) {
            context.updateSymbolInfo();
            int available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
            int count = buffer.length();
            if (count == 2) {
                context.writeCodeword('\u00fe');
                context.pos -= 2;
                context.signalEncoderChange(0);
            } else if (count == 1) {
                context.pos--;
                if (available > 1) {
                    context.writeCodeword('\u00fe');
                }
                context.signalEncoderChange(0);
            }
        }
    }

    private static class TextEncoder
    extends C40Encoder {
        private TextEncoder() {
        }

        public int getEncodingMode() {
            return 2;
        }

        protected int encodeChar(char c, StringBuffer sb) {
            if (c == ' ') {
                sb.append('\u0003');
                return 1;
            }
            if (c >= '0' && c <= '9') {
                sb.append((char)(c - 48 + 4));
                return 1;
            }
            if (c >= 'a' && c <= 'z') {
                sb.append((char)(c - 97 + 14));
                return 1;
            }
            if (c >= '\u0000' && c <= '\u001f') {
                sb.append('\u0000');
                sb.append(c);
                return 2;
            }
            if (c >= '!' && c <= '/') {
                sb.append('\u0001');
                sb.append((char)(c - 33));
                return 2;
            }
            if (c >= ':' && c <= '@') {
                sb.append('\u0001');
                sb.append((char)(c - 58 + 15));
                return 2;
            }
            if (c >= '[' && c <= '_') {
                sb.append('\u0001');
                sb.append((char)(c - 91 + 22));
                return 2;
            }
            if (c == '\'') {
                sb.append('\u0002');
                sb.append((char)(c - 96));
                return 2;
            }
            if (c >= 'A' && c <= 'Z') {
                sb.append('\u0002');
                sb.append((char)(c - 65 + 1));
                return 2;
            }
            if (c >= '{' && c <= '\u007f') {
                sb.append('\u0002');
                sb.append((char)(c - 123 + 26));
                return 2;
            }
            if (c >= '\u0080') {
                sb.append("\u0001\u001e");
                int len = 2;
                return len += this.encodeChar((char)(c - 128), sb);
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
    }

    private static class C40Encoder
    implements Encoder {
        private C40Encoder() {
        }

        public int getEncodingMode() {
            return 1;
        }

        public void encode(EncoderContext context) {
            int lastCharSize = -1;
            StringBuffer buffer = new StringBuffer();
            while (context.hasMoreCharacters()) {
                int newMode;
                char c = context.getCurrentChar();
                context.pos++;
                lastCharSize = this.encodeChar(c, buffer);
                int unwritten = buffer.length() / 3 * 2;
                int curCodewordCount = context.getCodewordCount() + unwritten;
                context.updateSymbolInfo(curCodewordCount);
                int available = ((EncoderContext)context).symbolInfo.dataCapacity - curCodewordCount;
                if (!context.hasMoreCharacters()) {
                    StringBuffer removed = new StringBuffer();
                    if (buffer.length() % 3 == 2 && (available < 2 || available > 2)) {
                        lastCharSize = this.backtrackOneCharacter(context, buffer, removed, lastCharSize);
                    }
                    while (buffer.length() % 3 == 1 && (lastCharSize <= 3 && available != 1 || lastCharSize > 3)) {
                        lastCharSize = this.backtrackOneCharacter(context, buffer, removed, lastCharSize);
                    }
                    break;
                }
                int count = buffer.length();
                if (count % 3 != 0 || (newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode())) == this.getEncodingMode()) continue;
                context.signalEncoderChange(newMode);
                break;
            }
            this.handleEOD(context, buffer, lastCharSize);
        }

        private int backtrackOneCharacter(EncoderContext context, StringBuffer buffer, StringBuffer removed, int lastCharSize) {
            int count = buffer.length();
            buffer.delete(count - lastCharSize, count);
            context.pos--;
            char c = context.getCurrentChar();
            lastCharSize = this.encodeChar(c, removed);
            context.resetSymbolInfo();
            return lastCharSize;
        }

        protected void writeNextTriplet(EncoderContext context, StringBuffer buffer) {
            context.writeCodewords(this.encodeToCodewords(buffer, 0));
            buffer.delete(0, 3);
        }

        protected void handleEOD(EncoderContext context, StringBuffer buffer, int lastCharSize) {
            int unwritten = buffer.length() / 3 * 2;
            int rest = buffer.length() % 3;
            int curCodewordCount = context.getCodewordCount() + unwritten;
            context.updateSymbolInfo(curCodewordCount);
            int available = ((EncoderContext)context).symbolInfo.dataCapacity - curCodewordCount;
            if (rest == 2) {
                buffer.append('\u0000');
                while (buffer.length() >= 3) {
                    this.writeNextTriplet(context, buffer);
                }
                if (context.hasMoreCharacters()) {
                    context.writeCodeword('\u00fe');
                }
            } else if (available == 1 && rest == 1) {
                while (buffer.length() >= 3) {
                    this.writeNextTriplet(context, buffer);
                }
                if (context.hasMoreCharacters()) {
                    context.writeCodeword('\u00fe');
                }
                context.pos--;
            } else if (rest == 0) {
                while (buffer.length() >= 3) {
                    this.writeNextTriplet(context, buffer);
                }
                if (available > 0 || context.hasMoreCharacters()) {
                    context.writeCodeword('\u00fe');
                }
            } else {
                throw new IllegalStateException("Unexpected case. Please report!");
            }
            context.signalEncoderChange(0);
        }

        protected int encodeChar(char c, StringBuffer sb) {
            if (c == ' ') {
                sb.append('\u0003');
                return 1;
            }
            if (c >= '0' && c <= '9') {
                sb.append((char)(c - 48 + 4));
                return 1;
            }
            if (c >= 'A' && c <= 'Z') {
                sb.append((char)(c - 65 + 14));
                return 1;
            }
            if (c >= '\u0000' && c <= '\u001f') {
                sb.append('\u0000');
                sb.append(c);
                return 2;
            }
            if (c >= '!' && c <= '/') {
                sb.append('\u0001');
                sb.append((char)(c - 33));
                return 2;
            }
            if (c >= ':' && c <= '@') {
                sb.append('\u0001');
                sb.append((char)(c - 58 + 15));
                return 2;
            }
            if (c >= '[' && c <= '_') {
                sb.append('\u0001');
                sb.append((char)(c - 91 + 22));
                return 2;
            }
            if (c >= '\'' && c <= '\u007f') {
                sb.append('\u0002');
                sb.append((char)(c - 96));
                return 2;
            }
            if (c >= '\u0080') {
                sb.append("\u0001\u001e");
                int len = 2;
                return len += this.encodeChar((char)(c - 128), sb);
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }

        protected String encodeToCodewords(StringBuffer sb, int startPos) {
            char c1 = sb.charAt(startPos);
            char c2 = sb.charAt(startPos + 1);
            char c3 = sb.charAt(startPos + 2);
            int v = 1600 * c1 + 40 * c2 + c3 + 1;
            char cw1 = (char)(v / 256);
            char cw2 = (char)(v % 256);
            return "" + cw1 + cw2;
        }
    }

    private static class ASCIIEncoder
    implements Encoder {
        private ASCIIEncoder() {
        }

        public int getEncodingMode() {
            return 0;
        }

        public void encode(EncoderContext context) {
            block11: {
                char c;
                block12: {
                    block10: {
                        int n = DataMatrixHighLevelEncoder.determineConsecutiveDigitCount(context.msg, context.pos);
                        if (n < 2) break block10;
                        context.writeCodeword(DataMatrixHighLevelEncoder.encodeASCIIDigits(context.msg.charAt(context.pos), context.msg.charAt(context.pos + 1)));
                        context.pos += 2;
                        break block11;
                    }
                    c = context.getCurrentChar();
                    int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                    if (newMode == this.getEncodingMode()) break block12;
                    switch (newMode) {
                        case 5: {
                            context.writeCodeword('\u00e7');
                            context.signalEncoderChange(5);
                            return;
                        }
                        case 1: {
                            context.writeCodeword('\u00e6');
                            context.signalEncoderChange(1);
                            return;
                        }
                        case 3: {
                            context.writeCodeword('\u00ee');
                            context.signalEncoderChange(3);
                            break block11;
                        }
                        case 2: {
                            context.writeCodeword('\u00ef');
                            context.signalEncoderChange(2);
                            break block11;
                        }
                        case 4: {
                            context.writeCodeword('\u00f0');
                            context.signalEncoderChange(4);
                            break block11;
                        }
                        default: {
                            throw new IllegalStateException("Illegal mode: " + newMode);
                        }
                    }
                }
                if (DataMatrixHighLevelEncoder.isExtendedASCII(c)) {
                    context.writeCodeword('\u00eb');
                    context.writeCodeword((char)(c - 128 + 1));
                    context.pos++;
                } else {
                    if (!DataMatrixHighLevelEncoder.isASCII7(c)) {
                        throw new IllegalArgumentException("Not an ASCII-7 character");
                    }
                    context.writeCodeword((char)(c + '\u0001'));
                    context.pos++;
                }
            }
        }
    }

    private static interface Encoder {
        public int getEncodingMode();

        public void encode(EncoderContext var1);
    }

    private static class EncoderContext {
        private String msg;
        private byte[] encodedMsg;
        private StringBuffer codewords;
        private int pos = 0;
        private int newEncoding = -1;
        private DataMatrixSymbolInfo symbolInfo;

        public EncoderContext(String msg) {
            this.msg = msg;
            this.encodedMsg = DataMatrixHighLevelEncoder.encodeMsg(msg);
            this.codewords = new StringBuffer(msg.length());
        }

        public char getCurrentChar() {
            return this.msg.charAt(this.pos);
        }

        public byte getCurrentByte() {
            return this.encodedMsg[this.pos];
        }

        public char getCurrent() {
            return this.msg.charAt(this.pos);
        }

        public void writeCodewords(String codewords) {
            this.codewords.append(codewords);
        }

        public void writeCodeword(char codeword) {
            this.codewords.append(codeword);
        }

        public int getCodewordCount() {
            return this.codewords.length();
        }

        public void signalEncoderChange(int encoding) {
            this.newEncoding = encoding;
        }

        public void resetEncoderSignal() {
            this.newEncoding = -1;
        }

        public boolean hasMoreCharacters() {
            return this.pos < this.msg.length();
        }

        public int getRemainingCharacters() {
            return this.msg.length() - this.pos;
        }

        public void updateSymbolInfo() {
            this.updateSymbolInfo(this.getCodewordCount());
        }

        public void updateSymbolInfo(int len) {
            if (this.symbolInfo == null || len > this.symbolInfo.dataCapacity) {
                this.symbolInfo = DataMatrixSymbolInfo.lookup(len);
            }
        }

        public void resetSymbolInfo() {
            this.symbolInfo = null;
        }
    }
}

