/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.datamatrix;

import gov.gzcic.common.barcode.TwoDimBarcodeLogicHandler;
import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixErrorCorrection;
import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixHighLevelEncoder;
import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixPlacement;
import gov.gzcic.common.barcode.impl.datamatrix.DataMatrixSymbolInfo;
import gov.gzcic.common.barcode.impl.datamatrix.DefaultDataMatrixPlacement;

public class DataMatrixLogicImpl {
    private static final boolean DEBUG = false;

    public void generateBarcodeLogic(TwoDimBarcodeLogicHandler logic, String msg) {
        String encoded = DataMatrixHighLevelEncoder.encodeHighLevel(msg);
        DataMatrixSymbolInfo symbolInfo = DataMatrixSymbolInfo.lookup(encoded.length());
        String codewords = DataMatrixErrorCorrection.encodeECC200(encoded, symbolInfo);
        DefaultDataMatrixPlacement placement = new DefaultDataMatrixPlacement(codewords, symbolInfo.getSymbolDataWidth(), symbolInfo.getSymbolDataHeight());
        placement.place();
        logic.startBarcode(msg, msg);
        this.encodeLowLevel(logic, placement, symbolInfo);
        logic.endBarcode();
    }

    private void encodeLowLevel(TwoDimBarcodeLogicHandler logic, DataMatrixPlacement placement, DataMatrixSymbolInfo symbolInfo) {
        int symbolWidth = symbolInfo.getSymbolDataWidth();
        int symbolHeight = symbolInfo.getSymbolDataHeight();
        for (int y = 0; y < symbolHeight; ++y) {
            int x;
            if (y % symbolInfo.matrixHeight == 0) {
                logic.startRow();
                for (x = 0; x < symbolInfo.getSymbolWidth(); ++x) {
                    logic.addBar(x % 2 == 0, 1);
                }
                logic.endRow();
            }
            logic.startRow();
            for (x = 0; x < symbolWidth; ++x) {
                if (x % symbolInfo.matrixWidth == 0) {
                    logic.addBar(true, 1);
                }
                logic.addBar(placement.getBit(x, y), 1);
                if (x % symbolInfo.matrixWidth != symbolInfo.matrixWidth - 1) continue;
                logic.addBar(y % 2 == 0, 1);
            }
            logic.endRow();
            if (y % symbolInfo.matrixHeight != symbolInfo.matrixHeight - 1) continue;
            logic.startRow();
            for (x = 0; x < symbolInfo.getSymbolWidth(); ++x) {
                logic.addBar(true, 1);
            }
            logic.endRow();
        }
    }
}

