/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.fourstate;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.ClassicBarcodeLogicHandler;

public abstract class AbstractFourStateLogicImpl {
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public AbstractFourStateLogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public abstract char calcChecksum(String var1);

    public boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = this.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    public static boolean isIgnoredChar(char c) {
        return false;
    }

    protected abstract String normalizeMessage(String var1);

    protected abstract String[] encodeHighLevel(String var1);

    protected void encodeCodeword(ClassicBarcodeLogicHandler logic, char c, String codeword) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        int count = codeword.length();
        for (int i = 0; i < count; ++i) {
            int height = Integer.parseInt(codeword.substring(i, i + 1));
            logic.addBar(true, height);
        }
        logic.endBarGroup();
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String normalizedMsg = this.normalizeMessage(msg);
        String[] encodedMsg = this.encodeHighLevel(normalizedMsg);
        logic.startBarcode(msg, normalizedMsg);
        for (int i = 0; i < encodedMsg.length; ++i) {
            char ch = normalizedMsg.charAt(i);
            this.encodeCodeword(logic, ch, encodedMsg[i]);
        }
        logic.endBarcode();
    }
}

