/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.fourstate;

import gov.gzcic.common.barcode.impl.AbstractVariableHeightLogicHandler;
import gov.gzcic.common.barcode.impl.HeightVariableBarcodeBean;
import gov.gzcic.common.barcode.output.Canvas;

public class FourStateLogicHandler
extends AbstractVariableHeightLogicHandler {
    public FourStateLogicHandler(HeightVariableBarcodeBean bcBean, Canvas canvas) {
        super(bcBean, canvas);
    }

    private double getStartY() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getVerticalQuietZone();
        }
        return 0.0;
    }

    public void addBar(boolean black, int height) {
        double y1;
        double w = this.bcBean.getBarWidth(1);
        double h = this.bcBean.getBarHeight(height);
        double middle = this.bcBean.getBarHeight() / 2.0;
        switch (height) {
            case 0: 
            case 2: {
                y1 = middle - this.bcBean.getBarHeight(0) / 2.0;
                break;
            }
            case 1: 
            case 3: {
                y1 = middle - this.bcBean.getBarHeight(3) / 2.0;
                break;
            }
            default: {
                throw new RuntimeException("Bug!");
            }
        }
        this.canvas.drawRectWH(this.x, this.getStartY() + y1, w, h);
        this.x += w + this.bcBean.getBarWidth(-1);
    }
}

