/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.fourstate;

import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.impl.ConfigurableBarcodeGenerator;
import gov.gzcic.common.barcode.impl.fourstate.RoyalMailCBCBean;
import gov.gzcic.common.barcode.tools.Length;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class RoyalMailCBC
extends ConfigurableBarcodeGenerator
implements Configurable {
    public RoyalMailCBC() {
        this.bean = new RoyalMailCBCBean();
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.53mm"), "mm");
        this.getRoyalMailCBCBean().setModuleWidth(mw.getValueAsMillimeter());
        super.configure(cfg);
        this.getRoyalMailCBCBean().setChecksumMode(ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName())));
        Length igw = new Length(cfg.getChild("interchar-gap-width").getValue("1mw"), "mw");
        if (igw.getUnit().equalsIgnoreCase("mw")) {
            this.getRoyalMailCBCBean().setIntercharGapWidth(igw.getValue() * this.getRoyalMailCBCBean().getModuleWidth());
        } else {
            this.getRoyalMailCBCBean().setIntercharGapWidth(igw.getValueAsMillimeter());
        }
        Length h = new Length(cfg.getChild("ascender-height").getValue("1.8mm"), "mm");
        this.getRoyalMailCBCBean().setAscenderHeight(h.getValueAsMillimeter());
        Length hbh = new Length(cfg.getChild("track-height").getValue("1.25mm"), "mm");
        this.getRoyalMailCBCBean().setTrackHeight(hbh.getValueAsMillimeter());
    }

    public RoyalMailCBCBean getRoyalMailCBCBean() {
        return (RoyalMailCBCBean)this.getBean();
    }

    protected String getDefaultQuietZone() {
        return "2mm";
    }
}

