/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.fourstate;

import gov.gzcic.common.barcode.BarcodeDimension;
import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.HumanReadablePlacement;
import gov.gzcic.common.barcode.impl.HeightVariableBarcodeBean;
import gov.gzcic.common.barcode.impl.fourstate.FourStateLogicHandler;
import gov.gzcic.common.barcode.impl.fourstate.RoyalMailCBCLogicImpl;
import gov.gzcic.common.barcode.output.Canvas;
import gov.gzcic.common.barcode.output.CanvasProvider;

public class RoyalMailCBCBean
extends HeightVariableBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = 0.53;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth;
    private double trackHeight = 1.25;
    private double ascenderHeight = 1.8f;

    public RoyalMailCBCBean() {
        this.msgPos = HumanReadablePlacement.HRP_NONE;
        this.quietZone = 2.0;
        this.intercharGapWidth = this.moduleWidth = 0.53;
        this.updateHeight();
    }

    public void setMsgPosition(HumanReadablePlacement placement) {
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getVerticalQuietZone() {
        return this.getQuietZone();
    }

    public double getIntercharGapWidth() {
        return this.intercharGapWidth;
    }

    public void setIntercharGapWidth(double width) {
        this.intercharGapWidth = width;
    }

    public double getTrackHeight() {
        return this.trackHeight;
    }

    public void setTrackHeight(double height) {
        this.trackHeight = height;
        this.updateHeight();
    }

    public double getAscenderHeight() {
        return this.ascenderHeight;
    }

    public void setAscenderHeight(double height) {
        this.ascenderHeight = height;
        this.updateHeight();
    }

    protected void updateHeight() {
        this.setBarHeight(this.getTrackHeight() + 2.0 * this.getAscenderHeight());
    }

    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only width 1 allowed");
    }

    public double getBarHeight(int height) {
        switch (height) {
            case 0: {
                return this.trackHeight;
            }
            case 1: {
                return this.trackHeight + this.ascenderHeight;
            }
            case 2: {
                return this.trackHeight + this.ascenderHeight;
            }
            case 3: {
                return this.trackHeight + 2.0 * this.ascenderHeight;
            }
        }
        throw new IllegalArgumentException("Only height 0-3 allowed");
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        FourStateLogicHandler handler = new FourStateLogicHandler(this, new Canvas(canvas));
        RoyalMailCBCLogicImpl impl = new RoyalMailCBCLogicImpl(this.getChecksumMode());
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        String modMsg = RoyalMailCBCLogicImpl.removeStartStop(msg);
        int additional = this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_AUTO ? 1 : 0;
        int len = modMsg.length() + additional;
        double width = (double)(len * 4 + 2) * this.moduleWidth + (double)(len * 4 + 1) * this.intercharGapWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getBarHeight(), width + 2.0 * qz, this.getBarHeight() + 2.0 * qz, this.quietZone, this.quietZone);
    }
}

