/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.fourstate;

import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.impl.fourstate.AbstractFourStateLogicImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RoyalMailCBCLogicImpl
extends AbstractFourStateLogicImpl {
    private static final Map CHARSET = new HashMap();

    public RoyalMailCBCLogicImpl(ChecksumMode mode) {
        super(mode);
    }

    public char calcChecksum(String msg) {
        String[] codewords = this.encodeHighLevel(RoyalMailCBCLogicImpl.removeStartStop(msg));
        int[] multiplier = new int[]{4, 2, 1, 0};
        int upperSum = 0;
        int lowerSum = 0;
        for (int i = 0; i < codewords.length; ++i) {
            int upper = 0;
            int lower = 0;
            for (int j = 0; j < 4; ++j) {
                int v = codewords[i].charAt(j) - 48;
                upper += (v & 1) * multiplier[j];
                lower += ((v & 2) >> 1) * multiplier[j];
            }
            upperSum += upper % 6;
            lowerSum += lower % 6;
        }
        int row = upperSum % 6;
        row = row == 0 ? 5 : --row;
        int col = lowerSum % 6;
        col = col == 0 ? 5 : --col;
        int idx = row * 6 + col;
        if (idx < 10) {
            return (char)(48 + idx);
        }
        return (char)(65 + idx - 10);
    }

    protected String handleChecksum(String msg) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return msg + this.calcChecksum(msg.toString());
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!this.validateChecksum(msg)) {
                throw new IllegalArgumentException("Message '" + msg + "' has a bad checksum. Expected: " + this.calcChecksum(msg.substring(0, msg.length() - 1)));
            }
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + this.getChecksumMode());
    }

    public static String removeStartStop(String msg) {
        StringBuffer sb = new StringBuffer(msg.length());
        int c = msg.length();
        block3: for (int i = 0; i < c; ++i) {
            char ch = msg.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case '[': 
                case ']': {
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public String normalizeMessage(String msg) {
        String s = RoyalMailCBCLogicImpl.removeStartStop(msg);
        s = this.handleChecksum(s);
        return "(" + s + ")";
    }

    protected String[] encodeHighLevel(String msg) {
        ArrayList<String> codewords = new ArrayList<String>(msg.length());
        int c = msg.length();
        for (int i = 0; i < c; ++i) {
            String ch = msg.substring(i, i + 1);
            String code = (String)CHARSET.get(ch);
            if (code == null) {
                throw new IllegalArgumentException("Illegal character: " + ch);
            }
            codewords.add(code);
        }
        return codewords.toArray(new String[codewords.size()]);
    }

    static {
        CHARSET.put("(", "1");
        CHARSET.put("[", "1");
        CHARSET.put(")", "3");
        CHARSET.put("]", "3");
        CHARSET.put("0", "0033");
        CHARSET.put("1", "0213");
        CHARSET.put("2", "0231");
        CHARSET.put("3", "2013");
        CHARSET.put("4", "2031");
        CHARSET.put("5", "2211");
        CHARSET.put("6", "0123");
        CHARSET.put("7", "0303");
        CHARSET.put("8", "0321");
        CHARSET.put("9", "2103");
        CHARSET.put("A", "2121");
        CHARSET.put("B", "2301");
        CHARSET.put("C", "0132");
        CHARSET.put("D", "0312");
        CHARSET.put("E", "0330");
        CHARSET.put("F", "2112");
        CHARSET.put("G", "2130");
        CHARSET.put("H", "2310");
        CHARSET.put("I", "1023");
        CHARSET.put("J", "1203");
        CHARSET.put("K", "1221");
        CHARSET.put("L", "3003");
        CHARSET.put("M", "3021");
        CHARSET.put("N", "3201");
        CHARSET.put("O", "1032");
        CHARSET.put("P", "1212");
        CHARSET.put("Q", "1230");
        CHARSET.put("R", "3012");
        CHARSET.put("S", "3030");
        CHARSET.put("T", "3210");
        CHARSET.put("U", "1122");
        CHARSET.put("V", "1302");
        CHARSET.put("W", "1320");
        CHARSET.put("X", "3102");
        CHARSET.put("Y", "3120");
        CHARSET.put("Z", "3300");
    }
}

