/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.int2of5;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.ClassicBarcodeLogicHandler;

public class Interleaved2Of5LogicImpl {
    private static final byte[][] CHARSET = new byte[][]{{1, 1, 2, 2, 1}, {2, 1, 1, 1, 2}, {1, 2, 1, 1, 2}, {2, 2, 1, 1, 1}, {1, 1, 2, 1, 2}, {2, 1, 2, 1, 1}, {1, 2, 2, 1, 1}, {1, 1, 1, 2, 2}, {2, 1, 1, 2, 1}, {1, 2, 1, 2, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayChecksum = false;

    public Interleaved2Of5LogicImpl(ChecksumMode mode, boolean displayChecksum) {
        this.checksumMode = mode;
        this.displayChecksum = displayChecksum;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static char calcChecksum(String msg, int oddMultiplier, int evenMultiplier) {
        int oddsum = 0;
        int evensum = 0;
        for (int i = 0; i < msg.length(); ++i) {
            if (i % 2 == 0) {
                evensum += Character.digit(msg.charAt(i), 10);
                continue;
            }
            oddsum += Character.digit(msg.charAt(i), 10);
        }
        int check = 10 - (evensum * oddMultiplier + oddsum * evenMultiplier) % 10;
        if (check >= 10) {
            check = 0;
        }
        return Character.forDigit(check, 10);
    }

    public static char calcChecksum(String msg) {
        return Interleaved2Of5LogicImpl.calcChecksum(msg, 3, 1);
    }

    public static boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = Interleaved2Of5LogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    private int widthAt(char ch, int index) {
        if (Character.isDigit(ch)) {
            int digit = Character.digit(ch, 10);
            byte width = CHARSET[digit][index];
            return width;
        }
        throw new IllegalArgumentException("Invalid character '" + ch + " (" + Character.getNumericValue(ch) + ")'. Expected a digit.");
    }

    private void encodeGroup(ClassicBarcodeLogicHandler logic, String group) {
        if (group.length() != 2) {
            throw new IllegalArgumentException("Parameter group must have two characters");
        }
        logic.startBarGroup(BarGroup.MSG_CHARACTER, group);
        for (int index = 0; index < 5; ++index) {
            logic.addBar(true, this.widthAt(group.charAt(0), index));
            logic.addBar(false, this.widthAt(group.charAt(1), index));
        }
        logic.endBarGroup();
    }

    private String handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            if (this.displayChecksum) {
                sb.append(Interleaved2Of5LogicImpl.calcChecksum(sb.toString()));
                return sb.toString();
            }
            String msg = sb.toString();
            sb.append(Interleaved2Of5LogicImpl.calcChecksum(msg));
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!Interleaved2Of5LogicImpl.validateChecksum(sb.toString())) {
                throw new IllegalArgumentException("Message '" + sb.toString() + "' has a bad checksum. Expected: " + Interleaved2Of5LogicImpl.calcChecksum(sb.substring(0, sb.length() - 1)));
            }
            if (this.displayChecksum) {
                return sb.toString();
            }
            return sb.substring(0, sb.length() - 1);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return sb.toString();
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return sb.toString();
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + this.getChecksumMode());
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        StringBuffer sb = new StringBuffer(msg);
        String formattedMsg = this.handleChecksum(sb);
        if (sb.length() % 2 != 0) {
            sb.insert(0, '0');
        }
        logic.startBarcode(msg, formattedMsg);
        logic.startBarGroup(BarGroup.START_CHARACTER, null);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.endBarGroup();
        int i = 0;
        do {
            this.encodeGroup(logic, sb.substring(i, i + 2));
        } while ((i += 2) < sb.length());
        logic.startBarGroup(BarGroup.STOP_CHARACTER, null);
        logic.addBar(true, 2);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.endBarGroup();
        logic.endBarcode();
    }
}

