/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.pdf417;

import gov.gzcic.common.barcode.BarcodeDimension;
import gov.gzcic.common.barcode.impl.AbstractBarcodeBean;
import gov.gzcic.common.barcode.impl.DefaultTwoDimCanvasLogicHandler;
import gov.gzcic.common.barcode.impl.pdf417.PDF417ErrorCorrection;
import gov.gzcic.common.barcode.impl.pdf417.PDF417HighLevelEncoder;
import gov.gzcic.common.barcode.impl.pdf417.PDF417LogicImpl;
import gov.gzcic.common.barcode.output.Canvas;
import gov.gzcic.common.barcode.output.CanvasProvider;
import gov.gzcic.common.barcode.tools.UnitConv;

public class PDF417Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = UnitConv.in2mm(0.013888888888888888);
    protected static final int DEFAULT_X_TO_Y_FACTOR = 3;
    protected static final int DEFAULT_COLUMN_COUNT = 2;
    protected static final int DEFAULT_ERROR_CORRECTION_LEVEL = 0;
    private int errorCorrectionLevel = 0;
    private int cols = 2;
    private Double quietZoneVertical;
    private double rowHeight;

    public PDF417Bean() {
        this.height = 0.0;
        this.moduleWidth = DEFAULT_MODULE_WIDTH;
        this.rowHeight = 3.0 * this.moduleWidth;
        this.quietZone = 2.0 * this.moduleWidth;
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultTwoDimCanvasLogicHandler handler = new DefaultTwoDimCanvasLogicHandler(this, new Canvas(canvas));
        PDF417LogicImpl impl = new PDF417LogicImpl();
        impl.generateBarcodeLogic(handler, msg, this.getColumns(), this.getErrorCorrectionLevel());
    }

    public BarcodeDimension calcDimensions(String msg) {
        int k = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(this.getErrorCorrectionLevel());
        String highLevel = PDF417HighLevelEncoder.encodeHighLevel(msg);
        int m = highLevel.length();
        int r = PDF417LogicImpl.getNumberOfRows(m, k, this.getColumns());
        double width = (double)(17 * this.getColumns() + 69) * this.getModuleWidth();
        double height = this.getBarHeight() * (double)r;
        double qzh = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(width, height, width + 2.0 * qzh, height + 2.0 * qzv, qzh, qzv);
    }

    public void setErrorCorrectionLevel(int level) {
        if (level < 0 || level > 8) {
            throw new IllegalArgumentException("Error correction level must be between 0 and 8!");
        }
        this.errorCorrectionLevel = level;
    }

    public int getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public void setColumns(int cols) {
        this.cols = cols;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setVerticalQuietZone(double height) {
        this.quietZoneVertical = new Double(height);
    }

    public double getVerticalQuietZone() {
        if (this.quietZoneVertical != null) {
            return this.quietZoneVertical;
        }
        return this.getQuietZone();
    }

    public double getBarWidth(int width) {
        return (double)width * this.moduleWidth;
    }

    public double getBarHeight() {
        return this.rowHeight;
    }
}

