/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.pdf417;

import gov.gzcic.common.barcode.impl.pdf417.PDF417Constants;

public class PDF417ErrorCorrection
implements PDF417Constants {
    public static int getErrorCorrectionCodewordCount(int errorCorrectionLevel) {
        if (errorCorrectionLevel < 0 || errorCorrectionLevel > 8) {
            throw new IllegalArgumentException("Error correction level must be between 0 and 8!");
        }
        return 1 << errorCorrectionLevel + 1;
    }

    public static int getRecommendedMinimumErrorCorrectionLevel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if (n >= 1 && n <= 40) {
            return 2;
        }
        if (n >= 41 && n <= 160) {
            return 3;
        }
        if (n >= 161 && n <= 320) {
            return 4;
        }
        if (n >= 321 && n <= 863) {
            return 5;
        }
        throw new IllegalArgumentException("No recommendation possible");
    }

    public static String generateErrorCorrection(String dataCodewords, int errorCorrectionLevel) {
        int j;
        int k = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(errorCorrectionLevel);
        char[] e = new char[k];
        int sld = dataCodewords.length();
        for (int i = 0; i < sld; ++i) {
            int t3;
            int t2;
            int t1 = (dataCodewords.charAt(i) + e[e.length - 1]) % 929;
            for (j = k - 1; j >= 1; --j) {
                t2 = t1 * EC_COEFFICIENTS[errorCorrectionLevel][j] % 929;
                t3 = 929 - t2;
                e[j] = (char)((e[j - 1] + t3) % 929);
            }
            t2 = t1 * EC_COEFFICIENTS[errorCorrectionLevel][0] % 929;
            t3 = 929 - t2;
            e[0] = (char)(t3 % 929);
        }
        StringBuffer sb = new StringBuffer(k);
        for (j = k - 1; j >= 0; --j) {
            if (e[j] != '\u0000') {
                e[j] = (char)(929 - e[j]);
            }
            sb.append(e[j]);
        }
        return sb.toString();
    }
}

