/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.pdf417;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.ClassicBarcodeLogicHandler;
import gov.gzcic.common.barcode.TwoDimBarcodeLogicHandler;
import gov.gzcic.common.barcode.impl.pdf417.PDF417Constants;
import gov.gzcic.common.barcode.impl.pdf417.PDF417ErrorCorrection;
import gov.gzcic.common.barcode.impl.pdf417.PDF417HighLevelEncoder;

public class PDF417LogicImpl {
    public static int getNumberOfRows(int m, int k, int c) {
        int r = (m + 1 + k) / c + 1;
        if (c * r >= m + 1 + k + c) {
            --r;
        }
        if (r > 90) {
            throw new IllegalArgumentException("The resultant number of rows for this barcode exceeds 90. Please increase the number of columns or decrease the error correction level to reduce the number of rows.");
        }
        if (r < 3) {
            throw new IllegalArgumentException("The resultant number of rows is less than 3. Please decrease the number of columns or increase the error correction level to increase the number of rows.");
        }
        return r;
    }

    public static int getNumberOfPadCodewords(int m, int k, int c, int r) {
        int n = c * r - k;
        if (n > m + 1) {
            return n - m - 1;
        }
        return 0;
    }

    public static int getNumberOfDataCodewords(int m, int errorCorrectionLevel, int c) {
        int k = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(errorCorrectionLevel);
        int r = PDF417LogicImpl.getNumberOfRows(m, k, c);
        return c * r - k;
    }

    private void encodeChar(int pattern, int len, ClassicBarcodeLogicHandler logic) {
        int map = 1 << len - 1;
        boolean last = (pattern & map) != 0;
        int width = 0;
        for (int i = 0; i < len; ++i) {
            boolean black;
            boolean bl = black = (pattern & map) != 0;
            if (last == black) {
                ++width;
            } else {
                logic.addBar(last, width);
                last = black;
                width = 1;
            }
            map >>= 1;
        }
        logic.addBar(last, width);
    }

    private void encodeLowLevel(String fullCodewords, int c, int r, int errorCorrectionLevel, TwoDimBarcodeLogicHandler logic) {
        int idx = 0;
        for (int y = 0; y < r; ++y) {
            int right;
            int left;
            int cluster = y % 3;
            logic.startRow();
            logic.startBarGroup(BarGroup.START_CHARACTER, null);
            this.encodeChar(130728, 17, logic);
            logic.endBarGroup();
            if (cluster == 0) {
                left = 30 * (y / 3) + (r - 1) / 3;
                right = 30 * (y / 3) + (c - 1);
            } else if (cluster == 1) {
                left = 30 * (y / 3) + errorCorrectionLevel * 3 + (r - 1) % 3;
                right = 30 * (y / 3) + (r - 1) / 3;
            } else {
                left = 30 * (y / 3) + (c - 1);
                right = 30 * (y / 3) + errorCorrectionLevel * 3 + (r - 1) % 3;
            }
            logic.startBarGroup(BarGroup.MSG_CHARACTER, null);
            int pattern = PDF417Constants.CODEWORD_TABLE[cluster][left];
            this.encodeChar(pattern, 17, logic);
            logic.endBarGroup();
            for (int x = 0; x < c; ++x) {
                logic.startBarGroup(BarGroup.MSG_CHARACTER, null);
                pattern = PDF417Constants.CODEWORD_TABLE[cluster][fullCodewords.charAt(idx)];
                this.encodeChar(pattern, 17, logic);
                logic.endBarGroup();
                ++idx;
            }
            logic.startBarGroup(BarGroup.MSG_CHARACTER, null);
            pattern = PDF417Constants.CODEWORD_TABLE[cluster][right];
            this.encodeChar(pattern, 17, logic);
            logic.endBarGroup();
            logic.startBarGroup(BarGroup.STOP_CHARACTER, null);
            this.encodeChar(260649, 18, logic);
            logic.endBarGroup();
            logic.endRow();
        }
    }

    public void generateBarcodeLogic(TwoDimBarcodeLogicHandler logic, String msg, int cols, int errorCorrectionLevel) {
        if (cols < 1 || cols > 30) {
            throw new IllegalArgumentException("The number of columns must be between 1 and 30");
        }
        int k = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(errorCorrectionLevel);
        String highLevel = PDF417HighLevelEncoder.encodeHighLevel(msg);
        int m = highLevel.length();
        int r = PDF417LogicImpl.getNumberOfRows(m, k, cols);
        int pad = PDF417LogicImpl.getNumberOfPadCodewords(m, k, cols, r);
        int n = PDF417LogicImpl.getNumberOfDataCodewords(m, errorCorrectionLevel, cols);
        StringBuffer sb = new StringBuffer(n);
        sb.append((char)n);
        sb.append(highLevel);
        for (int i = 0; i < pad; ++i) {
            sb.append('\u0384');
        }
        String dataCodewords = sb.toString();
        String ec = PDF417ErrorCorrection.generateErrorCorrection(dataCodewords, errorCorrectionLevel);
        String fullCodewords = dataCodewords + ec;
        logic.startBarcode(msg, msg);
        this.encodeLowLevel(fullCodewords, cols, r, errorCorrectionLevel, logic);
        logic.endBarcode();
    }
}

