/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.postnet;

import gov.gzcic.common.barcode.BaselineAlignment;
import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.impl.ConfigurableBarcodeGenerator;
import gov.gzcic.common.barcode.impl.postnet.POSTNETBean;
import gov.gzcic.common.barcode.tools.Length;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class POSTNET
extends ConfigurableBarcodeGenerator
implements Configurable {
    public POSTNET() {
        this.bean = new POSTNETBean();
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.020in"), "mm");
        this.getPOSTNETBean().setModuleWidth(mw.getValueAsMillimeter());
        super.configure(cfg);
        this.getPOSTNETBean().setChecksumMode(ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName())));
        Length igw = new Length(cfg.getChild("interchar-gap-width").getValue("0.026in"), "mm");
        this.getPOSTNETBean().setIntercharGapWidth(igw.getValueAsMillimeter());
        Length h = new Length(cfg.getChild("tall-bar-height").getValue("0.125in"), "mm");
        this.getPOSTNETBean().setBarHeight(h.getValueAsMillimeter());
        Length hbh = new Length(cfg.getChild("short-bar-height").getValue("0.050in"), "mm");
        this.getPOSTNETBean().setShortBarHeight(hbh.getValueAsMillimeter());
        this.getPOSTNETBean().setBaselinePosition(BaselineAlignment.byName(cfg.getChild("baseline-alignment").getValue(BaselineAlignment.ALIGN_BOTTOM.getName())));
        Configuration hr = cfg.getChild("human-readable", false);
        if (hr != null) {
            this.getPOSTNETBean().setDisplayChecksum(hr.getChild("display-checksum").getValueAsBoolean(false));
        }
    }

    public POSTNETBean getPOSTNETBean() {
        return (POSTNETBean)this.getBean();
    }
}

