/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.impl.upcean;

import gov.gzcic.common.barcode.BarGroup;
import gov.gzcic.common.barcode.ChecksumMode;
import gov.gzcic.common.barcode.ClassicBarcodeLogicHandler;

public abstract class UPCEANLogicImpl {
    protected static final byte LEFT_HAND_A = 0;
    protected static final byte LEFT_HAND_B = 1;
    protected static final byte RIGHT_HAND = 2;
    protected static final byte ODD_PARITY = 0;
    protected static final byte EVEN_PARITY = 1;
    private static final byte[][] CHARSET = new byte[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    private static final byte O = 0;
    private static final byte E = 1;
    private static final byte[][] SUPP2_PARITY = new byte[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
    private static final byte[][] SUPP5_PARITY = new byte[][]{{1, 1, 0, 0, 0}, {1, 0, 1, 0, 0}, {1, 0, 0, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 1, 0, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 1}, {0, 0, 1, 0, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public UPCEANLogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static void validateMessage(String msg) {
        for (int i = 0; i < msg.length(); ++i) {
            char c = msg.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("Invalid characters found. Valid are 0-9 only. Message: " + msg);
        }
    }

    public static char calcChecksum(String msg) {
        int oddsum = 0;
        int evensum = 0;
        for (int i = msg.length() - 1; i >= 0; --i) {
            if ((msg.length() - i) % 2 == 0) {
                evensum += Character.digit(msg.charAt(i), 10);
                continue;
            }
            oddsum += Character.digit(msg.charAt(i), 10);
        }
        int check = 10 - (evensum + 3 * oddsum) % 10;
        if (check >= 10) {
            check = 0;
        }
        return Character.forDigit(check, 10);
    }

    private int widthAt(char ch, int index) {
        if (Character.isDigit(ch)) {
            int digit = Character.digit(ch, 10);
            byte width = CHARSET[digit][index];
            return width;
        }
        throw new IllegalArgumentException("Invalid character '" + ch + "'. Expected a digit.");
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char c, int charset) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        if (charset == 1) {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                int width = this.widthAt(c, 3 - i);
                boolean black = i % 2 != 0;
                logic.addBar(black, width);
            }
        } else {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                int width = this.widthAt(c, i);
                boolean black = i % 2 == 0 && charset == 2 || i % 2 != 0 && charset == 0;
                logic.addBar(black, width);
            }
        }
        logic.endBarGroup();
    }

    protected void drawSideGuard(ClassicBarcodeLogicHandler logic) {
        logic.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.endBarGroup();
    }

    protected void drawCenterGuard(ClassicBarcodeLogicHandler logic) {
        logic.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.endBarGroup();
    }

    private void drawSuppLeftGuard(ClassicBarcodeLogicHandler logic) {
        logic.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.addBar(true, 2);
        logic.endBarGroup();
    }

    private void drawSuppSeparator(ClassicBarcodeLogicHandler logic) {
        logic.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.endBarGroup();
    }

    private void drawSupplemental2(ClassicBarcodeLogicHandler logic, String supp) {
        int suppValue = Integer.parseInt(supp);
        int remainder = suppValue % 4;
        logic.startBarGroup(BarGroup.UPC_EAN_SUPP, supp);
        this.drawSuppLeftGuard(logic);
        this.encodeChar(logic, supp.charAt(0), SUPP2_PARITY[remainder][0]);
        this.drawSuppSeparator(logic);
        this.encodeChar(logic, supp.charAt(1), SUPP2_PARITY[remainder][1]);
        logic.endBarGroup();
    }

    private void drawSupplemental5(ClassicBarcodeLogicHandler logic, String supp) {
        int suppValue = Integer.parseInt(supp);
        int weightedSum = 3 * (suppValue / 10000 % 10) + 9 * (suppValue / 1000 % 10) + 3 * (suppValue / 100 % 10) + 9 * (suppValue / 10 % 10) + 3 * (suppValue % 10);
        byte checksum = (byte)(weightedSum % 10);
        logic.startBarGroup(BarGroup.UPC_EAN_SUPP, supp);
        this.drawSuppLeftGuard(logic);
        for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
            if (i > 0) {
                this.drawSuppSeparator(logic);
            }
            this.encodeChar(logic, supp.charAt(i), SUPP5_PARITY[checksum][i]);
        }
        logic.endBarGroup();
    }

    protected void drawSupplemental(ClassicBarcodeLogicHandler logic, String supp) {
        if (supp == null) {
            throw new NullPointerException("Supplemental message must not be null");
        }
        if (supp.length() == 2) {
            this.drawSupplemental2(logic, supp);
        } else if (supp.length() == 5) {
            this.drawSupplemental5(logic, supp);
        } else {
            throw new IllegalArgumentException("Only supplemental lengths 2 and 5 are allowed: " + supp.length());
        }
    }

    protected static int getSupplementalLength(String msg) {
        String supp = UPCEANLogicImpl.retrieveSupplemental(msg);
        if (supp == null) {
            return 0;
        }
        if (supp.length() == 2) {
            return 2;
        }
        if (supp.length() == 5) {
            return 5;
        }
        throw new IllegalArgumentException("Illegal supplemental length (valid: 2 or 5): " + supp);
    }

    protected static String removeSupplemental(String msg) {
        int pos = msg.indexOf(43);
        if (pos >= 0) {
            return msg.substring(0, pos);
        }
        return msg;
    }

    protected static String retrieveSupplemental(String msg) {
        int pos = msg.indexOf(43);
        if (pos >= 0) {
            return msg.substring(pos + 1);
        }
        return null;
    }

    public abstract void generateBarcodeLogic(ClassicBarcodeLogicHandler var1, String var2);
}

