/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.output.bitmap;

import gov.gzcic.common.barcode.BarcodeDimension;
import gov.gzcic.common.barcode.output.AbstractCanvasProvider;
import gov.gzcic.common.barcode.output.bitmap.BitmapBuilder;
import gov.gzcic.common.barcode.output.bitmap.BitmapEncoder;
import gov.gzcic.common.barcode.output.bitmap.BitmapEncoderRegistry;
import gov.gzcic.common.barcode.output.java2d.Java2DCanvasProvider;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapCanvasProvider
extends AbstractCanvasProvider {
    private OutputStream out;
    private String mime;
    private int resolution;
    private int imageType;
    private boolean antiAlias;
    private BufferedImage image;
    private Java2DCanvasProvider delegate;

    public BitmapCanvasProvider(OutputStream out, String mime, int resolution, int imageType, boolean antiAlias, int orientation) {
        super(orientation);
        this.out = out;
        this.mime = mime;
        this.resolution = resolution;
        this.imageType = imageType;
        this.antiAlias = antiAlias;
    }

    public BitmapCanvasProvider(int resolution, int imageType, boolean antiAlias, int orientation) {
        this(null, null, resolution, imageType, antiAlias, orientation);
    }

    public void finish() throws IOException {
        this.image.flush();
        if (this.out != null) {
            BitmapEncoder encoder = BitmapEncoderRegistry.getInstance(this.mime);
            encoder.encode(this.image, this.out, this.mime, this.resolution);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public void establishDimensions(BarcodeDimension dim) {
        super.establishDimensions(dim);
        this.image = BitmapBuilder.prepareImage(dim, this.getOrientation(), this.resolution, this.imageType);
        this.delegate = new Java2DCanvasProvider(BitmapBuilder.prepareGraphics2D(this.image, dim, this.getOrientation(), this.antiAlias), this.getOrientation());
        this.delegate.establishDimensions(dim);
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        this.delegate.deviceFillRect(x, y, w, h);
    }

    public void deviceJustifiedText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.delegate.deviceJustifiedText(text, x1, x2, y1, fontName, fontSize);
    }

    public void deviceCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.delegate.deviceCenteredText(text, x1, x2, y1, fontName, fontSize);
    }
}

