/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.tools;

import gov.gzcic.common.barcode.tools.UnitConv;

public class Length {
    private double value;
    private String unit;

    public Length(double value, String unit) {
        this.value = value;
        this.unit = unit.toLowerCase();
    }

    public Length(String text, String defaultUnit) {
        this.parse(text, defaultUnit);
    }

    public Length(String text) {
        this(text, null);
    }

    protected void parse(String text, String defaultUnit) {
        String s = text.trim();
        if (s.length() == 0) {
            throw new IllegalArgumentException("Length is empty");
        }
        StringBuffer sb = new StringBuffer(s.length());
        int mode = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (mode == 0) {
                if (Character.isDigit(c) || c == '.' || c == ',') {
                    if (c == ',') {
                        c = '.';
                    }
                    sb.append(c);
                    ++i;
                    continue;
                }
                this.value = Double.parseDouble(sb.toString());
                sb.setLength(0);
                mode = 1;
                continue;
            }
            if (mode == 1) {
                if (Character.isWhitespace(c)) {
                    ++i;
                    continue;
                }
                mode = 2;
                continue;
            }
            if (mode != 2) continue;
            if (Character.isWhitespace(c)) break;
            sb.append(c);
            ++i;
        }
        if (mode == 0) {
            this.value = Double.parseDouble(sb.toString());
            mode = 1;
        }
        if (mode != 2) {
            if (mode > 0 && defaultUnit != null) {
                this.unit = defaultUnit.toLowerCase();
                return;
            }
            throw new IllegalArgumentException("Invalid length specified. Expected '<value> <unit>' (ex. 1.7mm) but got: " + text);
        }
        this.unit = sb.toString().toLowerCase();
    }

    public String getUnit() {
        return this.unit;
    }

    public double getValue() {
        return this.value;
    }

    public double getValueAsMillimeter() {
        if (this.unit.equals("mm")) {
            return this.value;
        }
        if (this.unit.equals("cm")) {
            return this.value * 10.0;
        }
        if (this.unit.equals("pt")) {
            return UnitConv.pt2mm(this.value);
        }
        if (this.unit.equals("in")) {
            return UnitConv.in2mm(this.value);
        }
        throw new IllegalStateException("Don't know how to convert " + this.unit + " to mm");
    }

    public String toString() {
        return this.getValue() + this.getUnit();
    }
}

