/*
 * Decompiled with CFR 0.152.
 */
package gov.gzcic.common.barcode.tools;

public class MimeTypes {
    public static final String MIME_SVG = "image/svg+xml";
    public static final String MIME_EPS = "image/x-eps";
    public static final String MIME_TIFF = "image/tiff";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_PNG = "image/x-png";
    public static final String MIME_GIF = "image/gif";
    private static final String[][] FORMAT_MAPPINGS = new String[][]{{"svg", "image/svg+xml"}, {"eps", "image/x-eps"}, {"image/eps", "image/x-eps"}, {"tif", "image/tiff"}, {"tiff", "image/tiff"}, {"jpg", "image/jpeg"}, {"jpeg", "image/jpeg"}, {"png", "image/x-png"}, {"image/png", "image/x-png"}, {"gif", "image/gif"}};

    protected MimeTypes() {
        throw new UnsupportedOperationException();
    }

    public static String expandFormat(String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        for (int i = 0; i < FORMAT_MAPPINGS.length; ++i) {
            if (!format.equalsIgnoreCase(FORMAT_MAPPINGS[i][0]) && !format.equals(FORMAT_MAPPINGS[i][1])) continue;
            return FORMAT_MAPPINGS[i][1];
        }
        return format.toLowerCase();
    }

    public static boolean isBitmapFormat(String format) {
        String fmt = MimeTypes.expandFormat(format);
        if (fmt == null) {
            return false;
        }
        return fmt.equals(MIME_JPEG) || fmt.equals(MIME_TIFF) || fmt.equals(MIME_PNG) || fmt.equals(MIME_GIF);
    }
}

