package zr.zrpower.ejb.sys;

import zr.zrpower.common.util.*;
import zr.zrpower.common.db.*;
import zr.zrpower.entity.sys.BPIP_OPERATE_TABLE;

/**
 * <p>Title: ZRPower</p>
 * <p>Description: ṹάEJB</p>
 * <p>Copyright: Copyright (c) 2015</p>
 */
public class OperateTableService
  {
  static private Log log;
  dbEngine dbengine;
  static private int clients=0;
  public zr.zrpower.common.util.SysPreperty ObjSysPreperty = new zr.zrpower.common.util.SysPreperty();
  String DataBaseType = ObjSysPreperty.getProperty().DataBaseType;//ݿ

  public OperateTableService()
  {
    dbengine = new dbEngine(SysPreperty.getProperty().MainDataSource,
                              SysPreperty.getProperty().IsConvert);
    dbengine.initialize();


    if (clients<1)
    {
      log = new Log();
      log.SetLogForClass("OperateTableService");
      log.SetLogFile("OperateTableService.log");
    }
    clients++;
  }

  /**
   * ܣжݿָеֶ
   * @param tableName 

   * @return intֵ
   **/
  private int GetColumnCount(String tableName) {
    String  strSql = "";
    strSql = "select FIELDID from BPIP_FIELD  where TABLEID in (select TABLEID from BPIP_TABLE where  TABLENAME=upper('"+
          tableName+"') or TABLENAME='"+ tableName+"')";
    try {
      return dbengine.QuerySQL(strSql).RowCount();
    }
    catch (Exception e) {
      log.WriteLog("쳣", e.getMessage());
    }
    return 0;

  }

  /**
   * ܣֶ
   * @param BPIP_OPERATE_TABLE ֶϢ
   * @return boolearnֵ
   **/
  public boolean AddField(BPIP_OPERATE_TABLE field) {
    boolean result = false;
    String endStr = "";
    String strBuf = "";

    if (DataBaseType.equals("2"))//mssqlݿ
    {
       //mssqlֶεͣoracleVARCHAR2VARCHAR
       if (field.FieldType.equals("VARCHAR2"))
       {
          field.FieldType = "VARCHAR";
       }
       if (field.FieldType.equals("NUMBER"))
       {
          field.FieldType = "NUMERIC";
       }
       if (field.FieldType.equals("BLOB"))
       {
          field.FieldType = "IMAGE";
       }
       if (field.FieldType.equals("CLOB"))
       {
          field.FieldType = "TEXT";
       }
       if (field.FieldType.equals("DATE"))
       {
          field.FieldType = "DATETIME";
       }

    }
    if (DataBaseType.equals("3"))//mysqlݿ
    {
       //mssqlֶεͣoracleVARCHAR2VARCHAR
       if (field.FieldType.equals("VARCHAR2"))
       {
          field.FieldType = "VARCHAR";
       }
       if (field.FieldType.equals("NUMBER"))
       {
          field.FieldType = "NUMERIC";
       }
       if (field.FieldType.equals("BLOB"))
       {
          field.FieldType = "LONGBLOB";
       }
       if (field.FieldType.equals("CLOB"))
       {
          field.FieldType = "LONGTEXT";
       }
       if (field.FieldType.equals("DATE"))
       {
          field.FieldType = "DATETIME";
       }

    }


    if (IsExistTable(field.TableName)) {
        strBuf = "ALTER TABLE "+field.TableName+" ADD "+ field.FieldName;
    }
    else { //ڱ
        strBuf ="CREATE TABLE "+field.TableName+" ( "+ field.FieldName;
        endStr =" ) ";
    }

    strBuf = strBuf + "  "+field.FieldType+"  ";

    if (field.Length > 0 && field.Precision > 0) {
      strBuf = strBuf + "("+String.valueOf(field.Length)+","+
                    String.valueOf(field.Precision)+")";
    }
    else
    if (field.Length > 0) {
      strBuf = strBuf + "("+String.valueOf(field.Length)+")";
    }

    if (field.IsNull) {
      strBuf = strBuf + " NULL";
    }
    else {
      strBuf = strBuf + " NOT NULL";
    }
    if (field.IsPrimaryKey) {
      strBuf = strBuf + " PRIMARY KEY";
    }

    if (field.DefaultValue.length() > 0) {
      strBuf = strBuf + " DEFAULT "+field.DefaultValue;
    }

    strBuf = strBuf + endStr;
    try {
      result = dbengine.ExecuteSQL(strBuf);
    }
    catch (Exception e) {
      result = false;
      log.WriteLog("쳣", e.getMessage());
    }
    return result;
  }

  /**
   * ܣɾֶ
   * @param BPIP_OPERATE_TABLE ֶϢ
   * @return boolearnֵ
   **/
  public boolean DeleteField(BPIP_OPERATE_TABLE field) {
    String strSql = "";
    if (GetColumnCount(field.TableName) == 1) {
      //ֻһֶΣɾֶκڣҪִɾĲ
      if (DataBaseType.equals("2") || DataBaseType.equals("3"))//mssqlmysql
      {
        strSql = "DROP TABLE "+field.TableName;
      }else
      {
        strSql = "DROP TABLE "+field.TableName+" CASCADE CONSTRAINT";
      }

    }
    else {
      strSql = "ALTER TABLE "+field.TableName+" DROP COLUMN "+ field.FieldName;
    }
    try {
      return dbengine.ExecuteSQL(strSql);
    }
    catch (Exception e) {
      log.WriteLog("DeleteField-쳣", e.getMessage());
    }
    return false;
  }

  /**
   * ܣɾָı
   * @param TableName 
   * @return boolearnֵ
   **/
  public boolean DeleteTable(String TableName) {
    String strSql = "";
    boolean result = false;
    if (DataBaseType.equals("2") || DataBaseType.equals("3"))//mssqlmysql
    {
      strSql = "DROP TABLE "+TableName;
    }
    else
    {
      strSql = "DROP TABLE "+TableName+" CASCADE CONSTRAINT";
    }

      try {
        result = dbengine.ExecuteSQL(strSql);
      }
      catch (Exception e) {
        log.WriteLog("DeleteTable-쳣", e.getMessage());
      }
    return result;
  }

  /**
   * ܣ޸ֶ
   * @param field ֶϢ
   * @return boolearnֵ
   **/
  public boolean ModifyField(BPIP_OPERATE_TABLE field) {
    log.WriteLog("ModifyField", "ʼ");
    boolean result = false;
    StringBuffer strBuf = new StringBuffer();

    if (DataBaseType.equals("2"))//mssqlݿ
    {
       //mssqlֶεͣoracleVARCHAR2VARCHAR
       if (field.FieldType.equals("VARCHAR2"))
       {
          field.FieldType = "VARCHAR";
       }
       if (field.FieldType.equals("NUMBER"))
       {
          field.FieldType = "NUMERIC";
       }
       if (field.FieldType.equals("BLOB"))
       {
          field.FieldType = "IMAGE";
       }
       if (field.FieldType.equals("CLOB"))
       {
          field.FieldType = "TEXT";
       }
       if (field.FieldType.equals("DATE"))
       {
          field.FieldType = "DATETIME";
       }

    }

    if (DataBaseType.equals("3"))//mysqlݿ
    {
       //mssqlֶεͣoracleVARCHAR2VARCHAR
       if (field.FieldType.equals("VARCHAR2"))
       {
          field.FieldType = "VARCHAR";
       }
       if (field.FieldType.equals("NUMBER"))
       {
          field.FieldType = "NUMERIC";
       }
       if (field.FieldType.equals("BLOB"))
       {
          field.FieldType = "LONGBLOB";
       }
       if (field.FieldType.equals("CLOB"))
       {
          field.FieldType = "LONGTEXT";
       }
       if (field.FieldType.equals("DATE"))
       {
          field.FieldType = "DATETIME";
       }

    }


      if (!field.FieldName.equals(field.OldFieldName)) {

        if (DataBaseType.equals("1"))//oracleݿ
        {
          strBuf.append("ALTER TABLE "+field.TableName+"  RENAME COLUMN "+
                      field.OldFieldName+" TO "+field.FieldName+";");
        }
        if (DataBaseType.equals("2"))//mssqlݿ
        {
          strBuf.append("exec sp_rename '"+field.TableName+"."+
                      field.OldFieldName+"' , '"+field.FieldName+"';");
        }
        if (DataBaseType.equals("3"))//mysqlݿ
        {
          strBuf.append("ALTER TABLE "+field.TableName+"  change "+
                      field.OldFieldName+" "+field.FieldName+";");
        }


      }

       if (DataBaseType.equals("1"))//oracleݿ
       {
         strBuf.append("ALTER TABLE "+field.TableName+" MODIFY "+
                      field.FieldName);
       }
       if (DataBaseType.equals("2"))//mssqlݿ
       {
         strBuf.append("ALTER TABLE "+field.TableName+" ALTER COLUMN "+
                      field.FieldName);
       }

       if (DataBaseType.equals("3"))//mysqlݿ
       {
         strBuf.append("ALTER TABLE "+field.TableName+"  change  "+
                      field.FieldName);
       }

      strBuf.append(" "+field.FieldType+"");

      if (field.Length > 0 && field.Precision > 0) {
        strBuf.append("("+String.valueOf(field.Length)+","+
                      String.valueOf(field.Precision)+")");
      }
      else
      if (field.Length > 0) {
        strBuf.append("("+String.valueOf(field.Length)+")");
      }

     if (!field.IsNull)
     {
           strBuf.append(" NOT NULL");
     }

     if (field.IsNull)
     {
          strBuf.append(" NULL");
     }

    if (field.IsPrimaryKey) {
        strBuf.append(" PRIMARY KEY");
      }

      if (field.DefaultValue.length() > 0) {
        strBuf.append(" DEFAULT "+field.DefaultValue);
      }
      strBuf.append(";");
      try {
        log.WriteLog("ִеSQL", strBuf.toString());
        result = dbengine.ExecuteSQLs(strBuf.toString().split(";"));

      }
      catch (Exception e) {
        log.WriteLog("쳣", e.getMessage());
      }

    return result;
  }

  /**
   * ܣı
   * @param OldName ɱ
   * @param NewName ±
   * @return boolearnֵ
   **/
  public boolean ChangeTableName(String OldName, String NewName) {
    boolean result = false;
    String strSql = "";
    strSql = "ALTER TABLE "+OldName+" rename to "+NewName;
      try {
        result = dbengine.ExecuteSQL(strSql);
      }
      catch (Exception e) {
        result = false;
        log.WriteLog("ChangeTableName-쳣", e.getMessage());
      }
    return result;
  }
  /**
     * ܣжݿǷָı
     * @param tableName ִ
     * @return boolearnֵ
     **/
    private boolean IsExistTable(String tableName) {
      log.WriteLog("IsExistTable", "ʼ");
      boolean result = false;
      String  strSql = "";
      strSql = "select count(TABLEID) as num from BPIP_FIELD where TABLEID in (select TABLEID from BPIP_TABLE where TABLENAME=upper('"+
          tableName+"') or TABLENAME='"+ tableName+"')";

      int rowCount  = 0;
      try {
        dbSet dbset = dbengine.QuerySQL(strSql);
        if (dbset != null) {
          if (dbset.RowCount() > 0) {
             rowCount = dbset.Row(0).Column("num").getInteger();
          }
        }
      }
      catch (Exception e) {
        rowCount = 0;
        log.WriteLog("쳣", e.getMessage());
      }

      if (rowCount > 1) {
        result = true;
      }
      else {
        result = false;
      }
      log.WriteLog("IsExistTable", "");
      return result;
  }
}
