package zr.zrpower.analyseengine.web.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import zr.zrpower.common.util.FunctionMessage;
import zr.zrpower.common.web.Upload;
import zr.zrpower.common.util.SysPreperty;
import zr.zrpower.analyseengine.service.StatisticsConfig;
import zr.zrpower.analyseengine.mode.ANALYSE_STATISTICS_MAIN;


public class ActionStatistics
    extends HttpServlet {
  private static final String CONTENT_TYPE = "text/html; charset=GBK";
  private static final String RETURN_PATH = "javascript:history.back(-1);";

  private StatisticsConfig Statistics;
  private ANALYSE_STATISTICS_MAIN analysemianentity;

  /**
   * <p>Title: ZRPower</p>
   * <p>Description:ñWeb</p>
   * <p>Copyright: Copyright (c) 2007</p>
   * <p>Company: </p>
 */

  //Initialize global variables
  public void init() throws ServletException {
  }

  //Process the HTTP Get request
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws
      ServletException, IOException {
    response.setContentType(CONTENT_TYPE);
    request.setCharacterEncoding("GBK");

    String strTemplat = SysPreperty.getProperty().LogFilePath;
    strTemplat = strTemplat.substring(0,strTemplat.length()-3)+"StatExcel";
    //ϴ
    Upload upload = new Upload();
    upload.setSwitch(false);
    upload.setUpType(0);
    upload.setSuffix(".*");
    upload.setSize(1024 * 1024 * 20); //ϴΪ20M
    upload.setObjectPath(strTemplat);


    boolean bUploadOK = false; //ϴǷɹ
    try {
      upload.setSourceFile(request);
      bUploadOK = true;
    }
    catch (IOException ex1) {

    }

    if (bUploadOK) {
      Hashtable htFields = upload.getFields();
      String[] saFile = upload.getObjectFileName();
      String strAct = (String) htFields.get("Act");

     //-------------------------------------------------------------------------
      if (htFields != null) {
     //--ͳ----------------------------------------------------------------
        try {
          analysemianentity = new ANALYSE_STATISTICS_MAIN();
          analysemianentity.setID( (String) htFields.get("ID"));
          analysemianentity.setSTATISTICSNAME( (String) htFields.get("STATISTICSNAME"));
          analysemianentity.setSDESC( (String) htFields.get("SDESC"));
          analysemianentity.setTABLEID( (String) htFields.get("TABLEID"));
          analysemianentity.setTIMESTYPE( (String) htFields.get("TIMESTYPE"));

          analysemianentity.setPLANARTABLE( (String) htFields.get("PLANARTABLE"));

          analysemianentity.setPLANARFIELD( (String) htFields.get("PLANARFIELD"));
          analysemianentity.setCPLANARFIELD( (String) htFields.get("CPLANARFIELD"));
          analysemianentity.setWHEREVALUE( (String) htFields.get("WHEREVALUE"));
          analysemianentity.setPLANARFIELDNAME( (String) htFields.get("PLANARFIELDNAME"));
          analysemianentity.setWISMATCH( (String) htFields.get("WISMATCH"));
          analysemianentity.setCJOIN( (String) htFields.get("CJOIN"));
          analysemianentity.setISUNIT( (String) htFields.get("ISUNIT"));
          analysemianentity.setSINPUTTYPE( (String) htFields.get("SINPUTTYPE"));
          analysemianentity.setSINPUTPAGE( (String) htFields.get("SINPUTPAGE"));
          analysemianentity.setISAGV( (String) htFields.get("ISAGV"));
          analysemianentity.setISSUM( (String) htFields.get("ISSUM"));
          analysemianentity.setISSHOWTYPE( (String) htFields.get("ISSHOWTYPE"));
          analysemianentity.setSHOWLINK( (String) htFields.get("SHOWLINK"));
          analysemianentity.setISNUMBER( (String) htFields.get("ISNUMBER"));
          analysemianentity.setADDFIELD( (String) htFields.get("ADDFIELD"));

          analysemianentity.setCODETABLE((String) htFields.get("CODETABLE"));
          analysemianentity.setTBUTTON((String) htFields.get("TBUTTON"));
          analysemianentity.setISZERO((String) htFields.get("ISZERO"));

        }
        catch (NumberFormatException ex) {

        }

        analysemianentity.fullDataFromHashtable(htFields);


//=============================================================================
       try {
          Statistics = new StatisticsConfig();
          if (strAct.equals("savemain")) {
               SaveConfigMain();   //ͳ

               analysemianentity = null;
              response.sendRedirect(
              "ZrAnalyseEngine/StatisticsConfig/CloseWindow.jsp");
          }
          if (strAct.equals("delmain")) {
                 DelMain();        //ɾͳ
                 analysemianentity = null;
             response.sendRedirect(
             "ZrAnalyseEngine/StatisticsConfig/CloseWindow.jsp");
         }
       }
        catch (Exception ex2) {

        }


      }
    }
  }
  //Process the HTTP Post request
  public void doPost(HttpServletRequest request, HttpServletResponse response) throws
      ServletException, IOException {
    doGet(request, response);
  }

  //Clean up resources
  public void destroy() {
  }

  /**
   * ͳ
   * @return FunctionMessage
   */
private FunctionMessage SaveConfigMain() {
    FunctionMessage fmTemp = new FunctionMessage();
    try {
      fmTemp = Statistics.SaveAnalyseMain(analysemianentity);
    }
    catch (Exception ex) {
      fmTemp = new FunctionMessage(false, ex.getMessage());
    }
    return fmTemp;
  }

private boolean DelMain() {
     boolean isOk = false;
          try {
            isOk = Statistics.StatisticsDelete(analysemianentity.getID());
          }
          catch (Exception ex) {
            return false;
          }
          return isOk;
  }
}
