package zr.zrpower.flowengine.web.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import zr.zrpower.web.bean.MessageBox;

import zr.zrpower.flowengine.mode.base.Package;
import zr.zrpower.flowengine.service.FlowSetup;
import zr.zrpower.entity.sys.SessionUser;
import zr.zrpower.common.util.FunctionMessage;


public class FlowPackage
    extends MessageBox {


  //Initialize global variables
  public void init() throws ServletException {
  }

  //Process the HTTP Get request
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws
      ServletException, IOException {

    request.setCharacterEncoding("GBK");
    response.setContentType("text/html; charset=GBK");
    String strAction = request.getParameter("Act");

    HttpSession session = request.getSession(true);
    SessionUser user = (SessionUser)session.getAttribute("userinfo");

    if (!strAction.equals(null)) {
      if (strAction.equals("edit")) {
        EditFlowpk(request,response);
      }

      if (strAction.equals("del")) {
        DeleteFlowpk(request,response);
      }

      if (strAction.equals("add")) {
        AddFlowpk(request,response,user.getUnitID());
      }
   }
}

  //Process the HTTP Post request
  public void doPost(HttpServletRequest request,HttpServletResponse response) throws
      ServletException, IOException {
    doGet(request, response);
  }

  //Clean up resources
  public void destroy() {
  }

  //޸̰Ϣ
  private void EditFlowpk(HttpServletRequest request,
                        HttpServletResponse response) throws IOException {
    FunctionMessage fm = new FunctionMessage(1);
    Package FlowPkID = new Package();
    FlowPkID.fullDataFromRequest(request);
    try {

      FlowSetup FlowPackage = new FlowSetup();
      fm = FlowPackage.EditFlowPk(FlowPkID);
      if (fm.getResult()) {
        FlowPackage = null;
        response.sendRedirect("ZrWorkFlow/flowconfig/Other/CloseWindow.jsp");
      }
      else {
        this.Msg = fm.getMessage();
        this.isOk = fm.getResult();
      }
      FlowPackage = null;
    }
    catch (Exception ex) {
      this.Msg = "ļмʧܣ<br>ϸϢ" + ex.toString();
    }

    this.out = response.getWriter();
    this.returnPath = "ZrWorkFlow/flowconfig/Other/CloseWindow.jsp";
    //this.GetBox();
  }

  //ɾ̰
  private void DeleteFlowpk(HttpServletRequest request,
                          HttpServletResponse response) throws IOException {
    try {
      FunctionMessage fm = new FunctionMessage(1);
      FlowSetup FlowPackage = new FlowSetup();
      String strID = request.getParameter("ID");
      if (FlowPackage.DeleteFlowPk(strID)){
         FlowPackage = null;
         response.sendRedirect("ZrWorkFlow/flowconfig/Other/CloseWindow.jsp");
     }
      else {
        this.isOk = false;
       this.Msg = "ǰ,ɾ";
         this.returnPath ="ZrWorkFlow/flowconfig/Other/CloseWindow.jsp";
      }
   }
    catch (Exception ex) {
      this.Msg = "ļмʧܣ<br>ϸϢ" + ex.toString();
    }
    this.out = response.getWriter();
    this.returnPath = "ZrWorkFlow/flowconfig/Other/CloseWindow.jsp";
    //this.GetBox();
  }
  //̰
  private void AddFlowpk(HttpServletRequest request, HttpServletResponse response,String UNITID) throws
      IOException {
    FunctionMessage fm = new FunctionMessage(1);
    Package FlowPkID = new Package();
    try {
      FlowSetup FlowPackage = new FlowSetup();
      FlowPkID.fullDataFromRequest(request);
      fm = FlowPackage.AddFlowPk(FlowPkID,UNITID);
      if (fm.getResult()) {
         FlowPkID = null;
         FlowPackage = null;
         response.sendRedirect("ZrWorkFlow/flowconfig/Other/CloseWindow.jsp");
      }
      else {
         this.Msg = fm.getMessage();
         this.isOk = fm.getResult();
         FlowPkID = null;
         FlowPackage = null;
         this.returnPath = "ZrWorkFlow/flowconfig/Other/CloseWindow.jsp";
      }
    }
    catch (Exception ex2) {
      this.Msg = "ӿͻļмʧܣ<br>ϸϢ<br>   " + ex2.toString();
    }

    this.out = response.getWriter();
    this.returnPath = "ZrWorkFlow/flowconfig/Other/CloseWindow.jsp";
    //this.GetBox();
  }
}
