package zr.zrpower.web.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import zr.zrpower.ejb.sys.UserService;

public class ShowUserPhoto extends HttpServlet {

    //Initialize global variables
    public void init() throws ServletException {
    }

    //Process the HTTP Get request
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws
            ServletException, IOException {
        String strAct = request.getParameter("Act");
        if (strAct != null) {
            if (strAct.equals("photo")) {
                ShowUserPhoto(request.getParameter("userid"), response);
            }
            if (strAct.equals("face")) {
                ShowUserFace(request.getParameter("userid"),
                             request.getParameter("faceid"), response);
            }
            if (strAct.equals("idiograph")) {
               ShowIdiograph(request.getParameter("userid"), response);
            }
        }
    }

    //Process the HTTP Post request
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws
            ServletException, IOException {
        doGet(request, response);
    }

    //Clean up resources
    public void destroy() {
    }

    private void ShowUserPhoto(String UserID, HttpServletResponse response) throws
            ServletException, IOException {
        try {
          UserService userMgr = new UserService();
          byte[] mImage = userMgr.GetUserPhoto(UserID);
          if (mImage != null) {
            response.reset();
            response.setContentType("image/jpeg");
            ServletOutputStream op = response.getOutputStream();
            op.write(mImage);
            op.flush();
            op.close();

            userMgr = null;
            op = null;
          }
          else {
            response.sendRedirect("zrsysmanage/images/NoImage.gif");
          }
        }
        catch (Exception ex) {
          response.sendRedirect("zrsysmanage/images/NoImage.gif");
        }
    }

    private void ShowIdiograph(String UserID, HttpServletResponse response) throws
            ServletException, IOException {
        try {
          UserService userMgr = new UserService();
          byte[] mImage = userMgr.GetUserIdiograph(UserID);
          if (mImage != null) {
            response.reset();
            response.setContentType("image/jpeg");
            ServletOutputStream op = response.getOutputStream();
            op.write(mImage);
            op.flush();
            op.close();
            userMgr = null;
            op = null;
          }
          else {
            response.sendRedirect("zrsysmanage/images/noiograph.gif");

          }
        }
        catch (Exception ex) {
          response.sendRedirect("zrsysmanage/images/noiograph.gif");
        }
    }

    private void ShowUserFace(String UserID, String FaceID,
                              HttpServletResponse response) throws
            ServletException, IOException {
        try {
          if (FaceID != null) {
            if (FaceID.equals("0")) {
              UserService userMgr = new UserService();
              byte[] mImage = userMgr.GetUserPhoto(UserID);
              if (mImage != null) {
                response.reset();
                response.setContentType("image/jpeg");
                ServletOutputStream op = response.getOutputStream();
                op.write(mImage);
                op.flush();
                op.close();

                userMgr = null;
                op = null;
              }
              else {
                response.sendRedirect("zrsysmanage/images/NoImage.gif");
              }
            }
            else {
              response.sendRedirect("zrsysmanage/images/face/" + FaceID + ".JPG");
            }
          }
          else {
            response.sendRedirect("zrsysmanage/images/NoImage.gif");
          }
        }
        catch (Exception ex) {
          response.sendRedirect("zrsysmanage/images/NoImage.gif");
        }
    }
}
