/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.flowengine.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import zr.zrpower.common.db.dbEngine;
import zr.zrpower.common.db.dbRow;
import zr.zrpower.common.db.dbSet;
import zr.zrpower.common.util.DateWork;
import zr.zrpower.common.util.FunctionMessage;
import zr.zrpower.common.util.Log;
import zr.zrpower.common.util.SysPreperty;
import zr.zrpower.entity.sys.BPIP_USER;
import zr.zrpower.flowengine.mode.monitor.FLOW_CONFIG_ENTRUST;
import zr.zrpower.flowengine.mode.monitor.FLOW_RUNTIME_ACTIVITY;
import zr.zrpower.flowengine.mode.monitor.FLOW_RUNTIME_ENTRUSTLOG;
import zr.zrpower.flowengine.mode.monitor.FLOW_RUNTIME_PROCESS;

public class FlowMonitor {
    private static Log log;
    static dbEngine dbengine;
    private static int clients;
    static String DataBaseType;
    static String strFlowRoleType;
    static Hashtable ADDHashtable1;
    static Hashtable ADDHashtable2;
    static Hashtable ADDHashtable3;
    static Hashtable ISADDHashtable4;
    static Hashtable ADDHashtable4;

    public FlowMonitor() {
        dbengine = new dbEngine(SysPreperty.getProperty().MainDataSource, SysPreperty.getProperty().IsConvert);
        dbengine.initialize();
        if (clients < 1) {
            log = new Log();
            log.SetLogForClass("FlowMonitor");
            log.SetLogFile("FlowMonitor.log");
        }
        clients = 1;
    }

    public FLOW_RUNTIME_PROCESS[] GetProList(int currentPage, int PageSize, String strWhere) {
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        String strSQL = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select B.ID,B.NAME,B.CREATEDATE,C.NAME AS CREATEPSN From FLOW_RUNTIME_PROCESS B Left Join BPIP_USER C on B.CREATEPSN=C.USERID where " + strWhere + " order by B.CREATEDATE desc");
        strSQL = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
        strSQL = addBuf.toString();
        dbSet dbset = dbengine.QuerySQL(strSQL);
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_PROCESS[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_RUNTIME_PROCESS();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetProList2(String strUserID, int currentPage, int PageSize, String strwhere) {
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        String strSQL = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select B.ID,B.NAME,B.CREATEDATE,C.NAME AS FACCEPTPSN,D.NAME AS CURRACTIVITY,E.NAME AS ACCEPTPSN From FLOW_RUNTIME_PROCESS B Left Join BPIP_USER C on B.FACCEPTPSN=C.USERID Left Join FLOW_CONFIG_ACTIVITY D on B.CURRACTIVITY=D.ID Left Join BPIP_USER E on B.ACCEPTPSN=E.USERID where ((B.CREATEPSN ='").append(strUserID + "' and B.ACCEPTPSN not like '" + strUserID + "' and B.STATE<>'4') or (B.ACCEPTPSN not like '").append(strUserID + "' and B.STATE<>'4')) and B.ID in (select FID from FLOW_RUNTIME_ACTIVITY where DOPSN='" + strUserID).append("' and DOFLAG='1') and " + strwhere + "order by B.CREATEDATE desc");
        strSQL = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
        strSQL = addBuf.toString();
        dbSet dbset = dbengine.QuerySQL(strSQL);
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_PROCESS[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_RUNTIME_PROCESS();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetProFinshList(String UserID, int currentPage, int PageSize, String strwhere) {
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        String strSQL = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select B.ID,B.NAME,B.CREATEDATE,B.FDATE,C.NAME AS FACCEPTPSN,D.NAME AS CURRACTIVITY,E.NAME AS ACCEPTPSN From FLOW_RUNTIME_PROCESS B Left Join BPIP_USER C on B.FACCEPTPSN=C.USERID Left Join FLOW_CONFIG_ACTIVITY D on B.CURRACTIVITY=D.ID Left Join BPIP_USER E on B.ACCEPTPSN=E.USERID where B.STATE='4' and B.ID in (select FID from FLOW_RUNTIME_ACTIVITY where DOPSN='" + UserID).append("' and DOFLAG='1') and " + strwhere + " order by B.CREATEDATE desc");
        strSQL = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
        dbSet dbset = dbengine.QuerySQL(strSQL);
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_PROCESS[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_RUNTIME_PROCESS();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public FunctionMessage delDaily(String strID) {
        boolean isOk = false;
        FunctionMessage fm = new FunctionMessage(1);
        try {
            isOk = dbengine.ExecuteDelete("FLOW_RUNTIME_ENTRUSTLOG", "ID=" + strID);
            if (isOk) {
                fm.setResult(true);
                fm.setMessage("\u65e5\u5fd7\u3010" + strID + "\u3011\u5df2\u7ecf\u5220\u9664");
            } else {
                fm.setMessage("\u5220\u9664\u4e0d\u6210\u529f");
                fm.setResult(false);
            }
        }
        catch (Exception e) {
            fm.setResult(false);
            fm.setMessage("\u8c03\u7528\u65b9\u6cd5delDaily\u51fa\u73b0\u5f02\u5e38" + e.toString());
            return fm;
        }
        return fm;
    }

    public boolean delDailyList() {
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Delete FLOW_RUNTIME_ENTRUSTLOG");
        return dbengine.ExecuteSQL(addBuf.toString());
    }

    public FLOW_RUNTIME_ENTRUSTLOG[] DailyList(int currentPage, int PageSize) {
        FLOW_RUNTIME_ENTRUSTLOG[] returnValue = null;
        String strSQL = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select B.ID,B.SDATE,B.EDATE,B.FLOWNAME,B.FLOWID,B.FLOWNODE,B.LOGDATE,B.TYPE,C.NAME AS SUSERNO,D.NAME AS IUSERNO From FLOW_RUNTIME_ENTRUSTLOG B Left Join BPIP_USER C on B.SUSERNO=C.USERID Left Join BPIP_USER D on B.IUSERNO=D.USERID order by B.LOGDATE desc");
        strSQL = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
        strSQL = addBuf.toString();
        dbSet dbset = dbengine.QuerySQL(strSQL);
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_ENTRUSTLOG[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_RUNTIME_ENTRUSTLOG();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetProList1(String strUserID, String strAllUnit, int currentPage, int PageSize, String type, String strwhere) {
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        String strSQL = "";
        String strTMP = "";
        String strTMP1 = "";
        String strATMP = "";
        String strUsers = "";
        String strFLOW1 = "";
        String strFLOW2 = "";
        String strFLOW3 = "";
        String strROLEID = "";
        strSQL = "select USERID from BPIP_USER where UNITID = '" + strAllUnit + "'";
        dbSet dbset0 = null;
        dbset0 = (dbSet)ADDHashtable1.get(strAllUnit);
        if (dbset0 == null && (dbset0 = dbengine.QuerySQL(strSQL)) != null) {
            ADDHashtable1.put(strAllUnit, dbset0);
        }
        if (dbset0 != null) {
            if (dbset0.RowCount() > 0) {
                for (int i = 0; i < dbset0.RowCount(); ++i) {
                    strATMP = i == 0 ? dbset0.Row(i).Column("USERID").getString() : strATMP + "," + dbset0.Row(i).Column("USERID").getString();
                }
            }
            dbset0 = null;
        }
        strUsers = strATMP;
        Hashtable<String, String> FlowHashtable = new Hashtable<String, String>();
        strSQL = "select ID,IDENTIFICATION from FLOW_CONFIG_PROCESS";
        dbSet dbset1 = null;
        dbset1 = (dbSet)ADDHashtable2.get("FLOW_CONFIG_PROCESS");
        if (dbset1 == null && (dbset1 = dbengine.QuerySQL(strSQL)) != null) {
            ADDHashtable2.put("FLOW_CONFIG_PROCESS", dbset1);
        }
        if (dbset1 != null && dbset1.RowCount() > 0) {
            for (int i = 0; i < dbset1.RowCount(); ++i) {
                FlowHashtable.put(dbset1.Row(i).Column("ID").getString(), dbset1.Row(i).Column("IDENTIFICATION").getString());
            }
            dbset1 = null;
        }
        strSQL = "select ROLEID from BPIP_USER_ROLE where USERID='" + strUserID + "'";
        dbSet db = null;
        db = (dbSet)ADDHashtable3.get(strUserID);
        if (db == null && (db = dbengine.QuerySQL(strSQL)) != null) {
            ADDHashtable3.put(strUserID, db);
        }
        if (db != null) {
            if (db.RowCount() > 0) {
                for (int i = 0; i < db.RowCount(); ++i) {
                    strATMP = i == 0 ? "'" + String.valueOf(db.Row(i).Column("ROLEID").getInteger()) + "'" : strATMP + ",'" + String.valueOf(db.Row(i).Column("ROLEID").getInteger()) + "'";
                }
            }
            db = null;
        }
        strROLEID = strATMP;
        strSQL = "select PROSESSID from FLOW_CONFIG_PROSESS_GROUP where ISDEPT='1' and TYPE='" + type + "' and GROUPID in (" + strROLEID + ")";
        dbSet dbset2 = null;
        strATMP = (String)ISADDHashtable4.get("1" + type + strROLEID);
        if (strATMP == null) {
            dbset2 = dbengine.QuerySQL(strSQL);
            if (dbset2 != null) {
                ADDHashtable4.put("1" + type + strROLEID, dbset2);
            }
            ISADDHashtable4.put("1" + type + strROLEID, "1");
        } else {
            dbset2 = (dbSet)ADDHashtable4.get("1" + type + strROLEID);
        }
        if (dbset2 != null) {
            if (dbset2.RowCount() > 0) {
                for (int i = 0; i < dbset2.RowCount(); ++i) {
                    strTMP = dbset2.Row(i).Column("PROSESSID").getString();
                    strTMP = (String)FlowHashtable.get(strTMP);
                    strFLOW1 = strFLOW1 + "'" + strTMP + "',";
                    strFLOW2 = strFLOW2 + "'" + strTMP + "',";
                }
            }
            dbset2 = null;
        }
        strSQL = "select PROSESSID from FLOW_CONFIG_PROSESS_GROUP where ISDEPT='0' and TYPE='" + type + "' and GROUPID in (" + strROLEID + ")";
        dbSet dbset3 = null;
        strATMP = (String)ISADDHashtable4.get("0" + type + strROLEID);
        if (strATMP == null) {
            dbset3 = dbengine.QuerySQL(strSQL);
            if (dbset3 != null) {
                ADDHashtable4.put("0" + type + strROLEID, dbset3);
            }
            ISADDHashtable4.put("0" + type + strROLEID, "1");
        } else {
            dbset3 = (dbSet)ADDHashtable4.get("0" + type + strROLEID);
        }
        if (dbset3 != null) {
            if (dbset3.RowCount() > 0) {
                for (int i = 0; i < dbset3.RowCount(); ++i) {
                    strTMP = dbset3.Row(i).Column("PROSESSID").getString();
                    strTMP = (String)FlowHashtable.get(strTMP);
                    strFLOW1 = strFLOW1 + "'" + strTMP + "',";
                    strFLOW3 = strFLOW3 + "'" + strTMP + "',";
                }
            }
            dbset3 = null;
        }
        if (strFLOW1.length() > 0) {
            strFLOW1 = strFLOW1.substring(0, strFLOW1.length() - 1);
        }
        if (strFLOW1.length() > 0) {
            strSQL = "Select B.ID,B.NAME,B.ACCEPTDATE,B.CREATEDATE,B.STATE,B.FLOWID,B.CREATEPSN AS CREATEPSN1,C.NAME AS FACCEPTPSN,D.NAME AS CURRACTIVITY,E.NAME AS ACCEPTPSN From FLOW_RUNTIME_PROCESS B Left Join BPIP_USER C on B.FACCEPTPSN=C.USERID Left Join FLOW_CONFIG_ACTIVITY D on B.CURRACTIVITY=D.ID Left Join BPIP_USER E on B.ACCEPTPSN=E.USERID where B.STATE<>'2' and B.STATE<>'3' and B.STATE<>'4' and B.FLOWID in (" + strFLOW1 + ") and " + strwhere + " order by B.CREATEDATE desc";
            log.WriteLog("GetAllotmentList sql:", strSQL);
            strSQL = "Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= " + String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize);
            dbSet dbset = dbengine.QuerySQL(strSQL);
            if (dbset != null) {
                if (dbset.RowCount() > 0) {
                    int i;
                    int rownum = 0;
                    for (i = 0; i < dbset.RowCount(); ++i) {
                        strTMP = dbset.Row(i).Column("FLOWID").getString();
                        strTMP1 = dbset.Row(i).Column("CREATEPSN1").getString();
                        if (strFLOW2.lastIndexOf(strTMP) > -1 && this.IsMatchDept(strTMP1, strUsers)) {
                            ++rownum;
                            continue;
                        }
                        if (strFLOW3.lastIndexOf(strTMP) <= -1) continue;
                        ++rownum;
                    }
                    returnValue = new FLOW_RUNTIME_PROCESS[rownum];
                    rownum = 0;
                    for (i = 0; i < dbset.RowCount(); ++i) {
                        strTMP = dbset.Row(i).Column("FLOWID").getString();
                        strTMP1 = dbset.Row(i).Column("CREATEPSN1").getString();
                        if (strFLOW2.lastIndexOf(strTMP) > -1 && this.IsMatchDept(strTMP1, strUsers)) {
                            returnValue[rownum] = new FLOW_RUNTIME_PROCESS();
                            returnValue[rownum].fullData(dbset.Row(i));
                            ++rownum;
                            continue;
                        }
                        if (strFLOW3.lastIndexOf(strTMP) <= -1) continue;
                        returnValue[rownum] = new FLOW_RUNTIME_PROCESS();
                        returnValue[rownum].fullData(dbset.Row(i));
                        ++rownum;
                    }
                }
                dbset = null;
            }
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS getPro(String ID) {
        FLOW_RUNTIME_PROCESS bp = new FLOW_RUNTIME_PROCESS();
        try {
            StringBuffer addBuf = new StringBuffer();
            addBuf.append("Select * From FLOW_RUNTIME_PROCESS Where ID='" + ID.trim() + "'");
            dbSet mdbset = dbengine.QuerySQL(addBuf.toString());
            if (mdbset == null) {
                return null;
            }
            if (mdbset.RowCount() > 0) {
                bp.fullData(mdbset.Row(0));
            }
            mdbset = null;
        }
        catch (Exception e) {
            return null;
        }
        return bp;
    }

    public boolean FlowDevolveManage(String strID, String strDOPSN, String strUserID, String strUNIT) {
        boolean returnValue = true;
        String strACCEPTPSN = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select ACCEPTPSN From FLOW_RUNTIME_PROCESS where ID='" + strID + "'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        if (dbset != null && dbset.RowCount() > 0) {
            strACCEPTPSN = dbset.Row(0).Column("ACCEPTPSN").getString();
        }
        strACCEPTPSN = strACCEPTPSN.replaceAll(strUserID, strDOPSN);
        String[] strSQLs = new String[2];
        addBuf.delete(0, addBuf.length());
        addBuf.append("update FLOW_RUNTIME_PROCESS set ACCEPTPSN='" + strACCEPTPSN + "' where ID='" + strID).append("'");
        strSQLs[0] = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("update FLOW_RUNTIME_ACTIVITY set DOPSN='" + strDOPSN + "' where FID='").append(strID + "' and DOPSN='" + strUserID + "'");
        strSQLs[1] = addBuf.toString();
        dbengine.ExecuteSQLs(strSQLs);
        String strName = this.GetFlowRunName(strID);
        String strCurrAID = this.GetCurrActivityID(strID);
        String strCurrAName = this.GetActivityName(strCurrAID);
        this.InsertFlowLog(strUserID, strDOPSN, "", "", "3", strName, strID, strCurrAName);
        return returnValue;
    }

    public HashMap GetUserList() {
        HashMap<String, String> resultValue = new HashMap<String, String>();
        String strSQL = "Select USERID,NAME From BPIP_USER order by ORBERCODE,USERID";
        dbSet set = dbengine.QuerySQL(strSQL);
        if (set != null) {
            if (set.RowCount() > 0) {
                for (int i = 0; i < set.RowCount(); ++i) {
                    resultValue.put(set.Row(i).Column("USERID").getString(), set.Row(i).Column("NAME").getString());
                }
            }
            set = null;
        }
        return resultValue;
    }

    public HashMap GetActivityList() {
        HashMap<String, String> resultValue = new HashMap<String, String>();
        String strSQL = "Select ID,NAME From FLOW_CONFIG_ACTIVITY";
        dbSet set = dbengine.QuerySQL(strSQL);
        if (set != null) {
            if (set.RowCount() > 0) {
                for (int i = 0; i < set.RowCount(); ++i) {
                    resultValue.put(set.Row(i).Column("ID").getString(), set.Row(i).Column("NAME").getString());
                }
            }
            set = null;
        }
        return resultValue;
    }

    public String GetActivityName1(String strID) {
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select NAME from FLOW_CONFIG_ACTIVITY where ID = '" + strID + "'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                addBuf.append(dbset.Row(0).Column("NAME").getString());
            }
            dbset = null;
        }
        return addBuf.toString();
    }

    public FLOW_CONFIG_ENTRUST[] GetMonitorList(String userid) {
        FLOW_CONFIG_ENTRUST[] returnValue = null;
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select a.ID,a.SDATE,a.EDATE,b.NAME as IUSERNO From FLOW_CONFIG_ENTRUST a Left Join BPIP_USER b on a.IUSERNO=b.USERID Where a.SUSERNO ='").append(userid + "'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_CONFIG_ENTRUST[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_CONFIG_ENTRUST();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    private ArrayList GetArrayList(String strItems, String strItemMark) {
        int i = 0;
        int n = 0;
        strItems = strItems + strItemMark;
        ArrayList<String> strList = new ArrayList<String>();
        int intItemLen = strItems.length();
        while (i < intItemLen) {
            n = strItems.indexOf(strItemMark, i);
            String strItem = strItems.substring(i, n);
            strList.add(strItem);
            i = n + 1;
        }
        return strList;
    }

    public FunctionMessage AddEntrust(FLOW_CONFIG_ENTRUST Entrust, String strUNIT) {
        ArrayList arrList_User_No = new ArrayList();
        arrList_User_No = this.GetArrayList(Entrust.getIUSERNO(), ",");
        FunctionMessage fm = new FunctionMessage(1);
        String strid = "";
        String MaxNo = strid = this.GetMaxFieldNo("FLOW_CONFIG_ENTRUST", "ID", 8);
        try {
            for (int i = 0; i < arrList_User_No.size(); ++i) {
                if (i > 0) {
                    MaxNo = String.valueOf(Integer.parseInt(MaxNo) + 1);
                    int LenMaxNo = MaxNo.length();
                    MaxNo = "0000000000000000000000000" + MaxNo;
                    MaxNo = MaxNo.substring(17 + LenMaxNo);
                }
                Entrust.setID(MaxNo);
                Entrust.setIUSERNO(arrList_User_No.get(i).toString());
                if (!dbengine.ExecuteInsert(Entrust.getData())) continue;
                fm.setMessage("\u589e\u52a0\u4eba\u5458\u4fdd\u5b58\u6210\u529f");
                fm.setResult(true);
                DateWork dw = new DateWork();
                String strSdate = dw.DateTimeToString(Entrust.getSDATE());
                String strEdate = dw.DateTimeToString(Entrust.getEDATE());
                if (strSdate.length() > 0) {
                    strSdate = strSdate.substring(0, 10);
                }
                if (strEdate.length() > 0) {
                    strEdate = strEdate.substring(0, 10);
                }
                this.InsertFlowLog(Entrust.getSUSERNO(), arrList_User_No.get(i).toString(), strSdate, strEdate, "4", "", "", "");
            }
        }
        catch (Exception e) {
            fm.setResult(false);
            fm.setMessage("\u8c03\u7528\u65b9\u6cd5AddEntrust\u51fa\u73b0\u5f02\u5e38" + e.toString());
            return fm;
        }
        return fm;
    }

    public BPIP_USER[] GetentrustName() {
        BPIP_USER[] entrust = null;
        try {
            String strSQL = "Select * From BPIP_USER";
            dbSet mdbset = dbengine.QuerySQL(strSQL);
            entrust = new BPIP_USER[mdbset.RowCount()];
            if (mdbset.RowCount() == 0) {
                return null;
            }
            for (int i = 0; i < mdbset.RowCount(); ++i) {
                entrust[i] = new BPIP_USER();
                entrust[i].fullData(mdbset.Row(i));
            }
            Object var3_4 = null;
        }
        catch (Exception e) {
            return null;
        }
        return entrust;
    }

    public FLOW_CONFIG_ENTRUST getEntrustID(String ID) {
        FLOW_CONFIG_ENTRUST bp = new FLOW_CONFIG_ENTRUST();
        FunctionMessage fm = new FunctionMessage(1);
        try {
            StringBuffer addBuf = new StringBuffer();
            addBuf.append("Select * From FLOW_CONFIG_ENTRUST Where ID='" + ID + "'");
            dbSet mdbset = dbengine.QuerySQL(addBuf.toString());
            if (mdbset != null) {
                bp.fullData(mdbset.Row(0));
                mdbset = null;
            } else {
                fm.setResult(false);
                fm.setMessage("\u4f60\u6ca1\u6709\u7f16\u8f91\u7684\u6743\u9650");
            }
        }
        catch (Exception e) {
            return null;
        }
        return bp;
    }

    public FunctionMessage DeleteEntrust(String ID) {
        FunctionMessage fm = new FunctionMessage(1);
        try {
            StringBuffer addBuf = new StringBuffer();
            addBuf.append("Delete From FLOW_CONFIG_ENTRUST where ID='" + ID + "'");
            dbengine.ExecuteSQL(addBuf.toString());
            fm.setResult(true);
            fm.setMessage("\u5df2\u7ecf\u6210\u529f\u5220\u9664");
        }
        catch (Exception e) {
            fm.setResult(false);
            fm.setMessage("\u8c03\u7528\u65b9\u6cd5DeleteEntrust\u51fa\u73b0\u5f02\u5e38" + e.toString());
            return fm;
        }
        return fm;
    }

    public FunctionMessage EditEntrust(FLOW_CONFIG_ENTRUST Entrust) {
        boolean isOk = false;
        FunctionMessage fm = new FunctionMessage(1);
        try {
            dbRow row = Entrust.getData();
            isOk = dbengine.ExecuteEdit(row, "ID=" + Entrust.getID());
            if (isOk) {
                fm.setResult(true);
                fm.setMessage("\u4fee\u6539\u6210\u529f");
            } else {
                fm.setResult(false);
                fm.setMessage("\u3010" + Entrust.getID() + "\u3011\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e) {
            fm.setResult(false);
            fm.setMessage("\u8c03\u7528\u65b9\u6cd5EditEntrust\u51fa\u73b0\u5f02\u5e38" + e.toString());
            return fm;
        }
        return fm;
    }

    public String GetTrueName(String strIUSERNO) {
        StringBuffer addBuf = new StringBuffer();
        if (strIUSERNO.indexOf(",") > -1) {
            if (strIUSERNO.indexOf("'") == -1) {
                strIUSERNO = strIUSERNO.replaceAll(",", "','");
                addBuf.append("'" + strIUSERNO + "'");
                strIUSERNO = addBuf.toString();
            }
        } else if (strIUSERNO.indexOf("'") == -1) {
            addBuf.append("'" + strIUSERNO + "'");
            strIUSERNO = addBuf.toString();
        }
        addBuf.delete(0, addBuf.length());
        addBuf.append("select NAME from BPIP_USER where USERID in (" + strIUSERNO + ")");
        dbSet mdbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        if (mdbset != null) {
            for (int i = 0; i < mdbset.RowCount(); ++i) {
                if (addBuf.toString().length() > 0) {
                    addBuf.append("," + mdbset.Row(i).Column("NAME").getString());
                    continue;
                }
                addBuf.append(mdbset.Row(i).Column("NAME").getString());
            }
            mdbset = null;
        }
        return addBuf.toString();
    }

    public String GetDateAsStr() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String mDateTime = formatter.format(cal.getTime());
        return mDateTime;
    }

    public FLOW_RUNTIME_ACTIVITY[] GetOkList(String strWhere) {
        FLOW_RUNTIME_ACTIVITY[] returnValue = null;
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select * From FLOW_RUNTIME_ACTIVITY " + strWhere);
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_ACTIVITY[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_RUNTIME_ACTIVITY();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetProActList(String strWhere) {
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        dbSet dbset = null;
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select ID From FLOW_RUNTIME_ACTIVITY " + strWhere);
        dbSet dbset1 = dbengine.QuerySQL(addBuf.toString());
        if (dbset1 != null) {
            addBuf.delete(0, addBuf.length());
            addBuf.append("select * from FLOW_RUNTIME_PROCESS where ID='" + dbset1.Row(0).Column("FID").getString().trim()).append("'");
            dbset = dbengine.QuerySQL(addBuf.toString());
            dbset1 = null;
        }
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_PROCESS[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_RUNTIME_PROCESS();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public boolean FlowEntrustManage(String strID, String strDOPSN, String strUserID, String strUNIT) {
        boolean returnValue = true;
        String strACCEPTPSN = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select ACCEPTPSN From FLOW_RUNTIME_PROCESS where ID='" + strID + "'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                strACCEPTPSN = dbset.Row(0).Column("ACCEPTPSN").getString();
            }
            dbset = null;
        }
        strACCEPTPSN = strACCEPTPSN.replaceAll(strUserID, strDOPSN);
        String[] strSQLs = new String[2];
        addBuf.delete(0, addBuf.length());
        addBuf.append("update FLOW_RUNTIME_PROCESS set ACCEPTPSN='" + strACCEPTPSN + "' where ID='" + strID).append("'");
        strSQLs[0] = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("update FLOW_RUNTIME_ACTIVITY set DOPSN='" + strDOPSN + "' where FID='" + strID).append("' and DOPSN='" + strUserID + "' and DOFLAG='0'");
        strSQLs[1] = addBuf.toString();
        dbengine.ExecuteSQLs(strSQLs);
        String strName = this.GetFlowRunName(strID);
        String strCurrAID = this.GetCurrActivityID(strID);
        String strCurrAName = this.GetActivityName(strCurrAID);
        this.InsertFlowLog(strUserID, strDOPSN, "", "", "2", strName, strID, strCurrAName);
        return returnValue;
    }

    private boolean IsMatchDept(String strDo, String strUsers) {
        boolean returnValue = false;
        String strTmp = "";
        ArrayList arrList1 = new ArrayList();
        arrList1 = this.GetArrayList(strDo, ",");
        for (int i = 0; i < arrList1.size(); ++i) {
            strTmp = arrList1.get(i).toString();
            if (strUsers.lastIndexOf(strTmp) <= -1) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public boolean FlowAnewManage(String strID, String strDOPSN, String strUserID, String strUNIT) {
        boolean returnValue = true;
        DateWork dw = new DateWork();
        String strSENDPSN = "";
        String strSENDDATE = "";
        String strSACTIVITY = "";
        String strEACTIVITY = "";
        String strNAME = "";
        String strDoUser = "";
        String strRunID = "";
        int UserNum = 0;
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select SENDPSN,SENDDATE,SACTIVITY,EACTIVITY,NAME From FLOW_RUNTIME_ACTIVITY where DOFLAG='0' and FID='").append(strID + "'");
        dbSet dbset1 = dbengine.QuerySQL(addBuf.toString());
        if (dbset1 != null) {
            if (dbset1.RowCount() > 0) {
                strSENDPSN = dbset1.Row(0).Column("SENDPSN").getString();
                strSENDDATE = dw.DateTimeToString(dbset1.Row(0).Column("SENDDATE").getDate());
                if (strSENDDATE.length() > 10) {
                    strSENDDATE = strSENDDATE.substring(0, 10);
                }
                strSACTIVITY = dbset1.Row(0).Column("SACTIVITY").getString();
                strEACTIVITY = dbset1.Row(0).Column("EACTIVITY").getString();
                strNAME = dbset1.Row(0).Column("NAME").getString();
            }
            dbset1 = null;
        }
        addBuf.delete(0, addBuf.length());
        addBuf.append("delete from FLOW_RUNTIME_ACTIVITY where DOFLAG='0' and FID='" + strID + "'");
        dbengine.ExecuteSQL(addBuf.toString());
        ArrayList UserList = new ArrayList();
        UserList = this.GetArrayList(strDOPSN, ",");
        UserNum = UserList.size();
        addBuf.delete(0, addBuf.length());
        addBuf.append("update FLOW_RUNTIME_PROCESS set ACCEPTPSN='" + strDOPSN + "',ACCEPTPSNNUM=").append(UserNum + " where ID='" + strID + "'");
        dbengine.ExecuteSQL(addBuf.toString());
        for (int i = 0; i < UserList.size(); ++i) {
            strDoUser = UserList.get(i).toString();
            strRunID = this.GetFLOW_RUNTIME_ACTIVITY_ID();
            addBuf.delete(0, addBuf.length());
            if (DataBaseType.equals("2")) {
                addBuf.append("Insert into FLOW_RUNTIME_ACTIVITY(ID,FID,SACTIVITY,EACTIVITY,NAME,DOPSN,DOFLAG,DOIP,SENDPSN,SENDDATE) values ('").append(strRunID + "','" + strID + "','" + strSACTIVITY + "','" + strEACTIVITY).append("','" + strNAME + "','" + strDoUser + "','0','','" + strSENDPSN + "','").append(strSENDDATE + "')");
            } else {
                addBuf.append("Insert into FLOW_RUNTIME_ACTIVITY(ID,FID,SACTIVITY,EACTIVITY,NAME,DOPSN,DOFLAG,DOIP,SENDPSN,SENDDATE) values ('").append(strRunID + "','" + strID + "','" + strSACTIVITY + "','" + strEACTIVITY).append("','" + strNAME + "','" + strDoUser + "','0','','" + strSENDPSN + "',to_date('").append(strSENDDATE + "','yyyy-mm-dd'))");
            }
            dbengine.ExecuteSQL(addBuf.toString());
        }
        String strName = this.GetFlowRunName(strID);
        String strCurrAID = this.GetCurrActivityID(strID);
        String strCurrAName = this.GetActivityName(strCurrAID);
        this.InsertFlowLog(strUserID, strDOPSN, "", "", "1", strName, strID, strCurrAName);
        return returnValue;
    }

    private String GetFLOW_RUNTIME_ACTIVITY_ID() {
        String strValue = "";
        String strNum = "";
        try {
            strNum = this.myGetRandom(4);
        }
        catch (Exception ex) {
            strNum = "0";
        }
        strValue = "S" + this.GlobalID1() + strNum;
        int znum = 20 - strValue.length();
        for (int k = 0; k < znum; ++k) {
            strValue = strValue + "0";
        }
        if (strValue.length() > 20) {
            strValue = strValue.substring(0, 20);
        }
        return strValue;
    }

    private String myGetRandom(int i) {
        Random s = new Random();
        if (i == 0) {
            return "";
        }
        String revalue = "";
        for (int k = 0; k < i; ++k) {
            revalue = revalue + s.nextInt(9);
        }
        return revalue;
    }

    private String GlobalID1() {
        String strResult = "";
        try {
            Date dt = new Date();
            long lg = dt.getTime();
            Long ld = new Long(lg);
            strResult = ld.toString();
        }
        catch (Exception ex) {
            strResult = "";
        }
        return strResult;
    }

    private String GetMaxFieldNo(String TableName, String FieldName, int FieldLen) {
        String MaxNo = "";
        int LenMaxNo = 0;
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("SELECT MAX(" + FieldName + ") AS MaxNo FROM " + TableName);
        try {
            dbSet dbset = dbengine.QuerySQL(addBuf.toString());
            if (dbset != null) {
                if (dbset.RowCount() > 0) {
                    MaxNo = dbset.Row(0).Column("MaxNo").getString();
                    if (MaxNo.length() > 0) {
                        MaxNo = String.valueOf(Integer.parseInt(MaxNo) + 1);
                        LenMaxNo = MaxNo.length();
                        addBuf.delete(0, addBuf.length());
                        addBuf.append("0000000000000000000000000" + MaxNo);
                        MaxNo = addBuf.toString();
                    } else {
                        MaxNo = "00000000000000000000000001";
                        LenMaxNo = 1;
                    }
                }
                dbset = null;
            }
            MaxNo = MaxNo.substring(25 - FieldLen + LenMaxNo);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        return MaxNo;
    }

    private String GetArrList(String strString) {
        String strNode_S_No = "";
        String strNode_S_Name = "";
        String returnValue = "";
        if (strString.trim().length() == 0) {
            return "";
        }
        if (strString.trim().length() == 16) {
            strNode_S_Name = this.GetUserName(strString);
            return strNode_S_Name;
        }
        int i = 0;
        ArrayList arrList_strNode_No = new ArrayList();
        arrList_strNode_No = this.GetArrayList(strString, ",");
        for (i = 0; i < arrList_strNode_No.size(); ++i) {
            strNode_S_No = arrList_strNode_No.get(i).toString();
            strNode_S_Name = this.GetUserName(strNode_S_No);
            returnValue = returnValue + strNode_S_Name + ",";
        }
        if (returnValue.length() > 0) {
            returnValue = returnValue.substring(0, returnValue.length() - 1);
        }
        return returnValue;
    }

    private String GetUserName(String userId) {
        String resultValue = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select NAME From BPIP_USER where USERID='" + userId.trim() + "'");
        dbSet set = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        if (set != null) {
            if (set.RowCount() > 0) {
                addBuf.append(set.Row(0).Column("NAME").getString());
            }
            set = null;
        }
        return resultValue;
    }

    public HashMap GetUserList(String field) {
        HashMap<String, String> resultValue = new HashMap<String, String>();
        String trueName = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select " + field.trim() + " From FLOW_RUNTIME_PROCESS");
        dbSet set = dbengine.QuerySQL(addBuf.toString());
        if (set != null) {
            if (set.RowCount() > 0) {
                for (int i = 0; i < set.RowCount(); ++i) {
                    trueName = this.GetArrList(set.Row(i).Column(field.trim()).getString());
                    resultValue.put(set.Row(i).Column(field.trim()).getString().trim(), trueName.trim());
                }
            }
            set = null;
        }
        return resultValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetFlowTransactList(String strUserNo, String type) {
        dbSet dbset;
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        String strSQL = "";
        String strCid = "";
        String strFLOWPATH = "";
        int ListNum = 0;
        int cNum = 0;
        int gnum = 0;
        String row = "8";
        row = type.equals("1") ? "8" : "500";
        dbSet dbsend = null;
        strSQL = "Select count(ID) as num From FLOW_RUNTIME_ACTIVITY where DOFLAG='0' and DOIDEA='send' and DOPSN='" + strUserNo + "'";
        dbsend = dbengine.QuerySQL(strSQL);
        if (dbsend != null && dbsend.RowCount() > 0) {
            gnum = dbsend.Row(0).Column("num").getInteger();
        }
        dbsend = null;
        if (gnum > 0) {
            strSQL = DataBaseType.equals("2") ? "Select top " + row + " a.ID,a.FLOWID,a.FLOWPATH,a.RID,a.CURRACTIVITY,a.ACCEPTDATE,a.FORMID,b.DOIP,b.NAME From FLOW_RUNTIME_PROCESS a left join FLOW_RUNTIME_ACTIVITY b on a.ID=b.FID where b.DOFLAG='0' and b.DOIDEA='send' and DOPSN='" + strUserNo + "'  order by b.SENDDATE desc" : "Select a.ID,a.FLOWID,a.FLOWPATH,a.RID,a.CURRACTIVITY,a.ACCEPTDATE,a.FORMID,b.DOIP,b.NAME From FLOW_RUNTIME_PROCESS a left join FLOW_RUNTIME_ACTIVITY b on a.ID=b.FID where b.DOFLAG='0' and b.DOIDEA='send' and DOPSN='" + strUserNo + "' and rownum<" + row + " order by b.SENDDATE desc";
            dbsend = dbengine.QuerySQL(strSQL);
        }
        if ((dbset = dbengine.QuerySQL(strSQL = DataBaseType.equals("2") ? "Select top " + row + " ID,FLOWID,FLOWPATH,RID,CURRACTIVITY,ACCEPTDATE,NAME,FORMID From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%" + strUserNo + "%'  order by ID desc" : "Select ID,FLOWID,FLOWPATH,RID,CURRACTIVITY,ACCEPTDATE,NAME,FORMID From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%" + strUserNo + "%' and rownum<" + row + " order by ID desc")) != null && dbset.RowCount() > 0) {
            cNum = dbset.RowCount();
        }
        if (dbsend != null && dbsend.RowCount() > 0) {
            cNum += dbsend.RowCount();
        }
        if (cNum > 0) {
            returnValue = new FLOW_RUNTIME_PROCESS[cNum];
        }
        try {
            int i;
            if (dbset != null) {
                if (dbset.RowCount() > 0) {
                    for (i = 0; i < dbset.RowCount(); ++i) {
                        returnValue[ListNum] = new FLOW_RUNTIME_PROCESS();
                        returnValue[ListNum].fullData(dbset.Row(i));
                        ++ListNum;
                    }
                }
                dbset = null;
            }
            if (dbsend != null && dbsend.RowCount() > 0) {
                for (i = 0; i < dbsend.RowCount(); ++i) {
                    strCid = dbsend.Row(i).Column("DOIP").getString();
                    strFLOWPATH = dbsend.Row(i).Column("FLOWPATH").getString();
                    strFLOWPATH = strFLOWPATH + "&sendid=" + strCid;
                    dbsend.Row(i).Column("FLOWPATH").setValue((Object)strFLOWPATH);
                    dbsend.Row(i).Column("RID").setValue((Object)"send");
                    returnValue[ListNum] = new FLOW_RUNTIME_PROCESS();
                    returnValue[ListNum].fullData(dbsend.Row(i));
                    ++ListNum;
                }
            }
        }
        catch (Exception ex1) {
            log.WriteLog("\u51fa\u9519GetFlowTransactList:" + ex1.toString());
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetFlowTransactList1(String strFID, String strUserNo) {
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        String strCURRACTIVITY = "";
        String strSignType = "";
        String strACCEPTPSN = "";
        String tmpUserNo = "";
        int ListNum = 0;
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select * From FLOW_RUNTIME_PROCESS where PARENTID='" + strFID).append("' and STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%' order by ACCEPTDATE desc");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select CURRACTIVITY From FLOW_RUNTIME_PROCESS where PARENTID='" + strFID).append("' and STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%" + strUserNo).append("%'");
        String strWhere = addBuf.toString();
        Hashtable SignType = new Hashtable();
        SignType = this.GetSignTypeHashtable(strWhere);
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_PROCESS[this.GetFlowTransactNum1(strFID, strUserNo)];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    strCURRACTIVITY = dbset.Row(i).Column("CURRACTIVITY").getString();
                    strACCEPTPSN = dbset.Row(i).Column("ACCEPTPSN").getString();
                    try {
                        strSignType = (String)SignType.get(strCURRACTIVITY);
                        if (strSignType == null) {
                            strSignType = "0";
                        }
                    }
                    catch (Exception ex) {
                        log.WriteErrorLog("\u9519\u8bef\u4fe1\u606f:", ex.toString());
                    }
                    if (strSignType.equals("1")) {
                        ArrayList UserList = new ArrayList();
                        UserList = this.GetArrayList(strACCEPTPSN, ",");
                        tmpUserNo = UserList.get(0).toString();
                        if (!tmpUserNo.equals(strUserNo)) continue;
                        returnValue[ListNum] = new FLOW_RUNTIME_PROCESS();
                        returnValue[ListNum].fullData(dbset.Row(i));
                        ++ListNum;
                        continue;
                    }
                    returnValue[ListNum] = new FLOW_RUNTIME_PROCESS();
                    returnValue[ListNum].fullData(dbset.Row(i));
                    ++ListNum;
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetFlowTransactParentList(String strUserNo) {
        FLOW_RUNTIME_PROCESS[] returnValue = null;
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select distinct PARENTID From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%' order by PARENTID");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                returnValue = new FLOW_RUNTIME_PROCESS[dbset.RowCount()];
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    returnValue[i] = new FLOW_RUNTIME_PROCESS();
                    returnValue[i].fullData(dbset.Row(i));
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    private int GetFlowTransactNum(String strUserNo) {
        int returnValue = 0;
        String strCURRACTIVITY = "";
        String strSignType = "";
        String strACCEPTPSN = "";
        String tmpUserNo = "";
        StringBuffer addBuf = new StringBuffer();
        if (DataBaseType.equals("2")) {
            addBuf.append("Select top 500 CURRACTIVITY,ACCEPTPSN From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%' order by ACCEPTDATE desc");
        } else {
            addBuf.append("Select CURRACTIVITY,ACCEPTPSN From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%'  and rownum<500 order by ACCEPTDATE desc");
        }
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select CURRACTIVITY From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%'");
        String strWhere = addBuf.toString();
        Hashtable SignType = new Hashtable();
        SignType = this.GetSignTypeHashtable(strWhere);
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    strCURRACTIVITY = dbset.Row(i).Column("CURRACTIVITY").getString();
                    strACCEPTPSN = dbset.Row(i).Column("ACCEPTPSN").getString();
                    try {
                        strSignType = (String)SignType.get(strCURRACTIVITY);
                        if (strSignType == null) {
                            strSignType = "0";
                        }
                    }
                    catch (Exception ex) {
                        log.WriteErrorLog("\u9519\u8bef\u4fe1\u606f:", ex.toString());
                    }
                    if (strSignType.equals("1")) {
                        ArrayList UserList = new ArrayList();
                        UserList = this.GetArrayList(strACCEPTPSN, ",");
                        tmpUserNo = UserList.get(0).toString();
                        if (!tmpUserNo.equals(strUserNo)) continue;
                        ++returnValue;
                        continue;
                    }
                    ++returnValue;
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    private int GetFlowTransactNum1(String strFID, String strUserNo) {
        int returnValue = 0;
        String strCURRACTIVITY = "";
        String strSignType = "";
        String strACCEPTPSN = "";
        String tmpUserNo = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select CURRACTIVITY,ACCEPTPSN From FLOW_RUNTIME_PROCESS where PARENTID='" + strFID).append("' and STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%" + strUserNo + "%'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select CURRACTIVITY From FLOW_RUNTIME_PROCESS where PARENTID='" + strFID).append("' and STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%" + strUserNo).append("%'");
        String strWhere = addBuf.toString();
        Hashtable SignType = new Hashtable();
        SignType = this.GetSignTypeHashtable(strWhere);
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    strCURRACTIVITY = dbset.Row(i).Column("CURRACTIVITY").getString();
                    strACCEPTPSN = dbset.Row(i).Column("ACCEPTPSN").getString();
                    try {
                        strSignType = (String)SignType.get(strCURRACTIVITY);
                        if (strSignType == null) {
                            strSignType = "0";
                        }
                    }
                    catch (Exception ex) {
                        log.WriteErrorLog("\u9519\u8bef\u4fe1\u606f:", ex.toString());
                    }
                    if (strSignType.equals("1")) {
                        ArrayList UserList = new ArrayList();
                        UserList = this.GetArrayList(strACCEPTPSN, ",");
                        tmpUserNo = UserList.get(0).toString();
                        if (!tmpUserNo.equals(strUserNo)) continue;
                        ++returnValue;
                        continue;
                    }
                    ++returnValue;
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    private Hashtable GetSignTypeHashtable(String strWhere) {
        Hashtable<String, String> SignType = new Hashtable<String, String>();
        String strID = "";
        String strISSIGN = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("select ID,ISSIGN from FLOW_CONFIG_ACTIVITY where ID in (" + strWhere + ")");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    strID = dbset.Row(i).Column("ID").getString();
                    strISSIGN = dbset.Row(i).Column("ISSIGN").getString();
                    if (strISSIGN == null) {
                        strISSIGN = "0";
                    }
                    SignType.put(strID, strISSIGN);
                }
            }
            dbset = null;
        }
        return SignType;
    }

    private boolean InsertFlowLog(String strSUSERNO, String strIUSERNO, String strSDATE, String strEDATE, String strTYPE, String strFLOWNAME, String strFLOWID, String strFLOWNODE) {
        String tmpUserNo = "";
        String strMaxID = "";
        ArrayList UserList = new ArrayList();
        StringBuffer addBuf = new StringBuffer();
        UserList = this.GetArrayList(strIUSERNO, ",");
        for (int i = 0; i < UserList.size(); ++i) {
            tmpUserNo = UserList.get(i).toString();
            strMaxID = this.GetMaxFieldNo("FLOW_RUNTIME_ENTRUSTLOG", "ID", 8);
            addBuf.delete(0, addBuf.length());
            addBuf.append("Insert into FLOW_RUNTIME_ENTRUSTLOG(ID,SUSERNO,IUSERNO,SDATE,EDATE,TYPE,FLOWNAME,FLOWID,FLOWNODE,LOGDATE) values ('").append(strMaxID + "','" + strSUSERNO + "','" + tmpUserNo + "'");
            if (strSDATE.length() > 0) {
                if (DataBaseType.equals("2")) {
                    addBuf.append(",'" + strSDATE + "'");
                } else {
                    addBuf.append(",to_date('" + strSDATE + "','yyyy-mm-dd')");
                }
            } else {
                addBuf.append(",sysdate");
            }
            if (strEDATE.length() > 0) {
                if (DataBaseType.equals("2")) {
                    addBuf.append(",'" + strEDATE + "'");
                } else {
                    addBuf.append(",to_date('" + strEDATE + "','yyyy-mm-dd')");
                }
            } else {
                addBuf.append(",sysdate");
            }
            addBuf.append(",'" + strTYPE + "','" + strFLOWNAME + "','" + strFLOWID).append("','" + strFLOWNODE + "',sysdate)");
            dbengine.ExecuteSQL(addBuf.toString());
        }
        return true;
    }

    private String GetCurrActivityID(String strID) {
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select CURRACTIVITY From FLOW_RUNTIME_PROCESS where ID='" + strID + "'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                addBuf.append(dbset.Row(0).Column("CURRACTIVITY").getString());
            }
            dbset = null;
        }
        return addBuf.toString();
    }

    private String GetFlowRunName(String strID) {
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select NAME From FLOW_RUNTIME_PROCESS where ID='" + strID + "'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                addBuf.append(dbset.Row(0).Column("NAME").getString());
            }
            dbset = null;
        }
        return addBuf.toString();
    }

    private String GetActivityName(String strID) {
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select NAME From FLOW_CONFIG_ACTIVITY where ID='" + strID + "'");
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                addBuf.append(dbset.Row(0).Column("NAME").getString());
            }
            dbset = null;
        }
        return addBuf.toString();
    }

    public String GetCSendUser(String strAID, String FID) {
        String resultValue = "";
        String isSend = "0";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select b.NAME From FLOW_RUNTIME_ACTIVITY a left join BPIP_USER b on a.SENDPSN=b.USERID where a.FID='").append(FID + "' And a.EACTIVITY='" + strAID + "' and a.DOFLAG='0'");
        dbSet set = dbengine.QuerySQL(addBuf.toString());
        if (set != null) {
            if (set.RowCount() > 0) {
                resultValue = set.Row(0).Column("NAME").getString();
                isSend = "1";
            }
            set = null;
        }
        if (isSend.equals("0")) {
            addBuf.delete(0, addBuf.length());
            addBuf.append("Select b.NAME From FLOW_RUNTIME_ACTIVITY  a left join BPIP_USER b on a.DOPSN=b.USERID where a.FID='").append(FID + "' And a.SACTIVITY='" + strAID + "' order by ID desc");
            dbSet set1 = dbengine.QuerySQL(addBuf.toString());
            if (set1 != null && set1.RowCount() > 0) {
                resultValue = set1.Row(0).Column("NAME").getString();
            }
            set1 = null;
        }
        return resultValue;
    }

    public Hashtable GetSendUserHashtable1(String strUserID) {
        String strFID = "";
        String strEACTIVITY = "";
        String strNAME = "";
        Hashtable<String, String> NameHashtable = new Hashtable<String, String>();
        StringBuffer addBuf = new StringBuffer();
        if (DataBaseType.equals("2")) {
            addBuf.append("Select top 500 a.FID,a.EACTIVITY,b.NAME From FLOW_RUNTIME_ACTIVITY a left join BPIP_USER b on a.SENDPSN=b.USERID where a.DOPSN='").append(strUserID + "' and  a.DOFLAG='0'");
        } else {
            addBuf.append("Select a.FID,a.EACTIVITY,b.NAME From FLOW_RUNTIME_ACTIVITY a left join BPIP_USER b on a.SENDPSN=b.USERID where rownum<500 and a.DOPSN='").append(strUserID + "' and  a.DOFLAG='0'");
        }
        dbSet set = dbengine.QuerySQL(addBuf.toString());
        if (set != null && set.RowCount() > 0) {
            for (int i = 0; i < set.RowCount(); ++i) {
                strFID = set.Row(i).Column("FID").getString();
                strEACTIVITY = set.Row(i).Column("EACTIVITY").getString();
                strNAME = set.Row(i).Column("NAME").getString();
                addBuf.delete(0, addBuf.length());
                addBuf.append(strFID + strEACTIVITY);
                NameHashtable.put(addBuf.toString(), strNAME);
            }
            set = null;
        }
        return NameHashtable;
    }

    public Hashtable GetSendUserHashtable2(String strUserID) {
        String strFID = "";
        String strFIDS = "";
        String strCS = "";
        String strSACTIVITY = "";
        String strNAME = "";
        Hashtable<String, String> NameHashtable = new Hashtable<String, String>();
        StringBuffer addBuf = new StringBuffer();
        if (DataBaseType.equals("2")) {
            addBuf.append("Select top 500 a.FID,a.SACTIVITY,b.NAME From FLOW_RUNTIME_ACTIVITY a left join BPIP_USER b on a.DOPSN=b.USERID where  a.DOPSN='").append(strUserID + "' order by a.ID desc");
        } else {
            addBuf.append("Select a.FID,a.SACTIVITY,b.NAME From FLOW_RUNTIME_ACTIVITY a left join BPIP_USER b on a.DOPSN=b.USERID where rownum<500 and a.DOPSN='").append(strUserID + "' order by a.ID desc");
        }
        dbSet set = dbengine.QuerySQL(addBuf.toString());
        if (set != null && set.RowCount() > 0) {
            for (int i = 0; i < set.RowCount(); ++i) {
                strFID = set.Row(i).Column("FID").getString();
                strSACTIVITY = set.Row(i).Column("SACTIVITY").getString();
                strNAME = set.Row(i).Column("NAME").getString();
                addBuf.delete(0, addBuf.length());
                addBuf.append(strFID + strSACTIVITY);
                strCS = addBuf.toString();
                if (strFIDS.indexOf(strCS) != -1) continue;
                NameHashtable.put(strCS, strNAME);
                addBuf.delete(0, addBuf.length());
                addBuf.append(strFIDS + strCS + ",");
                strFIDS = addBuf.toString();
            }
            set = null;
        }
        return NameHashtable;
    }

    public String GetUserAllotType(String strUserID, String strID) {
        String returnValue = "1";
        String strFLOWID = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("select FLOWID from FLOW_RUNTIME_PROCESS where ID='" + strID + "'");
        dbSet dbset1 = dbengine.QuerySQL(addBuf.toString());
        if (dbset1 != null) {
            if (dbset1.RowCount() > 0) {
                strFLOWID = dbset1.Row(0).Column("FLOWID").getString();
            }
            dbset1 = null;
        }
        addBuf.delete(0, addBuf.length());
        addBuf.append("select PROSESSID from FLOW_CONFIG_PROSESS_GROUP where ISDEPT='0' and TYPE='2' and PROSESSID in (select ID from FLOW_CONFIG_PROCESS where IDENTIFICATION='").append(strFLOWID + "') and GROUPID in (select ROLEID from BPIP_USER_ROLE where USERID='" + strUserID).append("')");
        dbSet dbset2 = dbengine.QuerySQL(addBuf.toString());
        if (dbset2 != null) {
            if (dbset2.RowCount() > 0) {
                returnValue = "2";
            }
            dbset2 = null;
        }
        return returnValue;
    }

    public FLOW_RUNTIME_PROCESS[] GetFlowTransactList2(String strUserNo, int currentPage, int PageSize, String strwhere) {
        FLOW_RUNTIME_PROCESS[] returnValue;
        block13: {
            returnValue = null;
            String strSQL = new String();
            dbSet dbset1 = null;
            String strCURRACTIVITY = "";
            String strSignType = "";
            String strACCEPTPSN = "";
            String tmpUserNo = "";
            int ListNum = 0;
            StringBuffer addBuf = new StringBuffer();
            if (DataBaseType.equals("3")) {
                addBuf.append("Select B.ID,B.NAME,B.CREATEDATE,B.CURRACTIVITY,B.ACCEPTPSN,B.ACCEPTDATE From FLOW_RUNTIME_PROCESS B Left Join BPIP_USER C on B.CREATEPSN=C.USERID where B.STATE<>'2' and B.STATE<>'3' and B.STATE<>'4' and B.ACCEPTPSN like '%").append(strUserNo + "%' and " + strwhere + " order by B.ACCEPTDATE desc");
                strSQL = addBuf.toString();
                addBuf.delete(0, addBuf.length());
                addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
            } else {
                addBuf.append("Select B.ID,B.NAME,B.CREATEDATE,B.CURRACTIVITY,B.ACCEPTPSN,B.ACCEPTDATE,C.NAME AS CREATEPSN From FLOW_RUNTIME_PROCESS B Left Join BPIP_USER C on B.CREATEPSN=C.USERID where B.STATE<>'2' and B.STATE<>'3' and B.STATE<>'4' and B.ACCEPTPSN like '%").append(strUserNo + "%' and " + strwhere + " order by B.ACCEPTDATE desc");
                strSQL = addBuf.toString();
                addBuf.delete(0, addBuf.length());
                addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
            }
            dbSet dbset = dbengine.QuerySQL(addBuf.toString());
            if (DataBaseType.equals("3")) {
                addBuf.delete(0, addBuf.length());
                addBuf.append("Select C.NAME From FLOW_RUNTIME_PROCESS B Left Join BPIP_USER C on B.CREATEPSN=C.USERID where B.STATE<>'2' and B.STATE<>'3' and B.STATE<>'4' and B.ACCEPTPSN like '%").append(strUserNo + "%' and " + strwhere + " order by B.ACCEPTDATE desc");
                strSQL = addBuf.toString();
                addBuf.delete(0, addBuf.length());
                addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
                dbset1 = dbengine.QuerySQL(addBuf.toString());
            }
            addBuf.delete(0, addBuf.length());
            addBuf.append("Select CURRACTIVITY From FLOW_RUNTIME_PROCESS  where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%'");
            String strWhere = addBuf.toString();
            Hashtable SignType = new Hashtable();
            try {
                SignType = this.GetSignTypeHashtable(strWhere);
                if (dbset == null) break block13;
                if (dbset.RowCount() > 0) {
                    returnValue = new FLOW_RUNTIME_PROCESS[this.GetFlowTransactNum2(strUserNo, currentPage, PageSize)];
                    for (int i = 0; i < dbset.RowCount(); ++i) {
                        strCURRACTIVITY = dbset.Row(i).Column("CURRACTIVITY").getString();
                        strACCEPTPSN = dbset.Row(i).Column("ACCEPTPSN").getString();
                        try {
                            strSignType = (String)SignType.get(strCURRACTIVITY);
                            if (strSignType == null) {
                                strSignType = "0";
                            }
                        }
                        catch (Exception ex) {
                            log.WriteErrorLog("\u9519\u8bef\u4fe1\u606f:", ex.toString());
                        }
                        if (strSignType.equals("1")) {
                            ArrayList UserList = new ArrayList();
                            UserList = this.GetArrayList(strACCEPTPSN, ",");
                            tmpUserNo = UserList.get(0).toString();
                            if (!tmpUserNo.equals(strUserNo)) continue;
                            returnValue[ListNum] = new FLOW_RUNTIME_PROCESS();
                            returnValue[ListNum].fullData(dbset.Row(i));
                            if (DataBaseType.equals("3")) {
                                returnValue[ListNum].setCREATEPSN(dbset1.Row(i).Column("NAME").getString());
                            }
                            ++ListNum;
                            continue;
                        }
                        returnValue[ListNum] = new FLOW_RUNTIME_PROCESS();
                        returnValue[ListNum].fullData(dbset.Row(i));
                        if (DataBaseType.equals("3")) {
                            returnValue[ListNum].setCREATEPSN(dbset1.Row(i).Column("NAME").getString());
                        }
                        ++ListNum;
                    }
                }
                dbset = null;
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private int GetFlowTransactNum2(String strUserNo, int currentPage, int PageSize) {
        int returnValue = 0;
        String strSQL = new String();
        String strCURRACTIVITY = "";
        String strSignType = "";
        String strACCEPTPSN = "";
        String tmpUserNo = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select * From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%'");
        strSQL = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select * From (SELECT A.*, ROWNUM RN FROM (" + strSQL + ") A WHERE ROWNUM <= ").append(String.valueOf(currentPage * PageSize) + ") WHERE RN > " + String.valueOf((currentPage - 1) * PageSize));
        dbSet dbset = dbengine.QuerySQL(addBuf.toString());
        addBuf.delete(0, addBuf.length());
        addBuf.append("Select CURRACTIVITY From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and ACCEPTPSN like '%").append(strUserNo + "%'");
        Hashtable SignType = new Hashtable();
        SignType = this.GetSignTypeHashtable(addBuf.toString());
        if (dbset != null) {
            if (dbset.RowCount() > 0) {
                for (int i = 0; i < dbset.RowCount(); ++i) {
                    strCURRACTIVITY = dbset.Row(i).Column("CURRACTIVITY").getString();
                    strACCEPTPSN = dbset.Row(i).Column("ACCEPTPSN").getString();
                    try {
                        strSignType = (String)SignType.get(strCURRACTIVITY);
                        if (strSignType == null) {
                            strSignType = "0";
                        }
                    }
                    catch (Exception ex) {
                        log.WriteErrorLog("\u9519\u8bef\u4fe1\u606f:", ex.toString());
                    }
                    if (strSignType.equals("1")) {
                        ArrayList UserList = new ArrayList();
                        UserList = this.GetArrayList(strACCEPTPSN, ",");
                        tmpUserNo = UserList.get(0).toString();
                        if (!tmpUserNo.equals(strUserNo)) continue;
                        ++returnValue;
                        continue;
                    }
                    ++returnValue;
                }
            }
            dbset = null;
        }
        return returnValue;
    }

    public String SumFlowcontent(String strUserNo) {
        String sum = "0";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("Select count(ID) as count From FLOW_RUNTIME_PROCESS where STATE not in('2','3','4') and ACCEPTPSN like '%").append(strUserNo + "%'");
        dbSet mdbset = dbengine.QuerySQL(addBuf.toString());
        if (mdbset != null) {
            sum = String.valueOf(mdbset.Row(0).Column("count").getInteger());
            mdbset = null;
        }
        return sum;
    }

    public String CreatePageNavigateBy(String strUserID, int currentPage, int pageSize, String type, String strwhere) {
        log.WriteLog("CreatePageNavigateBy", "\u5f00\u59cb\u8c03\u7528");
        long startTime = System.currentTimeMillis();
        String resultStr = "";
        String strTMP = "";
        String strFLOW1 = "";
        String strROLEID = "";
        String strSql = "";
        Hashtable<String, String> FlowHashtable = new Hashtable<String, String>();
        strSql = "select ID,IDENTIFICATION from FLOW_CONFIG_PROCESS";
        dbSet dbset1 = null;
        dbset1 = (dbSet)ADDHashtable2.get("FLOW_CONFIG_PROCESS");
        if (dbset1 == null && (dbset1 = dbengine.QuerySQL(strSql)) != null) {
            ADDHashtable2.put("FLOW_CONFIG_PROCESS", dbset1);
        }
        if (dbset1 != null) {
            if (dbset1.RowCount() > 0) {
                for (int i = 0; i < dbset1.RowCount(); ++i) {
                    FlowHashtable.put(dbset1.Row(i).Column("ID").getString(), dbset1.Row(i).Column("IDENTIFICATION").getString());
                }
            }
            dbset1 = null;
        }
        strSql = "select ROLEID from BPIP_USER_ROLE where USERID='" + strUserID + "'";
        dbSet db = null;
        db = (dbSet)ADDHashtable3.get(strUserID);
        if (db == null && (db = dbengine.QuerySQL(strSql)) != null) {
            ADDHashtable3.put(strUserID, db);
        }
        if (db != null) {
            if (db.RowCount() > 0) {
                for (int i = 0; i < db.RowCount(); ++i) {
                    strROLEID = i == 0 ? "'" + String.valueOf(db.Row(i).Column("ROLEID").getInteger()) + "'" : strROLEID + ",'" + String.valueOf(db.Row(i).Column("ROLEID").getInteger()) + "'";
                }
            }
            db = null;
        }
        strSql = "select PROSESSID from FLOW_CONFIG_PROSESS_GROUP where ISDEPT='1' and TYPE='" + type + "' and GROUPID in (" + strROLEID + ")";
        String strATMP = "";
        dbSet dbset2 = null;
        strATMP = (String)ISADDHashtable4.get("1" + type + strROLEID);
        if (strATMP == null) {
            dbset2 = dbengine.QuerySQL(strSql);
            if (dbset2 != null) {
                ADDHashtable4.put("1" + type + strROLEID, dbset2);
            }
            ISADDHashtable4.put("1" + type + strROLEID, "1");
        } else {
            dbset2 = (dbSet)ADDHashtable4.get("1" + type + strROLEID);
        }
        if (dbset2 != null) {
            if (dbset2.RowCount() > 0) {
                for (int i = 0; i < dbset2.RowCount(); ++i) {
                    strTMP = dbset2.Row(i).Column("PROSESSID").getString();
                    strTMP = (String)FlowHashtable.get(strTMP);
                    strFLOW1 = strFLOW1 + "'" + strTMP + "',";
                }
            }
            dbset2 = null;
        }
        strSql = "select PROSESSID from FLOW_CONFIG_PROSESS_GROUP where ISDEPT='0' and TYPE='" + type + "' and GROUPID in (" + strROLEID + ")";
        dbSet dbset3 = null;
        strATMP = (String)ISADDHashtable4.get("0" + type + strROLEID);
        if (strATMP == null) {
            dbset3 = dbengine.QuerySQL(strSql);
            if (dbset3 != null) {
                ADDHashtable4.put("0" + type + strROLEID, dbset3);
            }
            ISADDHashtable4.put("0" + type + strROLEID, "1");
        } else {
            dbset3 = (dbSet)ADDHashtable4.get("0" + type + strROLEID);
        }
        if (dbset3 != null) {
            if (dbset3.RowCount() > 0) {
                for (int i = 0; i < dbset3.RowCount(); ++i) {
                    strTMP = dbset3.Row(i).Column("PROSESSID").getString();
                    strTMP = (String)FlowHashtable.get(strTMP);
                    strFLOW1 = strFLOW1 + "'" + strTMP + "',";
                }
            }
            dbset3 = null;
        }
        if (strFLOW1.length() > 0) {
            strFLOW1 = strFLOW1.substring(0, strFLOW1.length() - 1);
        }
        if (strFLOW1.length() > 0) {
            int intRowCount;
            strSql = "Select  count(ID) as RCount From FLOW_RUNTIME_PROCESS where STATE<>'2' and STATE<>'3' and STATE<>'4' and FLOWID in (" + strFLOW1 + ") and " + strwhere;
            int _CurrentPage = currentPage;
            dbSet ds = dbengine.QuerySQL(strSql);
            if (ds == null) {
                intRowCount = 0;
            } else {
                intRowCount = ds.Row(0).Column("RCount").getInteger();
                ds = null;
            }
            resultStr = this.CreatePageMenu(pageSize, intRowCount, _CurrentPage);
            long endTime = System.currentTimeMillis();
            log.WriteLog("CreatePageNavigateBySql", "\u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (endTime - startTime) + " ms.");
        }
        return resultStr;
    }

    public String CreatePageNavigateBySql(String sqlStr, int currentPage, int pageSize) {
        int intRowCount;
        log.WriteLog("CreatePageNavigateBySql", "\u5f00\u59cb\u8c03\u7528");
        long startTime = System.currentTimeMillis();
        String resultStr = "";
        int _CurrentPage = currentPage;
        dbSet ds = dbengine.QuerySQL(sqlStr);
        if (ds == null) {
            intRowCount = 0;
        } else {
            intRowCount = ds.Row(0).Column("RCount").getInteger();
            ds = null;
        }
        resultStr = this.CreatePageMenu(pageSize, intRowCount, _CurrentPage);
        long endTime = System.currentTimeMillis();
        log.WriteLog("CreatePageNavigateBySql", "\u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (endTime - startTime) + " ms.");
        return resultStr;
    }

    private String CreatePageMenu(int intPageSize, int intRowCount, int intPage) {
        String PageMenu = "";
        StringBuffer addBuf = new StringBuffer();
        addBuf.append("&nbsp;");
        int intPageCount = 0;
        int sum1 = 0;
        int sum2 = 0;
        int sum3 = intRowCount;
        while (intRowCount - intPageSize > 0 || intRowCount > 0) {
            ++intPageCount;
            intRowCount -= intPageSize;
        }
        if (intPage > intPageCount) {
            intPage = intPageCount;
        }
        if (intPageCount > 1) {
            sum1 = intPage - 1;
            if (sum1 < 1) {
                sum1 = 1;
            }
            if ((sum2 = intPage + 1) > intPageCount) {
                sum2 = intPageCount;
            }
            addBuf.append("<a href='javascript:recordfrm.page.value=\"1\";recordfrm.submit();'>\u9996\u9875</a>").append("&nbsp;&nbsp;<a href='javascript:recordfrm.page.value=\"" + String.valueOf(sum1)).append("\";recordfrm.submit();'>\u4e0a\u4e00\u9875</a>&nbsp;&nbsp;<a href='javascript:recordfrm.page.value=\"").append(String.valueOf(sum2) + "\";recordfrm.submit();'>\u4e0b\u4e00\u9875</a>" + "&nbsp;&nbsp;<a href='javascript:recordfrm.page.value=\"").append(String.valueOf(intPageCount) + "\";recordfrm.submit();'>\u672b\u9875</a>&nbsp;&nbsp;").append("<select size='1' class='PageStyle'  Onchange='javascript:recordfrm.page.value=this.value;recordfrm.submit();'>");
            for (int i = 1; i <= intPageCount; ++i) {
                if (intPage == i) {
                    addBuf.append("<option value='" + String.valueOf(i) + "' selected >\u7b2c" + String.valueOf(i)).append("\u9875</option>");
                    continue;
                }
                addBuf.append("<option value='" + String.valueOf(i) + "' >\u7b2c" + String.valueOf(i) + "\u9875</option>");
            }
            addBuf.append("</select>&nbsp;&nbsp;\u9875\u6b21\uff1a" + String.valueOf(intPage) + "/").append(String.valueOf(intPageCount) + "&nbsp;&nbsp;\u5171" + String.valueOf(sum3)).append("\u6761");
        } else {
            addBuf.append("&nbsp;&nbsp;\u5171" + String.valueOf(sum3) + "\u6761");
        }
        PageMenu = addBuf.toString();
        addBuf.delete(0, addBuf.length());
        addBuf.append("</TD><TD align='right'>" + PageMenu);
        PageMenu = addBuf.toString();
        return PageMenu;
    }

    public void initHashtable() {
        ADDHashtable1.clear();
        ADDHashtable2.clear();
        ADDHashtable3.clear();
        ISADDHashtable4.clear();
        ADDHashtable4.clear();
    }

    static {
        clients = 0;
        DataBaseType = SysPreperty.getProperty().DataBaseType;
        strFlowRoleType = "2";
        ADDHashtable1 = new Hashtable();
        ADDHashtable2 = new Hashtable();
        ADDHashtable3 = new Hashtable();
        ISADDHashtable4 = new Hashtable();
        ADDHashtable4 = new Hashtable();
    }
}

