package zr.zrpower.flowengine.web.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import zr.zrpower.common.util.FunctionMessage;
import zr.zrpower.flowengine.service.FlowManageAct;
import zr.zrpower.flowengine.mode.config.FLOW_CONFIG_ACTIVITY;
import zr.zrpower.web.bean.MessageBox;

public class FlowMaActSer
    extends MessageBox {
  private static final String CONTENT_TYPE = "text/html; charset=GBK";
  private static final String RETURN_PATH = "javascript:history.back(-1);";

  private FlowManageAct flowManageAct;
  private FunctionMessage fm;
  private FLOW_CONFIG_ACTIVITY entityActivity;
  private HttpServletRequest _request;

  //Initialize global variables
  public void init() throws ServletException {
  }

  //Process the HTTP Get request
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws
      ServletException, IOException {
    _request = request;
    response.setContentType(CONTENT_TYPE);
    request.setCharacterEncoding("GBK");
    String strAction = request.getParameter("Act");
    String strflowtype = request.getParameter("flowtype");
    String strformtype = request.getParameter("formtype");
    String strFID = request.getParameter("FID");
    String strTYPE = request.getParameter("TYPE");

    fm = new FunctionMessage(1);
    fm.setResult(true);
    entityActivity = new FLOW_CONFIG_ACTIVITY();
    entityActivity.fullDataFromRequest(request);
    entityActivity.setID(request.getParameter("ActivityID"));
    try {
      flowManageAct = new FlowManageAct();
      if (strAction.equals("Operate")) {
        if (entityActivity.getID().equals("null")) {
          //ӻʱIDΪڴΪַ"null"
          entityActivity.setID(flowManageAct.GetActivityMaxID());
          entityActivity.setIDENTIFICATION("FA" + entityActivity.getID());
        }

        SaveBaseProperty(); //
        if (strflowtype.equals("1"))
        {

        SaveStrategyProperty(); //

        SaveOverTimeFieldInfo(); //ʱ

        SaveOperateProperty(); //

        SaveAttProperty(); //

        SaveUserGroupProperty(); //

        }

        SaveCtlFieldInfo(); //ɿֶ

      }

    }
    catch (Exception ex2) {
      this.Msg = "ӿͻļмʧܣ<br>ϸϢ<br>   " + ex2.toString();
      this.returnPath = "javascript:history.back(-1);";
    }

    if (fm.getResult()) {

      String strid = entityActivity.getID();
      String strISBRANCH = entityActivity.getISBRANCH();
      flowManageAct = null;
      entityActivity = null;

      response.sendRedirect("ZrWorkFlow/flowconfig/FlowProcess/ManageActivity.jsp?ID="+strid+"&FID="+strFID+"&TYPE="+strTYPE+"&flowtype="+strflowtype+"&formtype="+strformtype+"&ISBRANCH="+strISBRANCH);
    }

    this.out = response.getWriter();
    //this.GetBox();

  }

  //Process the HTTP Post request
  public void doPost(HttpServletRequest request, HttpServletResponse response) throws
      ServletException, IOException {
    doGet(request, response);
  }

  //Clean up resources
  public void destroy() {
  }

  /**
   * 
   * @return FunctionMessage
   */
  private FunctionMessage SaveBaseProperty() {
    FunctionMessage fmTemp = new FunctionMessage();
    try {
      fmTemp = flowManageAct.SaveBaseProperty(entityActivity);
    }
    catch (Exception ex) {
      fmTemp = new FunctionMessage(false, ex.getMessage());
    }
    return fmTemp;

  }

  /**
   * 
   * @return FunctionMessage
   */
  private FunctionMessage SaveStrategyProperty() {
    FunctionMessage fmTemp = new FunctionMessage();
    try {
      fmTemp = flowManageAct.SaveStrategyProperty(entityActivity);
    }
    catch (Exception ex) {
      fmTemp = new FunctionMessage(false, ex.getMessage());
    }
    return fmTemp;
  }

  private void SaveOperateProperty() {
    String[] BUTTONIDs = _request.getParameter("OperateProterty").split(",");
    try {
      flowManageAct.DeleteButtonFromActivity(entityActivity.getID());
      for (int i = 0; i < BUTTONIDs.length; i++) {

        flowManageAct.AddButtonToActivity(entityActivity.getID(), BUTTONIDs[i]);
      }
    }
    catch (Exception ex) {

    }
  }


  private void SaveOverTimeFieldInfo() {
    try {
      flowManageAct.SaveOverTimeFieldInfo(entityActivity.getID(),
                                          _request.getParameter(
                                              "OverTimeFieldInfo"));
    }
    catch (Exception ex) {

    }
  }


  /**
   * 
   * @return FunctionMessage
   */
  private FunctionMessage SaveAttProperty() {
    FunctionMessage fmTemp = new FunctionMessage();
    try {
      fmTemp = flowManageAct.SaveAttProperty(entityActivity);
    }
    catch (Exception ex) {
      fmTemp = new FunctionMessage(false, ex.getMessage());
    }
    return fmTemp;
  }

  private void SaveCtlFieldInfo() {
    try {
      flowManageAct.SaveCtlFieldInfo(entityActivity.getID(),
                                     _request.getParameter("CtlFieldInfoStr"));
    }
    catch (Exception ex) {

    }
  }

  private void SaveUserGroupProperty() {
    String[] UserGroupIDs = _request.getParameter("UserGroupProterty").split(
        ",");
    try {
      flowManageAct.DeleteUserGroupFromActivity(entityActivity.getID());
      for (int i = 0; i < UserGroupIDs.length; i++) {
        flowManageAct.AddUserGroupToActivity(entityActivity.getID(),
                                             UserGroupIDs[i]);
      }
    }
    catch (Exception ex) {

    }
  }

}
