/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.queryengine;

import java.util.ArrayList;
import zr.zrpower.common.db.dbRow;
import zr.zrpower.common.db.dbTag;
import zr.zrpower.common.db.dbType;
import zr.zrpower.queryengine.ItemField;

public class ItemList {
    private ArrayList arrayList = new ArrayList();

    public void addItem(ItemField item) {
        this.arrayList.add(item);
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public ItemField getItemField(int i) {
        return (ItemField)this.arrayList.get(i);
    }

    public int fullFromDbRow(dbRow dr) {
        ItemField item = new ItemField();
        item.setTableEnName(dr.getTableName());
        item.setName(dr.getTableName() + "." + dr.Column("FIELDNAME").getString());
        item.setChineseName(dr.Column("CHINESENAME").getString());
        item.setCodeTable(dr.Column("DICTTABLE").getString());
        if (item.getCodeTable() != null && !item.getCodeTable().equals("")) {
            item.setIsCode(true);
        }
        item.setLength(dr.Column("FIELDLENGTH").getInteger());
        item.setType(this.SwitchDbType(dr.Column("FIELDTYPE").getString()));
        item.setIsNull(this.SwitchIsNull(dr.Column("ISNULL").getString()));
        if (dr.Column("FIELDTAG").getInteger() == dbTag.USER.getValue()) {
            item.setIsUser(true);
        }
        if (dr.Column("FIELDTAG").getInteger() == dbTag.UNIT.getValue()) {
            item.setIsUnit(true);
            item.setUserField1(dr.Column("AUTO1").getString(), "");
            item.setUserField2(dr.Column("AUTO2").getString(), "");
            item.setUserField3(dr.Column("AUTO3").getString(), "");
        }
        item.setCodeInput(dr.Column("TAGEXT").getInteger());
        this.arrayList.add(item);
        return 0;
    }

    private dbType SwitchDbType(String strType) {
        dbType dbtype = null;
        int iType = 0;
        if (strType != null) {
            iType = Integer.parseInt(strType);
        }
        switch (iType) {
            case 1: {
                dbtype = dbType.STRING;
                break;
            }
            case 2: {
                dbtype = dbType.FLOAT;
                break;
            }
            case 3: {
                dbtype = dbType.BLOB;
                break;
            }
            case 4: {
                dbtype = dbType.DATE;
                break;
            }
            case 5: {
                dbtype = dbType.DATETIME;
                break;
            }
            case 6: {
                dbtype = dbType.LONG;
                break;
            }
            case 7: {
                dbtype = dbType.CLOB;
            }
        }
        return dbtype;
    }

    private boolean SwitchIsNull(String strNULL) {
        boolean result = true;
        if (strNULL != null && strNULL.equals("1")) {
            result = false;
        }
        return result;
    }
}

