/*
 * Decompiled with CFR 0.152.
 */
package zr.zrpower.queryengine.service;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import zr.zrpower.common.db.dbEngine;
import zr.zrpower.common.db.dbServer;
import zr.zrpower.common.db.dbSet;
import zr.zrpower.common.util.Log;
import zr.zrpower.common.util.SysPreperty;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_BRELATION;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_BUTTON;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_CONNECTION;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_INIT;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_ORDER;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_PARAMETER;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_QUERYFIELD;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_SHOWFIELD;
import zr.zrpower.queryengine.mode.QUERY_CONFIG_TABLE;
import zr.zrpower.queryengine.service.QueryControl;

public class QueryConfig {
    private static Log log;
    dbEngine dbengine;
    private static int clients;
    String DataBaseType;

    public QueryConfig() {
        this.DataBaseType = SysPreperty.getProperty().DataBaseType;
        this.dbengine = new dbEngine(SysPreperty.getProperty().MainDataSource, SysPreperty.getProperty().IsConvert);
        this.dbengine.initialize();
        if (clients < 1) {
            log = new Log();
            log.SetLogForClass("QueryConfig");
            log.SetLogFile("QueryConfig.log");
        }
        clients = 1;
    }

    public QUERY_CONFIG_CONNECTION[] GetConfigConnectionByWhere(String strWhere) {
        QUERY_CONFIG_CONNECTION[] entityList = null;
        StringBuffer strSql = new StringBuffer();
        try {
            if (strWhere.trim().length() == 0) {
                strSql.append("Select * From QUERY_CONFIG_CONNECTION ");
            } else {
                strSql.append("Select * From QUERY_CONFIG_CONNECTION  where ").append(strWhere);
            }
            strSql.append(" Order by ID");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            if (mdbset == null) {
                return null;
            }
            entityList = new QUERY_CONFIG_CONNECTION[mdbset.RowCount()];
            for (int i = 0; i < mdbset.RowCount(); ++i) {
                entityList[i] = new QUERY_CONFIG_CONNECTION();
                entityList[i].fullData(mdbset.Row(i));
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("GetConfigConnectionByWhere", "GetConfigConnectionByWhere\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            return null;
        }
        return entityList;
    }

    public QUERY_CONFIG_TABLE GetConfigByID(String ID) {
        QUERY_CONFIG_TABLE entityObj = new QUERY_CONFIG_TABLE();
        StringBuffer strSql = new StringBuffer();
        try {
            strSql.append("Select * From QUERY_CONFIG_TABLE  Where  ID='" + ID.trim() + "'");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            if (mdbset == null) {
                return null;
            }
            if (mdbset.RowCount() > 0) {
                entityObj.fullData(mdbset.Row(0));
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("\u8c03\u7528\u65b9\u6cd5GetConfigByID\u51fa\u73b0\u5f02\u5e38" + e.toString());
            return null;
        }
        return entityObj;
    }

    public boolean SaveBaseProperty(QUERY_CONFIG_TABLE entityObj) {
        boolean result = false;
        dbServer dserver = new dbServer();
        dserver.SaveBaseProperty(entityObj);
        return result;
    }

    public boolean SaveRelationProperty(String FID, String FieldInfoStr) {
        boolean result = false;
        String[] tempArray1 = FieldInfoStr.split("&");
        StringBuffer strSql = new StringBuffer();
        try {
            strSql.append("Delete from QUERY_CONFIG_CONNECTION Where FID='" + FID + "'");
            this.dbengine.ExecuteSQL(strSql.toString());
            String MaxFieldNo = this.GetMaxFieldNo("QUERY_CONFIG_CONNECTION", "ID", 8);
            for (int i = 0; i < tempArray1.length; ++i) {
                String[] tempArray2 = tempArray1[i].split("#");
                if (tempArray2[0].length() == 0) continue;
                strSql.delete(0, strSql.length());
                strSql.append("Insert Into QUERY_CONFIG_CONNECTION(ID,FID,CFIELD,MFIELD,JOINTYPE) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo, 8, i) + "'," + "'" + FID + "'," + "'" + tempArray2[0] + "." + tempArray2[1] + "'," + "'" + tempArray2[2] + "." + tempArray2[3] + "'," + "'" + tempArray2[4] + "'" + ")");
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            result = true;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public boolean SaveInitWhereProperty(String FID, String FieldInfoStr) {
        boolean result = false;
        StringBuffer strSql = new StringBuffer();
        String[] tempArray1 = FieldInfoStr.split("&");
        try {
            strSql.append("Delete from QUERY_CONFIG_INIT Where FID='" + FID).append("'");
            this.dbengine.ExecuteSQL(strSql.toString());
            String MaxFieldNo = this.GetMaxFieldNo("QUERY_CONFIG_INIT", "ID", 8);
            for (int i = 0; i < tempArray1.length; ++i) {
                String[] tempArray2 = tempArray1[i].split("#");
                log.WriteLog(String.valueOf(i));
                if (tempArray2[0].length() == 0) continue;
                strSql.delete(0, strSql.length());
                strSql.append("Insert Into QUERY_CONFIG_INIT(ID,FID,QLEFT,FIELD,SYMBOL,WHEREVALUE,QRIGHT,LOGIC) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo, 8, i) + "'," + "'" + FID + "'," + "'" + tempArray2[0] + "'," + "'" + tempArray2[1] + "'," + "'" + tempArray2[2] + "'," + "'" + this.ConvertQuotationSingleToDouble(tempArray2[3]) + "'," + "'" + tempArray2[4] + "'," + "'" + tempArray2[5] + "'" + ")");
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            result = true;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public QUERY_CONFIG_INIT[] GetConfigInitByWhere(String strWhere) {
        QUERY_CONFIG_INIT[] entityList = null;
        StringBuffer strSql = new StringBuffer();
        try {
            if (strWhere.trim().length() == 0) {
                strSql.append("Select * From QUERY_CONFIG_INIT ");
            } else {
                strSql.append("Select * From QUERY_CONFIG_INIT  where " + strWhere);
            }
            strSql.append(" Order by ID");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            if (mdbset == null) {
                return null;
            }
            entityList = new QUERY_CONFIG_INIT[mdbset.RowCount()];
            for (int i = 0; i < mdbset.RowCount(); ++i) {
                entityList[i] = new QUERY_CONFIG_INIT();
                entityList[i].fullData(mdbset.Row(i));
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("GetConfigInitByWhere", "GetConfigInitByWhere\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            return null;
        }
        return entityList;
    }

    public boolean SaveQueryFieldProperty(String FID, String FieldInfoStr) {
        boolean result = false;
        String strSql = "";
        String[] tempArray = FieldInfoStr.split(",");
        String FIELD = "";
        String ISPRECISION = "";
        String ISMUST = "";
        String ISDAY = "";
        String DVALUE = "";
        Hashtable<String, String> Hashtable1 = new Hashtable<String, String>();
        Hashtable<String, String> Hashtable2 = new Hashtable<String, String>();
        Hashtable<String, String> Hashtable3 = new Hashtable<String, String>();
        Hashtable<String, String> Hashtable4 = new Hashtable<String, String>();
        try {
            strSql = "select * from QUERY_CONFIG_QUERYFIELD Where FID='" + FID + "'";
            dbSet mdbset = this.dbengine.QuerySQL(strSql);
            if (mdbset != null && mdbset.RowCount() > 0) {
                for (int k = 0; k < mdbset.RowCount(); ++k) {
                    FIELD = mdbset.Row(k).Column("FIELD").getString();
                    ISPRECISION = mdbset.Row(k).Column("ISPRECISION").getString();
                    ISMUST = mdbset.Row(k).Column("ISMUST").getString();
                    ISDAY = mdbset.Row(k).Column("ISDAY").getString();
                    DVALUE = mdbset.Row(k).Column("DVALUE").getString();
                    Hashtable1.put(FID + "." + FIELD, ISPRECISION);
                    Hashtable2.put(FID + "." + FIELD, ISMUST);
                    Hashtable3.put(FID + "." + FIELD, ISDAY);
                    Hashtable4.put(FID + "." + FIELD, DVALUE);
                }
            }
            strSql = "Delete from QUERY_CONFIG_QUERYFIELD Where FID='" + FID + "'";
            this.dbengine.ExecuteSQL(strSql.toString());
            String MaxFieldNo = this.GetMaxFieldNo("QUERY_CONFIG_QUERYFIELD", "ID", 8);
            for (int i = 0; i < tempArray.length; ++i) {
                if (tempArray[i].trim().equals("")) continue;
                ISPRECISION = (String)Hashtable1.get(FID + "." + tempArray[i]);
                if (ISPRECISION == null) {
                    ISPRECISION = "0";
                }
                if ((ISMUST = (String)Hashtable2.get(FID + "." + tempArray[i])) == null) {
                    ISMUST = "0";
                }
                if ((ISDAY = (String)Hashtable3.get(FID + "." + tempArray[i])) == null) {
                    ISDAY = "0";
                }
                if ((DVALUE = (String)Hashtable4.get(FID + "." + tempArray[i])) == null) {
                    DVALUE = "";
                }
                strSql = "Insert Into QUERY_CONFIG_QUERYFIELD(ID,FID,FIELD,ISPRECISION,ISMUST,ISDAY,DVALUE) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo, 8, i) + "','" + FID + "','" + tempArray[i] + "','" + ISPRECISION + "','" + ISMUST + "','" + ISDAY + "','" + DVALUE + "')";
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            result = true;
        }
        catch (Exception ex) {
            log.WriteLog("\u51fa\u73b0\u5f02\u5e38", ex.getMessage());
            result = false;
        }
        return result;
    }

    public QUERY_CONFIG_QUERYFIELD[] GetQueryFieldByWhere(String strWhere) {
        QUERY_CONFIG_QUERYFIELD[] entityList = null;
        StringBuffer strSql = new StringBuffer();
        try {
            if (strWhere.trim().length() == 0) {
                strSql.append("Select * From QUERY_CONFIG_QUERYFIELD ");
            } else {
                strSql.append("Select * From QUERY_CONFIG_QUERYFIELD  where ").append(strWhere);
            }
            strSql.append(" Order by ID");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            if (mdbset == null) {
                entityList = null;
            } else {
                entityList = new QUERY_CONFIG_QUERYFIELD[mdbset.RowCount()];
                for (int i = 0; i < mdbset.RowCount(); ++i) {
                    entityList[i] = new QUERY_CONFIG_QUERYFIELD();
                    entityList[i].fullData(mdbset.Row(i));
                }
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("GetQueryFieldByWhere", "GetQueryFieldByWhere\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            entityList = null;
        }
        return entityList;
    }

    public boolean SaveResultFieldProperty(String FID, String disFieldInfoStr, String hidFieldInfoStr) {
        boolean result = false;
        StringBuffer strSql = new StringBuffer();
        String ISNUMBER = "0";
        String QALIGN = "0";
        try {
            int i;
            strSql.append("Delete from QUERY_CONFIG_SHOWFIELD Where FID='" + FID + "'");
            this.dbengine.ExecuteSQL(strSql.toString());
            String[] tempArray = disFieldInfoStr.split(",");
            String MaxFieldNo = this.GetMaxFieldNo("QUERY_CONFIG_SHOWFIELD", "ID", 8);
            for (i = 0; i < tempArray.length; ++i) {
                if (tempArray[i].trim().equals("")) continue;
                String[] tempArray1 = tempArray[i].split("#");
                ISNUMBER = tempArray1[2] == null ? "0" : (tempArray1[2].equals("\u662f") ? "1" : "0");
                if (tempArray1[3] == null) {
                    QALIGN = "0";
                }
                if (tempArray1[3].equals("\u5c45\u5de6")) {
                    QALIGN = "0";
                }
                if (tempArray1[3].equals("\u5c45\u4e2d")) {
                    QALIGN = "1";
                }
                if (tempArray1[3].equals("\u5c45\u53f3")) {
                    QALIGN = "2";
                }
                strSql.delete(0, strSql.length());
                strSql.append("Insert Into QUERY_CONFIG_SHOWFIELD(ID,FID,FIELD,ISSHOW,COLWIDTH,ISNUMBER,QALIGN) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo, 8, i) + "'," + "'" + FID + "'," + "'" + tempArray1[0] + "','1','").append(tempArray1[1] + "','" + ISNUMBER + "'" + ",'" + QALIGN + "')");
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            tempArray = hidFieldInfoStr.split(",");
            String MaxFieldNo1 = this.GetMaxFieldNo("QUERY_CONFIG_SHOWFIELD", "ID", 8);
            for (i = 0; i < tempArray.length; ++i) {
                if (tempArray[i].trim().equals("")) continue;
                strSql.delete(0, strSql.length());
                strSql.append("Insert Into QUERY_CONFIG_SHOWFIELD(ID,FID,FIELD,ISSHOW,ISNUMBER,QALIGN) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo1, 8, i) + "'," + "'" + FID + "'," + "'" + tempArray[i] + "','0','0','0'" + ")");
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            result = true;
        }
        catch (Exception ex) {
            log.WriteLog("\u51fa\u73b0\u5f02\u5e38", ex.getMessage());
            result = false;
        }
        return result;
    }

    public QUERY_CONFIG_SHOWFIELD[] GetResultFieldByWhere(String strWhere) {
        QUERY_CONFIG_SHOWFIELD[] entityList = null;
        StringBuffer strSql = new StringBuffer();
        try {
            if (strWhere.trim().length() == 0) {
                strSql.append("Select * From QUERY_CONFIG_SHOWFIELD ");
            } else {
                strSql.append("Select * From QUERY_CONFIG_SHOWFIELD  where ").append(strWhere);
            }
            strSql.append(" Order by ID");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            if (mdbset == null) {
                entityList = null;
            } else {
                entityList = new QUERY_CONFIG_SHOWFIELD[mdbset.RowCount()];
                for (int i = 0; i < mdbset.RowCount(); ++i) {
                    entityList[i] = new QUERY_CONFIG_SHOWFIELD();
                    entityList[i].fullData(mdbset.Row(i));
                }
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("GetResultFieldByWhere", "GetResultFieldByWhere\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            entityList = null;
        }
        return entityList;
    }

    public boolean SaveDetailParameterProperty(String FID, String FieldInfoStr, String BRelationInfoStr) {
        boolean result = false;
        String[] tempArray1 = FieldInfoStr.split("&");
        StringBuffer strSql = new StringBuffer();
        try {
            int i;
            strSql.append("Delete from QUERY_CONFIG_PARAMETER Where FID='" + FID + "'");
            this.dbengine.ExecuteSQL(strSql.toString());
            String MaxFieldNo = this.GetMaxFieldNo("QUERY_CONFIG_PARAMETER", "ID", 8);
            for (i = 0; i < tempArray1.length; ++i) {
                String[] tempArray2 = tempArray1[i].split("#");
                if (tempArray2[0].length() == 0) continue;
                strSql.delete(0, strSql.length());
                strSql.append("Insert Into QUERY_CONFIG_PARAMETER(ID,FID,NAME,FIELD,BID) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo, 8, i) + "'," + "'" + FID + "'," + "'" + tempArray2[0] + "'," + "'" + tempArray2[1] + "'," + "'" + tempArray2[2] + "'" + ")");
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            tempArray1 = BRelationInfoStr.split(",");
            strSql.delete(0, strSql.length());
            strSql.append("Delete from QUERY_CONFIG_BRELATION Where FID='" + FID + "'");
            this.dbengine.ExecuteSQL(strSql.toString());
            String MaxFieldNo1 = this.GetMaxFieldNo("QUERY_CONFIG_BRELATION", "ID", 8);
            for (i = 0; i < tempArray1.length; ++i) {
                if (tempArray1[i].trim().equals("")) continue;
                strSql.delete(0, strSql.length());
                strSql.append("Insert Into QUERY_CONFIG_BRELATION(ID,FID,BID) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo1, 8, i) + "'," + "'" + FID + "'," + "'" + tempArray1[i] + "'" + ")");
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            result = true;
        }
        catch (Exception ex) {
            log.WriteLog("\u51fa\u73b0\u5f02\u5e38", ex.getMessage());
            result = false;
        }
        return result;
    }

    public QUERY_CONFIG_PARAMETER[] GetDetailParameterFieldByWhere(String strWhere) {
        QUERY_CONFIG_PARAMETER[] entityList = null;
        StringBuffer strSql = new StringBuffer();
        try {
            if (strWhere.trim().length() == 0) {
                strSql.append("Select * From QUERY_CONFIG_PARAMETER ");
            } else {
                strSql.append("Select * From QUERY_CONFIG_PARAMETER  where ").append(strWhere);
            }
            strSql.append(" Order by ID");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            if (mdbset == null) {
                return null;
            }
            entityList = new QUERY_CONFIG_PARAMETER[mdbset.RowCount()];
            for (int i = 0; i < mdbset.RowCount(); ++i) {
                entityList[i] = new QUERY_CONFIG_PARAMETER();
                entityList[i].fullData(mdbset.Row(i));
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("GetDetailParameterFieldByWhere", "GetDetailParameterFieldByWhere\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            entityList = null;
        }
        return entityList;
    }

    public boolean SaveSortProperty(String FID, String FieldInfoStr) {
        boolean result = false;
        StringBuffer strSql = new StringBuffer();
        String[] tempArray1 = FieldInfoStr.split("&");
        try {
            strSql.append("Delete from QUERY_CONFIG_ORDER Where FID='" + FID).append("'");
            this.dbengine.ExecuteSQL(strSql.toString());
            String MaxFieldNo = this.GetMaxFieldNo("QUERY_CONFIG_ORDER", "ID", 8);
            for (int i = 0; i < tempArray1.length; ++i) {
                String[] tempArray2 = tempArray1[i].split("#");
                if (tempArray2[0].length() == 0) continue;
                strSql.delete(0, strSql.length());
                strSql.append("Insert Into QUERY_CONFIG_ORDER(ID,FID,FIELD,TYPE) Values('" + this.GetMaxFieldNoAdd(MaxFieldNo, 8, i) + "'," + "'" + FID + "'," + "'" + tempArray2[0] + "'," + "'" + tempArray2[1] + "'" + ")");
                this.dbengine.ExecuteSQL(strSql.toString());
            }
            result = true;
        }
        catch (Exception ex) {
            result = false;
        }
        try {
            QueryControl queryControl = new QueryControl();
            queryControl.inithashtable();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    public QUERY_CONFIG_ORDER[] GetSortByWhere(String strWhere) {
        QUERY_CONFIG_ORDER[] entityList = null;
        StringBuffer strSql = new StringBuffer();
        try {
            if (strWhere.trim().length() == 0) {
                strSql.append("Select * From QUERY_CONFIG_ORDER ");
            } else {
                strSql.append("Select * From QUERY_CONFIG_ORDER  where ").append(strWhere);
            }
            strSql.append(" Order by ID");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            if (mdbset == null) {
                return null;
            }
            entityList = new QUERY_CONFIG_ORDER[mdbset.RowCount()];
            for (int i = 0; i < mdbset.RowCount(); ++i) {
                entityList[i] = new QUERY_CONFIG_ORDER();
                entityList[i].fullData(mdbset.Row(i));
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("GetSortByWhere", "GetSortByWhere\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            entityList = null;
        }
        return entityList;
    }

    public boolean DeleteConfigByID(String FID) {
        boolean result = false;
        StringBuffer strSql = new StringBuffer();
        try {
            strSql.append("Delete from QUERY_CONFIG_PARAMETER Where FID='" + FID + "';" + "Delete from QUERY_CONFIG_CONNECTION Where FID='").append(FID + "';" + "Delete from QUERY_CONFIG_INIT Where FID='" + FID).append("';Delete QUERY_CONFIG_QUERYFIELD Where FID='").append(FID + "';" + "Delete from QUERY_CONFIG_SHOWFIELD Where FID='").append(FID + "';" + "Delete from QUERY_CONFIG_BRELATION Where FID='").append(FID + "';" + "Delete from QUERY_CONFIG_ORDER Where FID='" + FID + "';" + "Delete from QUERY_CONFIG_BUTTON Where FID='" + FID + "';" + "Delete from QUERY_CONFIG_TABLE Where ID='" + FID).append("';");
            this.dbengine.ExecuteSQLs(strSql.toString().split(";"));
            result = true;
        }
        catch (Exception ex) {
            log.WriteLog("\u51fa\u73b0\u5f02\u5e38", ex.getMessage());
            result = false;
        }
        return result;
    }

    public String GetMaxFieldNo(String TableName, String FieldName, int FieldLen) {
        String MaxNo = "";
        int LenMaxNo = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("SELECT MAX(" + FieldName + ") AS MaxNo FROM " + TableName);
        try {
            dbSet dbset = this.dbengine.QuerySQL(strSql.toString());
            if (dbset != null && dbset.RowCount() > 0) {
                MaxNo = dbset.Row(0).Column("MaxNo").getString();
                if (MaxNo.length() > 0) {
                    MaxNo = String.valueOf(Integer.parseInt(MaxNo) + 1);
                    LenMaxNo = MaxNo.length();
                    MaxNo = "0000000000000000000000000" + MaxNo;
                } else {
                    MaxNo = "00000000000000000000000001";
                    LenMaxNo = 1;
                }
            }
            dbset = null;
            MaxNo = MaxNo.substring(25 - FieldLen + LenMaxNo);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        return MaxNo;
    }

    private String GetMaxFieldNoAdd(String strMaxNO, int FieldLen, int intadd) {
        String MaxNo = "";
        int LenMaxNo = 0;
        try {
            MaxNo = strMaxNO;
            if (MaxNo.length() > 0) {
                MaxNo = String.valueOf(Integer.parseInt(MaxNo) + intadd);
                LenMaxNo = MaxNo.length();
                StringBuffer addBuf = new StringBuffer();
                addBuf.append("0000000000000000000000000" + MaxNo);
                MaxNo = addBuf.toString();
            } else {
                MaxNo = "00000000000000000000000001";
                LenMaxNo = 1;
            }
            MaxNo = MaxNo.substring(25 - FieldLen + LenMaxNo);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        return MaxNo;
    }

    public QUERY_CONFIG_TABLE[] All_Query_List(String where) {
        QUERY_CONFIG_TABLE[] bgs = null;
        StringBuffer strSql = new StringBuffer();
        try {
            if (where.trim().length() == 0) {
                strSql.append("Select * From QUERY_CONFIG_TABLE ");
            } else {
                strSql.append("Select * From QUERY_CONFIG_TABLE where " + where);
            }
            strSql.append(" Order by ID ");
            dbSet mdbset = this.dbengine.QuerySQL(strSql.toString());
            bgs = new QUERY_CONFIG_TABLE[mdbset.RowCount()];
            if (mdbset.RowCount() == 0) {
                return null;
            }
            for (int i = 0; i < mdbset.RowCount(); ++i) {
                bgs[i] = new QUERY_CONFIG_TABLE();
                bgs[i].fullData(mdbset.Row(i));
            }
            mdbset = null;
        }
        catch (Exception e) {
            log.WriteLog("All_Query_List", "All_Query_List\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            return null;
        }
        return bgs;
    }

    public List GetTableList(String tableName) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        StringBuffer strSql = new StringBuffer();
        if (tableName.trim().length() > 0) {
            strSql.append("Select TableName,ChineseName  from BPIP_TABLE where TableName !='").append(tableName + "' order by ChineseName");
        } else {
            strSql.append("Select TableName,ChineseName  from BPIP_TABLE order by ChineseName");
        }
        dbSet ds = this.dbengine.QuerySQL(strSql.toString());
        if (ds != null && ds.RowCount() > 0) {
            for (int i = 0; i < ds.RowCount(); ++i) {
                String[] saTmp = new String[]{ds.Row(i).Column("TableName").getString(), ds.Row(i).Column("CHINESENAME").getString()};
                result.add(saTmp);
            }
        }
        ds = null;
        return result;
    }

    public List GetFieldList(String TableName) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        StringBuffer strSql = new StringBuffer();
        strSql.append("select FieldID,FieldName,CHINESENAME from bpip_field Where TABLEID=(Select TableID From Bpip_Table Where TableName='").append(TableName.toUpperCase() + "') And FIELDTYPE!='3' Order by FieldID");
        dbSet ds = this.dbengine.QuerySQL(strSql.toString());
        if (ds != null && ds.RowCount() > 0) {
            for (int i = 0; i < ds.RowCount(); ++i) {
                String[] saTmp = new String[]{ds.Row(i).Column("FieldName").getString(), ds.Row(i).Column("CHINESENAME").getString()};
                result.add(saTmp);
            }
        }
        ds = null;
        return result;
    }

    public List GetTableFieldList(String TableName, boolean flag) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        String strSql = "";
        String strSqlA = "";
        String strTMP = "";
        dbSet ds = null;
        dbSet ds1 = null;
        String[] tableArray = TableName.split("\\.");
        if (tableArray.length > 0) {
            String[] saTmp;
            int i;
            String tmpTableName = tableArray[0];
            if (this.DataBaseType.equals("3")) {
                strSql = "Select b.Tablename,a.FieldName,a.fieldtype, b.CHINESENAME  FROM bpip_field a,bpip_table b where a.Tableid=b.tableid And b.TableName='" + tmpTableName + "' And a.FIELDTYPE!='3' Order By b.TableId,a.FieldId";
                strSqlA = "Select b.Tablename,a.FieldName,a.fieldtype, a.CHINESENAME  FROM bpip_field a,bpip_table b where a.Tableid=b.tableid And b.TableName='" + tmpTableName + "' And a.FIELDTYPE!='3' Order By b.TableId,a.FieldId";
                ds1 = this.dbengine.QuerySQL(strSqlA);
            } else {
                strSql = "Select b.Tablename,a.FieldName,a.fieldtype, b.CHINESENAME as tableCHINESENAME,a.CHINESENAME as fieldCHINESENAME   FROM bpip_field a,bpip_table b where a.Tableid=b.tableid And b.TableName='" + tmpTableName + "' And a.FIELDTYPE!='3' Order By b.TableId,a.FieldId";
            }
            ds = this.dbengine.QuerySQL(strSql);
            if (ds != null && ds.RowCount() > 0) {
                for (i = 0; i < ds.RowCount(); ++i) {
                    saTmp = new String[2];
                    saTmp[0] = strTMP = ds.Row(i).Column("Tablename").getString() + "." + ds.Row(i).Column("FieldName").getString();
                    if (flag) {
                        saTmp[0] = strTMP = saTmp[0] + "." + ds.Row(i).Column("fieldtype").getString();
                    }
                    strTMP = this.DataBaseType.equals("3") ? ds.Row(i).Column("CHINESENAME").getString() + "." + ds1.Row(i).Column("CHINESENAME").getString() : ds.Row(i).Column("tableCHINESENAME").getString() + "." + ds.Row(i).Column("fieldCHINESENAME").getString();
                    saTmp[1] = strTMP;
                    result.add(saTmp);
                }
            }
            if (tableArray.length > 1) {
                tmpTableName = "";
                for (i = 1; i < tableArray.length; ++i) {
                    tmpTableName = strTMP = tmpTableName + "'" + tableArray[i] + "',";
                }
                tmpTableName = strTMP = tmpTableName + "''";
                if (this.DataBaseType.equals("3")) {
                    strSql = "Select b.Tablename,a.FieldName,a.fieldtype, b.CHINESENAME  FROM bpip_field a,bpip_table b where a.Tableid=b.tableid And b.TableName In(" + tmpTableName + ") And a.FIELDTYPE!='3' Order By b.TableId,a.FieldId";
                    strSqlA = "Select b.Tablename,a.FieldName,a.fieldtype, a.CHINESENAME  FROM bpip_field a,bpip_table b where a.Tableid=b.tableid And b.TableName In(" + tmpTableName + ") And a.FIELDTYPE!='3' Order By b.TableId,a.FieldId";
                    ds1 = this.dbengine.QuerySQL(strSqlA);
                } else {
                    strSql = "Select b.Tablename,a.FieldName,a.fieldtype, b.CHINESENAME as tableCHINESENAME,a.CHINESENAME as fieldCHINESENAME   FROM bpip_field a,bpip_table b where a.Tableid=b.tableid And b.TableName In(" + tmpTableName + ") And a.FIELDTYPE!='3' Order By b.TableId,a.FieldId";
                }
                ds = this.dbengine.QuerySQL(strSql);
                if (ds != null && ds.RowCount() > 0) {
                    for (i = 0; i < ds.RowCount(); ++i) {
                        saTmp = new String[2];
                        saTmp[0] = strTMP = ds.Row(i).Column("Tablename").getString() + "." + ds.Row(i).Column("FieldName").getString();
                        if (flag) {
                            saTmp[0] = strTMP = saTmp[0] + "." + ds.Row(i).Column("fieldtype").getString();
                        }
                        strTMP = this.DataBaseType.equals("3") ? ds.Row(i).Column("CHINESENAME").getString() + "." + ds1.Row(i).Column("CHINESENAME").getString() : ds.Row(i).Column("tableCHINESENAME").getString() + "." + ds.Row(i).Column("fieldCHINESENAME").getString();
                        saTmp[1] = strTMP;
                        result.add(saTmp);
                    }
                }
            }
        }
        ds = null;
        return result;
    }

    public String GetTableFieldCnNameByEn(String tableFieldName) {
        dbSet ds;
        String strSql = "";
        String strSqlA = "";
        String strTMP = "";
        String resultStr = "";
        dbSet ds1 = null;
        if (this.DataBaseType.equals("1")) {
            strSql = "select b.CHINESENAME as tableCHINESENAME,a.CHINESENAME as fieldCHINESENAME FROM bpip_field a,bpip_table b where a.Tableid=b.tableid and b.tablename||'.'||a.fieldname='" + tableFieldName + "'";
        }
        if (this.DataBaseType.equals("2")) {
            strSql = "select b.CHINESENAME as tableCHINESENAME,a.CHINESENAME as fieldCHINESENAME FROM bpip_field a,bpip_table b where a.Tableid=b.tableid and b.tablename+'.'+a.fieldname='" + tableFieldName + "'";
        }
        if (this.DataBaseType.equals("3")) {
            strSql = "select b.CHINESENAME FROM bpip_field a,bpip_table b where a.Tableid=b.tableid and concat(b.tablename,'.',a.fieldname)='" + tableFieldName + "'";
            strSqlA = "select a.CHINESENAME FROM bpip_field a,bpip_table b where a.Tableid=b.tableid and concat(b.tablename,'.',a.fieldname)='" + tableFieldName + "'";
            ds1 = this.dbengine.QuerySQL(strSqlA);
        }
        if ((ds = this.dbengine.QuerySQL(strSql)) != null && ds.RowCount() > 0) {
            strTMP = this.DataBaseType.equals("3") ? ds.Row(0).Column("CHINESENAME").getString() + "." + ds1.Row(0).Column("CHINESENAME").getString() : ds.Row(0).Column("tableCHINESENAME").getString() + "." + ds.Row(0).Column("fieldCHINESENAME").getString();
            resultStr = strTMP;
        }
        ds = null;
        return resultStr;
    }

    public String Max_OrderNo(String prentNo) {
        int intResult = 0;
        String strMenu_No = "";
        String strMaxNO = "0";
        StringBuffer strSql = new StringBuffer();
        strSql.append("SELECT MAX(ORDERCODE) AS MAX_NO FROM BPIP_MENU WHERE MENUNO like '").append(prentNo + "___'");
        try {
            dbSet dbset = this.dbengine.QuerySQL(strSql.toString());
            if (dbset != null && (strMaxNO = dbset.Row(0).Column("MAX_NO").getString()).length() == 0) {
                strMaxNO = "0";
            }
            strMenu_No = (intResult = Integer.parseInt(strMaxNO)) == 0 ? "0" : String.valueOf(intResult + 1001).substring(2, 4);
            dbset = null;
        }
        catch (Exception ex) {
            log.WriteLog("Max_OrderNo", "Max_OrderNo\u51fa\u73b0\u5f02\u5e38\uff01" + ex.getMessage());
        }
        return strMenu_No;
    }

    private String ConvertQuotationSingleToDouble(String expression) {
        return expression.replaceAll("'", "''");
    }

    public boolean querycopy(String strID) {
        QUERY_CONFIG_TABLE MTABLE = new QUERY_CONFIG_TABLE();
        QUERY_CONFIG_SHOWFIELD[] SHOWFIELD = null;
        QUERY_CONFIG_QUERYFIELD[] QUERYFIELD = null;
        QUERY_CONFIG_INIT[] INIT = null;
        QUERY_CONFIG_CONNECTION[] CONNECTION = null;
        QUERY_CONFIG_BRELATION[] BRELATION = null;
        QUERY_CONFIG_PARAMETER[] PARAMETER = null;
        QUERY_CONFIG_ORDER[] ORDER = null;
        QUERY_CONFIG_BUTTON[] QBUTTON = null;
        String strTmp = "";
        String strMaxNo = "";
        String strFID = "";
        String strSql = "";
        strSql = "Select * From QUERY_CONFIG_TABLE where  ID  ='" + strID + "'";
        dbSet dbset1 = this.dbengine.QuerySQL(strSql);
        if (dbset1 != null) {
            if (dbset1.RowCount() > 0) {
                strFID = strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_TABLE", "ID", 8);
                MTABLE.fullData(dbset1.Row(0));
                MTABLE.setID(strMaxNo);
                strTmp = dbset1.Row(0).Column("NAME").getString();
                MTABLE.setNAME("\u590d\u4ef6_" + strTmp);
                this.dbengine.ExecuteInsert(MTABLE.getData());
                MTABLE = null;
            }
            dbset1 = null;
        }
        if (strFID.length() > 0) {
            int i;
            strSql = "Select * From QUERY_CONFIG_SHOWFIELD where FID ='" + strID + "' order by ID";
            dbset1 = this.dbengine.QuerySQL(strSql);
            if (dbset1 != null) {
                if (dbset1.RowCount() > 0) {
                    SHOWFIELD = new QUERY_CONFIG_SHOWFIELD[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        SHOWFIELD[i] = new QUERY_CONFIG_SHOWFIELD();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_SHOWFIELD", "ID", 8);
                        SHOWFIELD[i].fullData(dbset1.Row(i));
                        SHOWFIELD[i].setID(strMaxNo);
                        SHOWFIELD[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(SHOWFIELD[i].getData());
                    }
                    SHOWFIELD = null;
                }
                dbset1 = null;
            }
            if ((dbset1 = this.dbengine.QuerySQL(strSql = "Select * From QUERY_CONFIG_QUERYFIELD where FID ='" + strID + "' order by ID")) != null) {
                if (dbset1.RowCount() > 0) {
                    QUERYFIELD = new QUERY_CONFIG_QUERYFIELD[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        QUERYFIELD[i] = new QUERY_CONFIG_QUERYFIELD();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_QUERYFIELD", "ID", 8);
                        QUERYFIELD[i].fullData(dbset1.Row(i));
                        QUERYFIELD[i].setID(strMaxNo);
                        QUERYFIELD[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(QUERYFIELD[i].getData());
                    }
                    QUERYFIELD = null;
                }
                dbset1 = null;
            }
            if ((dbset1 = this.dbengine.QuerySQL(strSql = "Select * From QUERY_CONFIG_INIT where FID ='" + strID + "' order by ID")) != null) {
                if (dbset1.RowCount() > 0) {
                    INIT = new QUERY_CONFIG_INIT[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        INIT[i] = new QUERY_CONFIG_INIT();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_INIT", "ID", 8);
                        INIT[i].fullData(dbset1.Row(i));
                        INIT[i].setID(strMaxNo);
                        INIT[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(INIT[i].getData());
                    }
                    INIT = null;
                }
                dbset1 = null;
            }
            if ((dbset1 = this.dbengine.QuerySQL(strSql = "Select * From QUERY_CONFIG_CONNECTION where FID ='" + strID + "' order by ID")) != null) {
                if (dbset1.RowCount() > 0) {
                    CONNECTION = new QUERY_CONFIG_CONNECTION[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        CONNECTION[i] = new QUERY_CONFIG_CONNECTION();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_CONNECTION", "ID", 8);
                        CONNECTION[i].fullData(dbset1.Row(i));
                        CONNECTION[i].setID(strMaxNo);
                        CONNECTION[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(CONNECTION[i].getData());
                    }
                    CONNECTION = null;
                }
                dbset1 = null;
            }
            if ((dbset1 = this.dbengine.QuerySQL(strSql = "Select * From QUERY_CONFIG_BRELATION where FID ='" + strID + "' order by ID")) != null) {
                if (dbset1.RowCount() > 0) {
                    BRELATION = new QUERY_CONFIG_BRELATION[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        BRELATION[i] = new QUERY_CONFIG_BRELATION();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_BRELATION", "ID", 8);
                        BRELATION[i].fullData(dbset1.Row(i));
                        BRELATION[i].setID(strMaxNo);
                        BRELATION[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(BRELATION[i].getData());
                    }
                    BRELATION = null;
                }
                dbset1 = null;
            }
            if ((dbset1 = this.dbengine.QuerySQL(strSql = "Select * From QUERY_CONFIG_PARAMETER where FID ='" + strID + "' order by ID")) != null) {
                if (dbset1.RowCount() > 0) {
                    PARAMETER = new QUERY_CONFIG_PARAMETER[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        PARAMETER[i] = new QUERY_CONFIG_PARAMETER();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_PARAMETER", "ID", 8);
                        PARAMETER[i].fullData(dbset1.Row(i));
                        PARAMETER[i].setID(strMaxNo);
                        PARAMETER[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(PARAMETER[i].getData());
                    }
                    PARAMETER = null;
                }
                dbset1 = null;
            }
            if ((dbset1 = this.dbengine.QuerySQL(strSql = "Select * From QUERY_CONFIG_ORDER where FID ='" + strID + "' order by ID")) != null) {
                if (dbset1.RowCount() > 0) {
                    ORDER = new QUERY_CONFIG_ORDER[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        ORDER[i] = new QUERY_CONFIG_ORDER();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_ORDER", "ID", 8);
                        ORDER[i].fullData(dbset1.Row(i));
                        ORDER[i].setID(strMaxNo);
                        ORDER[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(ORDER[i].getData());
                    }
                    ORDER = null;
                }
                dbset1 = null;
            }
            if ((dbset1 = this.dbengine.QuerySQL(strSql = "Select * From QUERY_CONFIG_BUTTON where FID ='" + strID + "' order by ID")) != null) {
                if (dbset1.RowCount() > 0) {
                    QBUTTON = new QUERY_CONFIG_BUTTON[dbset1.RowCount()];
                    for (i = 0; i < dbset1.RowCount(); ++i) {
                        QBUTTON[i] = new QUERY_CONFIG_BUTTON();
                        strMaxNo = this.GetMaxFieldNo("QUERY_CONFIG_BUTTON", "ID", 8);
                        ORDER[i].fullData(dbset1.Row(i));
                        ORDER[i].setID(strMaxNo);
                        ORDER[i].setFID(strFID);
                        this.dbengine.ExecuteInsert(QBUTTON[i].getData());
                    }
                    QBUTTON = null;
                }
                dbset1 = null;
            }
        }
        return true;
    }

    public String getPrecision(String strID, String strFiled) {
        String sreturn = "0,0,0,0";
        String T1 = "0";
        String T2 = "0";
        String T3 = "0";
        String T4 = "0";
        String strSql = "Select ISPRECISION,ISMUST,ISDAY,DVALUE From QUERY_CONFIG_QUERYFIELD where FID ='" + strID + "' and FIELD='" + strFiled + "'";
        dbSet dbset = this.dbengine.QuerySQL(strSql);
        if (dbset != null && dbset.RowCount() > 0) {
            T1 = dbset.Row(0).Column("ISPRECISION").getString();
            T2 = dbset.Row(0).Column("ISMUST").getString();
            T3 = dbset.Row(0).Column("ISDAY").getString();
            T4 = dbset.Row(0).Column("DVALUE").getString();
            if (T1 == null) {
                T1 = "0";
            }
            if (T2 == null) {
                T2 = "0";
            }
            if (T3 == null) {
                T3 = "0";
            }
            if (T4 == null) {
                T4 = "0";
            }
            if (T1.length() == 0) {
                T1 = "0";
            }
            if (T2.length() == 0) {
                T2 = "0";
            }
            if (T3.length() == 0) {
                T3 = "0";
            }
            if (T4.length() == 0) {
                T4 = "0";
            }
        }
        sreturn = T1 + "," + T2 + "," + T3 + "," + T4;
        return sreturn;
    }

    public boolean setPrecision(String strID, String strFiled, String svalue) {
        String T1 = svalue.split(",")[0];
        String T2 = svalue.split(",")[1];
        String T3 = svalue.split(",")[2];
        String T4 = svalue.split(",")[3];
        try {
            QueryControl queryControl = new QueryControl();
            queryControl.inithashtable();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String strSql = "Update QUERY_CONFIG_QUERYFIELD set ISPRECISION='" + T1 + "',ISMUST='" + T2 + "',ISDAY='" + T3 + "',DVALUE='" + T4 + "'  where FID ='" + strID + "' and FIELD='" + strFiled + "'";
        return this.dbengine.ExecuteSQL(strSql);
    }

    static {
        clients = 0;
    }
}

