# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# Copyright 2022, Alex Zhornyak

import bpy
import bmesh


class DemoNames:
    group_even = 'Example - Even'
    group_odd = 'Example - Odd'


def api_demo_create_groups():

    C = bpy.context

    if C.mode != 'OBJECT':
        bpy.ops.object.mode_set(mode='OBJECT')

    bpy.ops.mesh.primitive_cube_add(enter_editmode=True, location=(-4, 0, 0))

    p_obj = C.active_object

    p_scene = C.scene
    # set 'Face Parts' mode
    p_scene.zen_sets_active_mode = 'face_u'

    # create 1 group with object even faces (0, 2, 4 ...)
    bm = bmesh.from_edit_mesh(p_obj.data)
    for face in bm.faces:
        face.select_set(face.index % 2 == 0)

    bpy.ops.zsts.assign_to_group(
        group_name=DemoNames.group_even, group_color=(1, 0, 0))

    # create 2 group with object odd faces (1, 3, 5 ...)
    bm = bmesh.from_edit_mesh(p_obj.data)
    for face in bm.faces:
        face.select_set(face.index % 2 != 0)

    bpy.ops.zsts.assign_to_group(
        group_name=DemoNames.group_odd, group_color=(0, 0, 1))


# DEMO
api_demo_create_groups()
