# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# Copyright 2022, Alex Zhornyak

import bpy
import bmesh


class DemoNames:
    group_even = 'Example - Even'
    group_odd = 'Example - Odd'
    group_multi = 'Example - Multi'


def api_demo_create_groups_by_indices():

    C = bpy.context

    if C.mode != 'OBJECT':
        bpy.ops.object.mode_set(mode='OBJECT')

    objects = []
    bpy.ops.mesh.primitive_cube_add(location=(0, 4, 0))
    objects.append(C.active_object)
    bpy.ops.mesh.primitive_cube_add(location=(4, 4, 0))
    objects.append(C.active_object)
    bpy.ops.mesh.primitive_cube_add(location=(8, 4, 0))
    objects.append(C.active_object)

    bpy.ops.object.select_all(action='DESELECT')
    for p_obj in objects:
        p_obj.select_set(True)

    bpy.ops.object.mode_set(mode='EDIT')

    p_scene = C.scene
    # set 'Face Parts' mode
    p_scene.zen_sets_active_mode = 'face_u'

    p_obj = objects[0]
    bm = bmesh.from_edit_mesh(p_obj.data)

    # create 1 group with object even faces (0, 2, 4 ...)
    bpy.ops.zsts.assign_to_group(
        group_mode='INDICES',
        group_indices=tuple(
            {'item': face.index, 'name': p_obj.name}
            for face in bm.faces if face.index % 2 == 0),
        group_name=DemoNames.group_even, group_color=(1, 0, 0))

    def indices_to_props(indices: set(), obj_name):
        return tuple(
            {'item': idx, 'name': obj_name} for idx in indices)

    # create 2 group with object odd faces (1, 3, 5 ...)
    bpy.ops.zsts.assign_to_group(
        group_mode='INDICES',
        # user friendly but twice copy, performance warning !
        group_indices=indices_to_props(
            (face.index for face in bm.faces if face.index % 2 != 0),
            p_obj.name),
        group_name=DemoNames.group_odd, group_color=(0, 0, 1))

    # MULTIPLE OBJECTS
    p_group_indices = []

    # 1) prepare the first object
    p_obj = objects[1]
    bm = bmesh.from_edit_mesh(p_obj.data)
    p_group_indices.extend([
        {'item': face.index, 'name': p_obj.name}
        for face in bm.faces if face.index % 2 == 0])

    # 2) prepare the second object
    p_obj = objects[2]
    bm = bmesh.from_edit_mesh(p_obj.data)
    p_group_indices.extend([{
        'item': face.index, 'name': p_obj.name}
        for face in bm.faces if face.index % 2 != 0])

    bpy.ops.zsts.assign_to_group(
        group_mode='INDICES',
        group_indices=p_group_indices,
        group_name=DemoNames.group_multi, group_color=(0, 1, 0))


# DEMO
api_demo_create_groups_by_indices()
