﻿# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

import bpy
import json
import os

""" Init Zen Sets """

from .blender_zen_utils import ZenPolls

from . import sets
from . import keymap_manager
from . import ico
from . import preferences
from . import addon_test
from . import manual_map
from . import right_menu_inject


from .vlog import Log


bl_info = {
    "name": "Zen Sets",
    "author": "Valeriy Yatsenko, Sergey Tyapkin, Viktor [VAN] Teplov, Alex Zhornyak",
    "version": (2, 0, 0, 25),
    "description": "Create and manage Groups of mesh Elements (Verts, Edges, Faces)",
    "blender": (2, 80, 0),
    "location": "View3D > Sidebar > Zen Sets",
    "warning": "",
    "category": "3D View",
    "tracker_url": "https://discordapp.com/invite/wGpFeME",
    "doc_url": "https://zen-masters.github.io/Zen-Sets/"
}

# ORDER IS IMPORTANT !
modules = (
    ico,
    preferences,
    sets,
    keymap_manager,
    manual_map,
    addon_test,
    right_menu_inject,
)


def register():
    """ Register classes """

    if bpy.app.version >= (3, 2, 0):
        ZenPolls.version_greater_3_2_0 = True

    if Log.ENABLE_DEBUG:
        try:
            dbg_info = json.loads(os.environ['ADDONS_TO_LOAD'])
            if len(dbg_info) == 1:
                dbg_data = dbg_info[0]
                module_name = dbg_data.get('module_name', '')
                if module_name != __package__:
                    Log.ENABLE_DEBUG = False
        except Exception:
            pass

    for m in modules:
        m.register()


def unregister():
    """ Unregister classes """

    for m in reversed(modules):
        m.unregister()


if __name__ == "__main__":
    pass
