# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

import os
import bpy
import bpy.utils.previews
from enum import IntEnum

_zensets_preview_icons = None
_zensets_tools_icon_path = ""

_icons = (
    ('sets-vertex', '.png'),                    # 0
    ('parts-vertex', '.png'),                   # 1

    ('sets-edges', '.png'),                     # 2
    ('parts-edges', '.png'),                    # 3

    ('sets-faces', '.png'),                     # 4
    ('parts-faces', '.png'),                    # 5

    ('sets', '.png'),                           # 6
    ('parts', '.png'),                          # 7

    ('zen-sets', '.png'),                       # 8
    ('zen-sets-logo', '.svg'),                  # 9
    ('zen-sets-logo@2x', '.png'),               # 10

    ('Discord-Logo-White_32', '.png'),          # 11

    ('zen-uv_32', '.png'),                      # 12
    ('checker_32', '.png'),                     # 13

    ('zen-smart-select', '.png'),               # 14

    ('zen-bbq', '.png'),                        # 15
)


class ZIconsType(IntEnum):
    Vert = 0,
    VertP = 1,
    Edge = 2,
    EdgeP = 3,
    Face = 4,
    FaceP = 5,

    Sets = 6,
    Parts = 7,

    AddonLogoPng = 8,
    AddonLogoSvg = 9,
    AddonLogoPng2x = 10,

    DiscordLogo = 11,

    AddonZenUVLogo = 12,
    AddonZenChecker = 13,

    SmartSelect = 14,

    AddonZenBBQ = 15,


def zs_icon_get(id):
    global _zensets_preview_icons
    if _zensets_preview_icons:
        return _zensets_preview_icons[_icons[id][0]].icon_id
    return None


def zs_tool_icon():
    global _zensets_tools_icon_path
    if _zensets_tools_icon_path == '':
        _icons_dir = os.path.dirname(__file__)
        _zensets_tools_icon_path = os.path.join(_icons_dir, 'zen_sets')

    return _zensets_tools_icon_path


def register():

    _icons_dir = os.path.dirname(__file__)

    global _zensets_preview_icons
    if _zensets_preview_icons is None:
        _zensets_preview_icons = bpy.utils.previews.new()

        for icon in _icons:
            _zensets_preview_icons.load(icon[0], os.path.join(_icons_dir, icon[0] + icon[1]), 'IMAGE')


def unregister():
    global _zensets_preview_icons
    if _zensets_preview_icons:
        bpy.utils.previews.remove(_zensets_preview_icons)
        _zensets_preview_icons = None


if __name__ == "__main__":
    pass
