# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# <pep8 compliant>

# Created by Oleg Stepanov (DotBow)

import bpy


def _keymap():
    keymap = []

    wm = bpy.context.window_manager
    kc = wm.keyconfigs.addon

    modes = {'Mesh', 'Object Mode', 'UV Editor'}
    for mode in modes:
        km = kc.keymaps.new(name=mode, space_type='EMPTY')

        keymap.append((km, km.keymap_items.new('zsts.pie_menu',
                                               'D', 'PRESS', ctrl=True, shift=True, alt=False)))

        if mode == 'Object Mode':
            keymap.append((km, km.keymap_items.new(
                'zsto.new_group_move',
                'F1', 'PRESS', ctrl=False, shift=False, alt=True)))
            keymap.append((km, km.keymap_items.new(
                'zsto.new_group_link',
                'F1', 'PRESS', ctrl=True, shift=False, alt=False)))
            keymap.append((km, km.keymap_items.new(
                'zsto.colorize_selected',
                'L', 'PRESS', ctrl=False, shift=False, alt=True)))
        else:
            keymap.append((km, km.keymap_items.new(
                'zsts.new_group',
                'F1', 'PRESS', ctrl=False, shift=False, alt=True)))
            keymap.append((km, km.keymap_items.new(
                'zsts.assign_to_pinned_group',
                'F1', 'PRESS', ctrl=True, shift=False, alt=False)))

        kmi = km.keymap_items.new('zsts.smart_select', 'F2', 'PRESS', ctrl=False, shift=False, alt=True)
        kmi.properties.keep_active_group = False
        keymap.append((km, kmi))

        kmi = km.keymap_items.new('zsts.smart_select', 'F3', 'PRESS', ctrl=False, shift=False, alt=True)
        kmi.properties.keep_active_group = True
        kmi = keymap.append((km, kmi))

        keymap.append((km, km.keymap_items.new('zsts.draw_highlight',
                                               'F5', 'PRESS', ctrl=False, shift=False, alt=True)))

    return keymap


_KEY_READABLE_MAP = {
    # keyboard
    'NONE': "",
    "LEFTMOUSE": "LMB",
    "MIDDLEMOUSE": "MMB",
    "RIGHTMOUSE": "RMB",
    "BUTTON4MOUSE": "Btn4M",
    "BUTTON5MOUSE": "Btn5M",
    "BUTTON6MOUSE": "Btn6M",
    "BUTTON7MOUSE": "Btn7M",
    "MOUSEMOVE": "Mouse Move",
    "INBETWEEN_MOUSEMOVE": "INBETWEEN_MOUSEMOVE",
    "TRACKPADPAN": "TRACKPADPAN",
    "TRACKPADZOOM": "TRACKPADZOOM",
    "MOUSEROTATE": "MOUSEROTATE",
    "WHEELUPMOUSE": "Wheel Up",
    "WHEELDOWNMOUSE": "Wheel Down",
    "WHEELINMOUSE": "Wheel In",
    "WHEELOUTMOUSE": "Wheel Out",
    # It is not clear for user with Tweak
    "EVT_TWEAK_L": "LMB",  # "EVT_TWEAK_L": "Tweak L",
    "EVT_TWEAK_M": "MMB",  # "EVT_TWEAK_M": "Tweak M",
    "EVT_TWEAK_R": "RMB",  # "EVT_TWEAK_R": "Tweak R",
    "A": "A",
    "B": "B",
    "C": "C",
    "D": "D",
    "E": "E",
    "F": "F",
    "G": "G",
    "H": "H",
    "I": "I",
    "J": "J",
    "K": "K",
    "L": "L",
    "M": "M",
    "N": "N",
    "O": "O",
    "P": "P",
    "Q": "Q",
    "R": "R",
    "S": "S",
    "T": "T",
    "U": "U",
    "V": "V",
    "W": "W",
    "X": "X",
    "Y": "Y",
    "Z": "Z",
    "ZERO": "0",
    "ONE": "1",
    "TWO": "2",
    "THREE": "3",
    "FOUR": "4",
    "FIVE": "5",
    "SIX": "6",
    "SEVEN": "7",
    "EIGHT": "8",
    "NINE": "9",
    "LEFT_CTRL": "LCtrl",
    "LEFT_ALT": "LAlt",
    "LEFT_SHIFT": "LShift",
    "RIGHT_ALT": "RAlt",
    "RIGHT_CTRL": "RCtrl",
    "RIGHT_SHIFT": "RShift",
    "OSKEY": "Oskey",
    "GRLESS": "GRLess",
    "ESC": "ESC",
    "TAB": "Tab",
    "RET": "Ret",
    "SPACE": "Space",
    "LINE_FEED": "Line feed",
    "BACK_SPACE": "<-",
    "DEL": "Del",
    "SEMI_COLON": ";",
    "PERIOD": ".",
    "COMMA": ",",
    "QUOTE": '"',
    "ACCENT_GRAVE": "ACCENT_GRAVE",
    "MINUS": "-",
    "SLASH": "/",
    "BACK_SLASH": "\\",
    "EQUAL": "=",
    "LEFT_BRACKET": "{",
    "RIGHT_BRACKET": "}",
    "LEFT_ARROW": "Left Arrow",
    "DOWN_ARROW": "Down Arrow",
    "RIGHT_ARROW": "Right Arrow",
    "UP_ARROW": "Up Arrow",
    "NUMPAD_1": "Num 1",
    "NUMPAD_2": "Num 2",
    "NUMPAD_3": "Num 3",
    "NUMPAD_4": "Num 4",
    "NUMPAD_5": "Num 5",
    "NUMPAD_6": "Num 6",
    "NUMPAD_7": "Num 7",
    "NUMPAD_8": "Num 8",
    "NUMPAD_9": "Num 9",
    "NUMPAD_0": "Num 0",
    "NUMPAD_PERIOD": "Num .",
    "NUMPAD_SLASH": "Num /",
    "NUMPAD_ASTERIX": "Num *",
    "NUMPAD_MINUS": "Num -",
    "NUMPAD_ENTER": "Num Ret",
    "NUMPAD_PLUS": "Num +",
    "F1": "F1",
    "F2": "F2",
    "F3": "F3",
    "F4": "F4",
    "F5": "F5",
    "F6": "F6",
    "F7": "F7",
    "F8": "F8",
    "F9": "F9",
    "F10": "F10",
    "F11": "F11",
    "F12": "F12",
    "F13": "F13",
    "F14": "F14",
    "F15": "F15",
    "F16": "F16",
    "F17": "F17",
    "F18": "F18",
    "F19": "F19",
    "PAUSE": "Pause",
    "INSERT": "Ins",
    "HOME": "Home",
    "PAGE_UP": "Pg Up",
    "PAGE_DOWN": "Pg Down",
    "END": "End",
    "MEDIA_PLAY": "MEDIA_PLAY",
    "MEDIA_STOP": "MEDIA_STOP",
    "MEDIA_FIRST": "MEDIA_FIRST",
    "MEDIA_LAST": "MEDIA_LAST",
    "TEXTINPUT": "TEXTINPUT",
    "WINDOW_DEACTIVATE": "WINDOW_DEACTIVATE",
    "TIMER": "TIMER",
    "TIMER0": "TIMER0",
    "TIMER1": "TIMER1",
    "TIMER2": "TIMER2",
    "TIMER_JOBS": "TIMER_JOBS",
    "TIMER_AUTOSAVE": "TIMER_AUTOSAVE",
    "TIMER_REPORT": "TIMER_REPORT",
    "TIMERREGION": "TIMERREGION",
    "NDOF_MOTION": "NDOF_MOTION",
    "NDOF_BUTTON_MENU": "NDOF_BUTTON_MENU",
    "NDOF_BUTTON_FIT": "NDOF_BUTTON_FIT",
    "NDOF_BUTTON_TOP": "NDOF_BUTTON_TOP",
    "NDOF_BUTTON_BOTTOM": "NDOF_BUTTON_BOTTOM",
    "NDOF_BUTTON_LEFT": "NDOF_BUTTON_LEFT",
    "NDOF_BUTTON_RIGHT": "NDOF_BUTTON_RIGHT",
    "NDOF_BUTTON_FRONT": "NDOF_BUTTON_FRONT",
    "NDOF_BUTTON_BACK": "NDOF_BUTTON_BACK",
    "NDOF_BUTTON_ISO1": "NDOF_BUTTON_ISO1",
    "NDOF_BUTTON_ISO2": "NDOF_BUTTON_ISO2",
    "NDOF_BUTTON_ROLL_CW": "NDOF_BUTTON_ROLL_CW",
    "NDOF_BUTTON_ROLL_CCW": "NDOF_BUTTON_ROLL_CCW",
    "NDOF_BUTTON_SPIN_CW": "NDOF_BUTTON_SPIN_CW",
    "NDOF_BUTTON_SPIN_CCW": "NDOF_BUTTON_SPIN_CCW",
    "NDOF_BUTTON_TILT_CW": "NDOF_BUTTON_TILT_CW",
    "NDOF_BUTTON_TILT_CCW": "NDOF_BUTTON_TILT_CCW",
    "NDOF_BUTTON_ROTATE": "NDOF_BUTTON_ROTATE",
    "NDOF_BUTTON_PANZOOM": "NDOF_BUTTON_PANZOOM",
    "NDOF_BUTTON_DOMINANT": "NDOF_BUTTON_DOMINANT",
    "NDOF_BUTTON_PLUS": "NDOF_BUTTON_PLUS",
    "NDOF_BUTTON_MINUS": "NDOF_BUTTON_MINUS",
    "NDOF_BUTTON_ESC": "NDOF_BUTTON_ESC",
    "NDOF_BUTTON_ALT": "NDOF_BUTTON_ALT",
    "NDOF_BUTTON_SHIFT": "NDOF_BUTTON_SHIFT",
    "NDOF_BUTTON_CTRL": "NDOF_BUTTON_CTRL",
    "NDOF_BUTTON_1": "NDOF_BUTTON_1",
    "NDOF_BUTTON_2": "NDOF_BUTTON_2",
    "NDOF_BUTTON_3": "NDOF_BUTTON_3",
    "NDOF_BUTTON_4": "NDOF_BUTTON_4",
    "NDOF_BUTTON_5": "NDOF_BUTTON_5",
    "NDOF_BUTTON_6": "NDOF_BUTTON_6",
    "NDOF_BUTTON_7": "NDOF_BUTTON_7",
    "NDOF_BUTTON_8": "NDOF_BUTTON_8",
    "NDOF_BUTTON_9": "NDOF_BUTTON_9",
    "NDOF_BUTTON_10": "NDOF_BUTTON_10",
    "NDOF_BUTTON_A": "NDOF_BUTTON_A",
    "NDOF_BUTTON_B": "NDOF_BUTTON_B",
    "NDOF_BUTTON_C": "NDOF_BUTTON_C",
}
