# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

"""
    Zen Sets Text Blocks
"""


class ZsLabels:
    """ Zen Sets Labels and text blocks """
    # ADDON
    ADDON_NAME_LABEL = "Zen Sets"
    ADDON_NAME = "ZenSets"
    # ADDON_ICO = "zen-uv_32"

    PROP_SAMPLE_LABEL = "Just a sample Bool Variable"
    PROP_SAMPLE_DESC = "Description for sample Bool Variable"

    PROP_AUTO_HIGHLIGHT_LABEL = "Auto highlight"
    PROP_AUTO_HIGHLIGHT_DESC = "Switch On or Off highlight automatically"

    PROP_DISPLAY_ALL_PARTS_LABEL = "Display all Groups for Parts"
    PROP_DISPLAY_ALL_PARTS_DESC = "Enable 'All' option to Display all Groups in Parts Mode"

    PROP_AUTO_UPDATE_DRAW_CACHE_LABEL = "Auto update Draw Cache"
    PROP_AUTO_UPDATE_DRAW_CACHE_DESC = "Auto update Draw Cache if mesh changes"

    PROP_DISPLAY_PIE_ASSIST_LABEL = "Display Pie Assist"
    PROP_DISPLAY_PIE_ASSIST_DESC = "Display Pie Help Assist Panel"

    PROP_DISPLAY_PIE_ASSIST_FONTSIZE_LABEL = 'Pie Assist Font Size'
    PROP_DISPLAY_PIE_ASSIST_FONTSIZE_DESC = 'Pie Assist Font size that will be multiplied on UI scale'

    PROP_DISPLAY_MODIFIED_LABEL = "Display Mesh Mode"

    PROP_OBJECTS_SHADING_LABEL = "Objects Shading"
    PROP_OBJECTS_SHADING_DESC = "Display/Shade Objects in Object Mode"

    PROP_SYNC_MESH_SEL_LABEL = "Sync mode with mesh selection"
    PROP_SYNC_MESH_SEL_DESC = "Synchronize mesh selection mode with Zen Sets active mode"

    PROP_SEPARATE_GROUP_PANELS_LABEL = "Show separate Group panels"
    PROP_SEPARATE_GROUP_PANELS_DESC = "Show separate Group panels"

    PROP_COMPACT_MODE_LABEL = "Compact mode"
    PROP_COMPACT_MODE_DESC = "Show Element Modes in Compact mode"

    PROP_DEVELOPER_MODE_LABEL = "Developer mode"
    PROP_DEVELOPER_MODE_DESC = "Activates Developer mode in Zen Sets addon"

    PROP_IS_MESH_CUT = 'Delete Mesh After Creation'
    PROP_GROUP_MODE = 'Group Mode'

    PROP_JOIN_MESH_LABEL = "Join objects in Group"
    PROP_JOIN_MESH_DESC = "Join multiple Objects in Group after Mesh separation"

    PROP_ELEMENT_MODE_NAME = "Element"
    PROP_ELEMENT_MODE_DESC = "Zen Sets Element"

    PROP_UNIQUE_MODE_NAME = "Mode"
    PROP_UNIQUE_MODE_DESC = "Zen Sets Mode"

    PROP_ACTIVE_MODE_NAME = "Active Mode"
    PROP_ACTIVE_MODE_DESC = "Zen Sets Active Mode"

    PROP_GROUP_COLOR_NAME = "Group Color"
    PROP_GROUP_COLOR_DESC = "Zen Sets Group Color"

    PROP_COLOR_NAME = "Color"
    PROP_COLOR_DESC = "Zen Sets Color"

    PROP_DEFAULT_COLOR_NAME = "Default Color"
    PROP_DEFAULT_PINNED_COLOR_DESC = "Default Color for Pinned Group"

    PROP_IGNORED_COLOR_NAME = "Skipped Color"
    PROP_IGNORED_COLOR_DESC = "Color will be skipped"

    PROP_IMPORT_IGNORED_COLOR_NAME = "Skip Color"
    PROP_IMPORT_IGNORED_COLOR_DESC = "Color will be skipped"

    PROP_SEL_ONLY_ONE_GROUP_NAME = "Select only one group"
    PROP_SEL_ONLY_ONE_GROUP_DESC = "Select only one group if there are multiple groups present in selection"

    PROP_KEEP_ACTIVE_GROUP_NAME = "Keep selected group"
    PROP_KEEP_ACTIVE_GROUP_DESC = "Keep selected group when new elements append to selection"

    PROP_DISPLAY_ALL_SCENE_GROUPS_NAME = "Display all scene Groups"
    PROP_DISPLAY_ALL_SCENE_GROUPS_DESC = "Display all scene Groups or selected object groups"

    PROP_DISPLAY_HIDDEN_GROUPS_INFO_NAME = "Display hidden Groups Info"
    PROP_DISPLAY_HIDDEN_GROUPS_INFO_DESC = "Display hidden group elements count and monitor mesh hidden status"

    PROP_DISPLAY_VERTEX_GROUPS_WEIGHTS_NAME = "Display Vertex Groups Weights"
    PROP_DISPLAY_VERTEX_GROUPS_WEIGHTS_DESC = "Display Vertex Groups Weights and monitor weight changes"

    PROP_DISPLAY_EXCLUDED_GROUPS_INFO_NAME = "Display excluded Groups Info"
    PROP_DISPLAY_EXCLUDED_GROUPS_INFO_DESC = "Display excluded group status"

    PROP_DISPLAY_DISABLED_IN_RENDERS_NAME = "Display Disabled in Renders Info"
    PROP_DISPLAY_DISABLED_IN_RENDERS_DESC = "Display Disabled in Renders Info and monitor changes"

    PROP_DISPLAY_OBJECTS_INFO_NAME = "Display Objects Groups Info"
    PROP_DISPLAY_OBJECTS_INFO_DESC = "Display count of objects that have the Group"

    PROP_SELECTION_FOLLOW_ACT_GROUP_NAME = "Selection follows Selected Group"
    PROP_SELECTION_FOLLOW_ACT_GROUP_DESC = "Select all elements after Selected Group has been changed"

    PROP_AUTO_FRAME_SELECTED_NAME = "Auto Frame Selected Elements"
    PROP_AUTO_FRAME_SELECTED_DESC = "Move the view to the Selected elements center\nwhen selection changes"

    PROP_UNHIDE_OBJECTS_NAME = "Unhide"
    PROP_UNHIDE_OBJECTS_DESC = "Unhide hidden objects"

    PROP_MAKE_SELECTABLE_OBJECTS_NAME = "Make Selectable"
    PROP_MAKE_SELECTABLE_OBJECTS_DESC = "Make objects Selectable"

    PROP_SYNC_COLLECTION_COLOR_TAG_NAME = 'Sync Collections Icons'
    PROP_SYNC_COLLECTION_COLOR_TAG_DESC = 'Synchronize Collections color tag with Zen color'

    PROP_HIDE_COLLECTIONS_WITH_OBJECTS_NAME = 'Hide Collections with Objects'
    PROP_HIDE_COLLECTIONS_WITH_OBJECTS_DESC = 'Hide Collections with Objects in Zen Sets Tool mode'

    PROP_MOVE_OBJECTS_NAME = 'Move Objects'
    PROP_MOVE_OBJECTS_DESC = 'Move Objects to Selected Group'

    PROP_KEEP_NESTED_NAME = 'Keep Hierarchy'
    PROP_KEEP_NESTED_DESC = 'Keep nested collections structure on moving|linking objects'

    PROP_WITHOUT_NESTED_OBJECTS_NAME = 'Without nested Objects'
    PROP_WITHOUT_NESTED_OBJECTS_DESC = 'Without Objects in child Collections'

    PROP_LAYER_NAME = "Identifier"
    PROP_LAYER_NAME_DESC = "Unique identifier of the Group"

    PROP_GROUP_NAME = "Group Name"
    PROP_GROUP_NAME_DESC = "Zen Sets Group Name"

    PROP_PINNED_DESC = 'Name of the pinned Group for storing selected Elements'

    PROP_CONVERT_COL_TO_OBJ_DEFAULT_CENTER_POS_LABEL = 'Default Position'
    PROP_CONVERT_COL_TO_OBJ_DEFAULT_CENTER_POS_DESC = 'Default Center Position if no child Objects'

    PROP_CONVERT_COL_TO_OBJ_CALC_CENTER_POS_LABEL = 'Calculate Center'
    PROP_CONVERT_COL_TO_OBJ_CALC_CENTER_POS_DESC = 'Calculate Center Position by child Objects'

    PROP_CONVERT_COL_TO_OBJ_CALC_CENTER_USE_ROT_LABEL = 'Use average Rotation'
    PROP_CONVERT_COL_TO_OBJ_CALC_CENTER_USE_ROT_DESC = 'Calculate Center Position with average Rotation'

    PROP_CONVERT_COL_TO_OBJ_CALC_CENTER_USE_SCALE_LABEL = 'Use average Scale'
    PROP_CONVERT_COL_TO_OBJ_CALC_CENTER_USE_SCALE_DESC = 'Calculate Center Position with average Scale'

    PROP_CONVERT_COL_TO_OBJ_OBJECTS_CENTER_DEFAULT_LABEL = "By Default Position"
    PROP_CONVERT_COL_TO_OBJ_OBJECTS_CENTER_DEFAULT_DESC = "Calculate Center by Default Position"

    PROP_CONVERT_COL_TO_OBJ_OBJECTS_CENTER_LABEL = "By Objects"
    PROP_CONVERT_COL_TO_OBJ_OBJECTS_CENTER_DESC = "Calculate Center by child Objects"

    PROP_CONVERT_COL_TO_OBJ_OBJECTS_NESTED_CENTER_LABEL = "By Nested Objects"
    PROP_CONVERT_COL_TO_OBJ_OBJECTS_NESTED_CENTER_DESC = "Calculate Center by all Nested child Objects"

    PROP_CONVERT_COL_TO_OBJ_ZERO_POINT_LABEL = "Zero Point"
    PROP_CONVERT_COL_TO_OBJ_ZERO_POINT_DESC = "Move Parent object to zero coordinate position"

    PROP_CONVERT_COL_TO_OBJ_CURSOR_3D_LABEL = "Cursor 3D"
    PROP_CONVERT_COL_TO_OBJ_CURSOR_3D_DESC = "Move Parent object to Cursor 3D position"

    PROP_CONVERT_COL_TO_OBJ_SELECT_ALL_DESC = "Select all Objects after conversion"

    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_LABEL = 'Skip Empty Objects'
    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_DESC = 'Skip Empty Objects Mode'

    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_AUTO_LABEL = 'Auto'
    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_AUTO_DESC = 'Skip Empty Parent Objects by calculated Collection Center'

    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_SKIP_ALL_LABEL = 'Skip All'
    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_SKIP_ALL_DESC = 'Skip all Empty Parent Objects'

    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_LOAD_ALL_LABEL = 'Load All'
    PROP_CONVERT_OBJ_TO_COL_SKIP_EMPTIES_LOAD_ALL_DESC = 'Load all Empty Parent Objects'

    PROP_COLLECTION_LIST_MODE_LABEL = 'Collection List Mode'
    PROP_COLLECTION_LIST_MODE_DESC = 'Collection List display Mode'

    PANEL_HELP_LABEL = "Help"
    PANEL_OBJECT_MODE_LABEL = "To use Zen Sets enter Edit mode."

    PANEL_HELP_DOC_LABEL = "Documentation"
    PANEL_HELP_DOC_LINK = "https://zen-masters.github.io/Zen-Sets/"

    PANEL_HELP_DISCORD_LABEL = "Discord"
    PANEL_HELP_DISCORD_LINK = "https://discordapp.com/invite/wGpFeME"
    PANEL_HELP_DISCORD_ICO = "Discord-Logo-White_32"

    # Groups =======================================================
    PT_SEAMS_GROUP_LABEL = "Seam Groups"
    OT_NEW_ITEM_LABEL = "Add new Group"
    OT_NEW_ITEM_DESC = "Add new Group to List"
    OT_DEL_ITEM_LABEL = "Delete Group"
    OT_DEL_ITEM_DESC = "Delete selected Group from List"
    OT_MOVE_ITEM_LABEL = "Move"
    OT_MOVE_ITEM_DESC = "Move Group in List"
    OT_ASSIGN_ITEM_LABEL = "Assign"
    OT_ASSIGN_ITEM_DESC = "Assign selected Elements to selected Group, deleting any existing assignments"

    OT_ASSIGN_ITEM_PINNED_LABEL = "Assign To Pinned"
    OT_ASSIGN_ITEM_PINNED_DESC = "Assign selected Elements to pinned Group, deleting any existing assignments"

    OT_ASSIGN_UV_BORDERS_LABEL = "Assign UV Borders"
    OT_ASSIGN_UV_BORDERS_DESC = "Assign UV Borders to selected Edge Group"

    OT_APPEND_ITEM_LABEL = "Append"
    OT_APPEND_ITEM_DESC = "Append selected Elements to selected Group"
    OT_APPEND_ITEM_OBJ_DESC = "Append (Move|Link) selected Elements to selected Group"
    OT_REMOVE_SEL_ITEM_LABEL = "Remove"
    OT_REMOVE_SEL_ITEM_DESC = "Remove selected Elements from selected Group"
    OT_REMOVE_SEL_ITEM_OBJ_DESC = "Remove (Unlink) selected Elements from selected Group"
    OT_REMOVE_SEL_ITEM_OBJ_ALL_DESC = "Remove (Unlink) selected Elements from all Groups"
    OT_SELECT_ITEM_LABEL = "Select Add"
    OT_SELECT_ITEM_DESC = "Append selected Group Elements to viewport selection"
    OT_DESELECT_ITEM_LABEL = "Deselect"
    OT_DESELECT_ITEM_DESC = "Remove selected Group Elements from viewport selection"
    OT_INTERSECT_ITEM_LABEL = "Intersect"
    OT_INTERSECT_ITEM_DESC = "Select Group Elements intersected with viewport selection"
    OT_SIBLINGS_ITEM_LABEL = "Smart Select"
    OT_SIBLINGS_ITEM_DESC = "Select Group by selected Elements in Viewport"
    OT_DELETE_EMPTY_GROUP_LABEL = "Delete empty Groups"
    OT_DELETE_EMPTY_GROUP_DESC = "Delete empty Groups"
    OT_DELETE_UNLINK_EMPTY_GROUP_DESC = "Delete (Unlink) empty Groups"

    OT_DELETE_GROUPS_COMBO_LABEL = "Delete Groups"
    OT_DELETE_GROUPS_COMBO_DESC = "Delete All Groups or Empty Groups"
    OT_DELETE_UNLINK_GROUPS_COMBO_DESC = "Delete (Unlink) All Groups or Empty Groups"

    OT_DELETE_ALL_GROUPS_LABEL = "Delete all Groups"
    OT_DELETE_ALL_GROUPS_DESC = "Delete all Groups"
    OT_DELETE_UNLINK_ALL_GROUPS_DESC = "Delete (Unlink) all Groups"
    OT_HIDE_GROUP_LABEL = "Hide Group"
    OT_HIDE_GROUP_DESC = "Hide active Group"
    OT_UNHIDE_GROUP_LABEL = "Unhide Group"
    OT_UNHIDE_GROUP_DESC = "Unhide active Group"
    OT_INVERT_HIDE_GROUP_LABEL = "Isolate|Restore Group"
    OT_INVERT_HIDE_GROUP_DESC = "Isolate|Restore active Group"
    OT_MARK_SEAMS_IN_GROUP_LABEL = "Mark Seams"
    OT_MARK_SEAMS_IN_GROUP_DESK = "Mark Seams in selected Group"
    OT_CLEAR_SEAMS_IN_GROUP_LABEL = "Clear Seams"
    OT_CLEAR_SEAMS_IN_GROUP_DESK = "Clear Seams in selected Group"

    OT_GROUP_LINKED_LABEL = "Auto Groups"
    OT_GROUP_LINKED_DESK = "Make Groups from linked faces"

    OT_SPLIT_TO_OBJ_LABEL = "Create Objects from Groups"
    OT_SPLIT_TO_OBJ_DESK = "Create Objects from Groups"

    OT_RENAME_GROUPS_LABEL = "Batch Rename Groups"
    OT_RENAME_GROUPS_DESC = "If 'what' is empty, text will be completely replaced with 'replace' value"

    OT_SPLIT_GROUP_EDGES_LABEL = "Split Group edges"
    OT_SPLIT_GROUP_EDGES_DESC = "Split Group edges"

    OT_GLOBAL_CLEANUP_LABEL = "Global Cleanup"
    OT_GLOBAL_CLEANUP_DESC = "Delete all existing Sets and Parts"

    OT_OBJECT_CLEANUP_LABEL = "Object Cleanup"
    OT_OBJECT_CLEANUP_DESC = "Object Cleanup: Deletes all sets and parts in an object"

    OT_SELECT_OBJS_IN_GROUPS_LABEL = 'Select all objects by Group ID'
    OT_SELECT_OBJS_IN_GROUPS_DESC = 'Select all objects that has current Group elements'

    OT_SELECT_OBJS_WITH_IN_GROUPS_LABEL = 'Select all objects with'
    OT_SELECT_OBJS_WITH_IN_GROUPS_DESC = 'Select all objects that contain mode elements in current Group'

    OT_SORT_COLLECTIONS_LABEL = 'Sort Collection Children'
    OT_SORT_COLLECTIONS_DESC = 'Sort Active Layer Collection children'

    """ Import-export groups """
    OT_IMPORT_ALL_VERTEX_GROUPS_LABEL = "Import all Vertex Groups"
    OT_IMPORT_ALL_VERTEX_GROUPS_DESC = "Import all Vertex Groups to Zen Sets"
    OT_IMPORT_ACT_VERTEX_GROUP_LABEL = "Import active Vertex Group"
    OT_IMPORT_ACT_VERTEX_GROUP_DESC = "Import active Vertex Group to Zen Set"
    OT_EXPORT_ALL_TO_VERTEX_GROUPS_LABEL = "Export all to Vertex Groups"
    OT_EXPORT_ALL_TO_VERTEX_GROUPS_DESC = "Export all Zen Sets to Vertex Groups"
    OT_EXPORT_ACT_TO_VERTEX_GROUP_LABEL = "Export active Group to Vertex Group"
    OT_EXPORT_ACT_TO_VERTEX_GROUP_DESC = "Export active Zen Set to Vertex Group"

    OT_EXPORT_GROUP_TO_VERT_COL_LABEL = "Export Groups to Vertex Colors"
    OT_EXPORT_GROUP_TO_VERT_COL_DESC = "Export Zen Sets Groups to Vertex Colors"

    OT_IMPORT_VERT_COL_TO_GROUP_LABEL = "Import Vertex Colors"
    OT_IMPORT_VERT_COL_TO_GROUP_DESC = "Import Vertex Colors to Zen Sets"

    OT_COPY_TO_CLIPBOARD_LABEL = "Copy Group(s) to Clipboard"
    OT_COPY_TO_CLIPBOARD_DESC = "Copy Group(s) to Clipboard JSON Text\n(Supports only current editable objects)"

    OT_PASTE_FROM_CLIPBOARD_LABEL = "Paste Group(s) from Clipboard"
    OT_PASTE_FROM_CLIPBOARD_DESC = "Paste Group(s) from Clipboard JSON Text\n(Supports only current editable objects)"

    """ Import-export Face Maps """
    OT_IMPORT_ALL_FACE_MAPS_LABEL = "Import all Face Maps"
    OT_IMPORT_ALL_FACE_MAPS_DESC = "Import all Face Maps to Zen Sets"
    OT_IMPORT_ACT_FACE_MAP_LABEL = "Import active Face Map"
    OT_IMPORT_ACT_FACE_MAP_DESC = "Import active Face Map to Zen Set"
    OT_EXPORT_ALL_TO_FACE_MAPS_LABEL = "Export all to Face Maps"
    OT_EXPORT_ALL_TO_FACE_MAPS_DESC = "Export all Zen Sets to Face Maps"
    OT_EXPORT_ACT_TO_FACE_MAP_LABEL = "Export active Group to Face Map"
    OT_EXPORT_ACT_TO_FACE_MAP_DESC = "Export active Zen Set to Face Map"

    OT_ASSIGN_MATERIAL_TO_GROUP_LABEL = "Assign materials to Groups"
    OT_ASSIGN_MATERIAL_TO_GROUP_DESC = "Assign materials to Groups"

    OT_SELECT_ACTIVE_ITEM_LABEL = "Select Only"
    OT_SELECT_ACTIVE_ITEM_DESC = "Select Elements of selected Group"

    OT_SELECT_GROUP_LABEL = "Select"
    OT_SELECT_GROUP_DESC = "Select Elements of selected Group"

    OT_SELECT_UNGROUPPED_LABEL = "Select Ungrouped"
    OT_SELECT_UNGROUPPED_DESC = "Select Elements that do not belong to any Group"

    OT_SELECT_ITEM_MSG = "Select one of Group Elements"

    OT_WARN_NOTHING_SELECTED = "Select at least one Group"

    OT_DRAW_HIGHLIGHT_LABEL = "Display"
    OT_DRAW_UNHIGHLIGHT_LABEL = "Unhighlight Group"
    OT_DRAW_HIGHLIGHT_DESCRIPTION = "Display Groups in Viewport"

    OT_CONVERT_COL_TO_PARENT_LABEL = 'Collection to Parent Object'
    OT_CONVERT_COL_TO_PARENT_DESC = 'Convert Collection to empty parent object'
    OT_CONVERT_PARENT_TO_COL_LABEL = 'Parent Object To Collection'
    OT_CONVERT_PARENT_TO_COL_DESC = 'Convert Parent Object to Collection and link all its child objects'

    # Palette
    OT_PALETTE_SELECT_COLOR_DESC = 'Select this color'

    OT_PALETTE_ADD_NEW_PALETTE_LABEL = "Add New Palette"
    OT_PALETTE_ADD_NEW_PALETTE_DESC = "Adds New Palette and sets as Active"

    OT_PALETTE_COLOR_ADD_LABEL = "Palette Color Add"
    OT_PALETTE_COLOR_ADD_DESC = "Adds color to active Palette"

    OT_PALETTE_COLOR_REMOVE_LABEL = "Palette Color Remove"
    OT_PALETTE_COLOR_REMOVE_DESC = "Removes active color from the active Palette"

    OT_PALETTE_COLOR_MOVE_LABEL = "Palette Color Move"
    OT_PALETTE_COLOR_MOVE_DESC = "Moves active color up|down in the active Palette"

    OT_PALETTE_COLOR_SORT_LABEL = "Palette Color Sort"
    OT_PALETTE_COLOR_SORT_DESC = 'Sort Palette Colors By: Hue, Saturation, Value, Luminance'

    OT_PALETTE_ASSIGN_COLOR_TO_GROUP_LABEL = "Assign Color from Palette"
    OT_PALETTE_ASSIGN_COLOR_TO_GROUP_DESC = 'Assign Palette Color to active or all Group(s)'

    OT_PALETTE_ASSIGN_COLOR_FROM_WEIGHT_LABEL = "Assign Color from Weight"
    OT_PALETTE_ASSIGN_COLOR_FROM_WEIGHT_DESC = 'Assign Color from average Vertex Weight of Group to active or all Group(s)'

    OT_PALETTE_EXPORT_GROUP_COLORS_LABEL = 'Export Group Colors to Palette'
    OT_PALETTE_EXPORT_GROUP_COLORS_DESC = 'Export Group Colors to active or new Palette'

    # Objects
    OT_EXCLUDE_FROM_VIEWLAYER_LABEL = 'Exclude from ViewLayer'
    OT_EXCLUDE_TOGGLE_LABEL = 'Exclude | Include Group'
    OT_EXCLUDE_TOGGLE_DESC = 'Exclude | Include active Group'

    # Tools
    TOOL_LABEL = 'Zen Sets Tool'
    TOOL_DESCRIPTION = 'Zen Sets Tool'

    OT_TOOL_GROUP_SELECTOR = 'Group Selector'
    OT_TOOL_GROUP_DESCRIPTION = 'Select active group by Wheel'

    OT_TOOL_SHOW_HIDE_GROUP_LABEL = 'Show-Hide Groups'
    OT_TOOL_SHOW_HIDE_GROUP_DESC = 'Show Group if click on mesh, Show All if click outside, Hide if anything is already hidden'

    OT_TOOL_SMART_SELECT_LABEL = 'Tool Smart Select'
    OT_TOOL_SMART_SELECT_DESC = 'Smart Select in Tool Mode'

    PANEL_PREFERENCES_LABEL = "Preferences"

    PANEL_EDGES_LABEL = "Edge Groups"
    PANEL_SEAMS_LABEL = "Seam Groups"
    PANEL_FACES_LABEL = "Face Groups"
    PANEL_VERTS_LABEL = "Vert Groups"
    PANEL_PARTS_LABEL = "Parts"

    PREF_ZEN_UV_URL_DESC = "Zen UV: Optimize UV mapping workflow"
    PREF_ZEN_UV_URL_LINK = 'https://gumroad.com/l/ZenUV'

    PREF_ZEN_UV_BBQ_URL_DESC = "Zen BBQ: Build Bevels Quickly!"
    PREF_ZEN_UV_BBQ_URL_LINK = 'https://gumroad.com/l/ZenBBQ'

    PREF_ZEN_UV_CHECKER_URL_DESC = "Checker: Check the state of UVs (FREE)"
    PREF_ZEN_UV_CHECKER_URL_LINK = 'https://gumroad.com/l/zenuv_checker'

    PREF_ZEN_UV_TOPMOST_URL_DESC = "Console Top Most: Make the System Console to the TOPMOST window"
    PREF_ZEN_UV_TOPMOST_URL_LINK = 'https://gumroad.com/l/ZenConsoleTopMost'

    # Reset Zen Sets Preferences ==========================================
    RESET_LABEL = "Reset Preferences"
    RESET_DESC = "Reset preferences to Default state"
    RESET_MES = "Confirm: Reset Zen Sets preferences to Default state?"


if __name__ == '__main__':
    pass
