# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

import bpy


# Lower Case Only !
zen_sets_manual_map = (
    ('bpy.ops.zst*.append_to_group*', 'npanel/#append'),
    ('bpy.ops.zst*.remove_from_group*', 'npanel/#remove'),
    # Group To Selection
    ('bpy.ops.zst*.select_group*', 'npanel/#select'),
    ('bpy.ops.zst*.deselect_group*', 'npanel/#deselect'),
    ('bpy.ops.zst*.intersect_group*', 'npanel/#intersect'),
    ('bpy.ops.zst*.smart_select*', 'npanel/#smart-select'),
    ('bpy.ops.zst*.select_ungroupped*', 'npanel/#select-ungrouped'),
    # Display Group
    ('bpy.ops.zst*.hide_group*', 'npanel/#hide'),
    ('bpy.ops.zst*.unhide_group*', 'npanel/#unhide'),
    ('bpy.ops.zst*.invert_hide_group*', 'npanel/#isolate'),
    ('bpy.ops.zsts.draw_highlight*', 'npanel/#display'),
    ('bpy.ops.zst*.smart_isolate*', 'npanel/#smart-isolate'),
    # Import-Export
    ('bpy.ops.zsts.copy_to_clipboard*', 'imp_exp/#copy-to-clipboard'),
    ('bpy.ops.zsts.paste_from_clipboard*', 'imp_exp/#paste-from-clipboard'),

    ('bpy.ops.zsts.import_vertex_colors_to_groups*', 'imp_exp/#import-export-blender-vertex-colors'),
    ('bpy.ops.zsts.export_groups_to_vertex_colors*', 'imp_exp/#import-export-blender-vertex-colors'),

    ('bpy.ops.zen_face*list.export_all_to_face_maps*', 'imp_exp/#import-export-blender-face-maps'),
    ('bpy.ops.zen_face*list.export_active_to_face_map*', 'imp_exp/#import-export-blender-face-maps'),
    ('bpy.ops.zen_face*list.import_all_face_maps*', 'imp_exp/#import-export-blender-face-maps'),
    ('bpy.ops.zen_face*list.import_active_face_map*', 'imp_exp/#import-export-blender-face-maps'),

    ('bpy.ops.zen_vert*list.export_all_to_vertex_groups*', 'imp_exp/#import-export-blender-vertex-groups'),
    ('bpy.ops.zen_vert*list.export_active_to_vertex_group*', 'imp_exp/#import-export-blender-vertex-groups'),
    ('bpy.ops.zen_vert*list.import_all_vertex_groups*', 'imp_exp/#import-export-blender-vertex-groups'),
    ('bpy.ops.zen_vert*list.import_active_vertex_group*', 'imp_exp/#import-export-blender-vertex-groups'),
    # Tools
    ('bpy.ops.zsts.group_linked*', 'tools/#auto-groups'),
    ('bpy.ops.zsts.split_to_objects*', 'tools/#create-objects-from-groups'),
    ('bpy.ops.zen_*list.assign_materials_to_groups*', 'tools/#assign-materials-to-groups'),
    ('bpy.ops.zen_edge*list,split_group_edges*', 'tools/#split-group-edges'),
    ('bpy.ops.zsts.mark_seams*', 'tools/#mark-and-clear-seams'),
    ('bpy.ops.zsts.clear_seams*', 'tools/#mark-and-clear-seams'),
    ('bpy.ops.zsts.assign_to_pinned_group*', 'tools/#assign-to-pinned-group'),
    ('bpy.ops.zsts.assign_uv_borders_to_group*', 'tools/#assign-uv-borders-to-group'),

    ('bpy.ops.mesh.zsts_set_sculpt_mask*', 'tools/#set-sculpt-mask'),

    ('bpy.ops.zsts.remove_weight_from_group*', 'tools/#remove-weight'),
    ('bpy.ops.zsts.internal_change_weight_by_index*', 'tools/#change-weight-in-selected-group'),

    ('bpy.ops.zsts.rename_groups*', 'tools/#batch-rename-groups'),
    ('bpy.ops.zsto.duplicate_collection*', 'tools/#duplicate-collection'),
    ('bpy.ops.zsto.duplicate_as_intance*', 'tools/#duplicate-as-instance'),
    ('bpy.ops.zsto.convert_object_to_collection*', 'tools/#convert-parent-object-to-collection'),
    ('bpy.ops.zsto.convert_collection_to_object*', 'tools/#convert-collection-to-parent-object'),
    ('bpy.ops.object.zsto_sort_collections*', 'tools/#sort-collections'),
    ('bpy.ops.zsto.remove_linked_objects*', 'tools/#remove-linked'),
    # Sidebar
    ('bpy.ops.zst*.new_group*', 'npanel/#add-new-group'),
    ('bpy.ops.zst*.del_group*', 'npanel/#delete-active-group'),
    ('bpy.ops.zsts.move_group*', 'npanel/#move-active-group-up'),
    ('bpy.ops.zst*.delete_all_groups*', 'npanel/#delete-groups'),
    ('bpy.ops.zst*.delete_empty_groups*', 'npanel/#delete-groups'),
    ('bpy.ops.zst*.delete_groups_combo*', 'npanel/#delete-groups'),
    # Workspacetool
    ('bpy.ops.zsto.internal_select_objects_by_index*', 'workspacetool/#collection-toolbar'),
    ('bpy.ops.zsto.exclude_group_by_index*', 'workspacetool/#collection-toolbar'),
    ('bpy.ops.zsto.hide_viewport_by_index*', 'workspacetool/#collection-toolbar'),
    ('bpy.ops.zsto.hide_select_by_index*', 'workspacetool/#collection-toolbar'),
    ('bpy.ops.zsto.disable_viewport_by_index*', 'workspacetool/#collection-toolbar'),

    ('bpy.ops.zst*.internal_hide_group_by_index*', 'group_operators/#hide-in-viewport'),
    ('bpy.ops.zst*.hide_render_by_index*', 'group_operators/#disable-in-renders'),

    # Palette
    ('bpy.ops.zsts.palette*', 'npanel/#palette-panel'),

    # Properties
    ('bpy.types.scene.zen_sets_active_mode*', 'npanel/#active-zen-sets-element-switch'),
    ('bpy.types.scene.zen_sets_element_mode*', 'npanel/#active-zen-sets-element-switch'),
    ('bpy.types.scene.zen_sets_unique_mode*', 'npanel/#active-zen-sets-mode-switch'),

    # Group List
    ('bpy.types.zs*listgroup.group_color', 'npanel/#groups-list'),
    ('bpy.types.scene.zen_*_list_index', 'npanel/#groups-list'),

    ('bpy.types.ZsColorPaletteGroup.*'.lower(), 'npanel/#palette-panel'),
)


def zen_sets_addon_docs():
    return "https://zen-masters.github.io/Zen-Sets/", zen_sets_manual_map


def register():
    bpy.utils.register_manual_map(zen_sets_addon_docs)


def unregister():
    bpy.utils.unregister_manual_map(zen_sets_addon_docs)
