# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

import math
import random

from mathutils import Color


class ColorConstants:

    aliceblue = Color((0.94, 0.97, 1))  # Alice blue color.

    antiquewhite = Color((0.98, 0.92, 0.84))  # Antique white color.

    aqua = Color((0, 1, 1))  # Aqua color.

    aquamarine = Color((0.5, 1, 0.83))  # Aquamarine color.

    azure = Color((0.94, 1, 1))  # Azure color.

    beige = Color((0.96, 0.96, 0.86))  # Beige color.

    bisque = Color((1, 0.89, 0.77))  # Bisque color.

    black = Color((0, 0, 0))  # Black color.

    blanchedalmond = Color((1, 0.92, 0.8))  # Blanche almond color.

    blue = Color((0, 0, 1))  # Blue color.

    blueviolet = Color((0.54, 0.17, 0.89))  # Blue violet color.

    brown = Color((0.65, 0.16, 0.16))  # Brown color.

    burlywood = Color((0.87, 0.72, 0.53))  # Burly wood color.

    cadetblue = Color((0.37, 0.62, 0.63))  # Cadet blue color.

    chartreuse = Color((0.5, 1, 0))  # Chartreuse color.

    chocolate = Color((0.82, 0.41, 0.12))  # Chocolate color.

    coral = Color((1, 0.5, 0.31))  # Coral color.

    cornflower = Color((0.39, 0.58, 0.93))  # Cornflower color.

    cornsilk = Color((1, 0.97, 0.86))  # Corn silk color.

    crimson = Color((0.86, 0.08, 0.24))  # Crimson color.

    cyan = Color((0, 1, 1))  # Cyan color.

    darkblue = Color((0, 0, 0.55))  # Dark blue color.

    darkcyan = Color((0, 0.55, 0.55))  # Dark cyan color.

    darkgoldenrod = Color((0.72, 0.53, 0.04))  # Dark goldenrod color.

    darkgray = Color((0.66, 0.66, 0.66))  # Dark gray color.

    darkgreen = Color((0, 0.39, 0))  # Dark green color.

    darkkhaki = Color((0.74, 0.72, 0.42))  # Dark khaki color.

    darkmagenta = Color((0.55, 0, 0.55))  # Dark magenta color.

    darkolivegreen = Color((0.33, 0.42, 0.18))  # Dark olive green color.

    darkorange = Color((1, 0.55, 0))  # Dark orange color.

    darkorchid = Color((0.6, 0.2, 0.8))  # Dark orchid color.

    darkred = Color((0.55, 0, 0))  # Dark red color.

    darksalmon = Color((0.91, 0.59, 0.48))  # Dark salmon color.

    darkseagreen = Color((0.56, 0.74, 0.56))  # Dark sea green color.

    darkslateblue = Color((0.28, 0.24, 0.55))  # Dark slate blue color.

    darkslategray = Color((0.18, 0.31, 0.31))  # Dark slate gray color.

    darkturquoise = Color((0, 0.81, 0.82))  # Dark turquoise color.

    darkviolet = Color((0.58, 0, 0.83))  # Dark violet color.

    deeppink = Color((1, 0.08, 0.58))  # Deep pink color.

    deepskyblue = Color((0, 0.75, 1))  # Deep sky blue color.

    dimgray = Color((0.41, 0.41, 0.41))  # Dim gray color.

    dodgerblue = Color((0.12, 0.56, 1))  # Dodger blue color.

    firebrick = Color((0.7, 0.13, 0.13))  # Firebrick color.

    floralwhite = Color((1, 0.98, 0.94))  # Floral white color.

    forestgreen = Color((0.13, 0.55, 0.13))  # Forest green color.

    fuchsia = Color((1, 0, 1))  # Fuchsia color.

    gainsboro = Color((0.86, 0.86, 0.86))  # Gainsboro color.

    ghostwhite = Color((0.97, 0.97, 1))  # Ghost white color.

    gold = Color((1, 0.84, 0))  # Gold color.

    goldenrod = Color((0.85, 0.65, 0.13))  # Goldenrod color.

    gray = Color((0.75, 0.75, 0.75))  # Gray color.

    green = Color((0, 1, 0))  # Green color.

    greenyellow = Color((0.68, 1, 0.18))  # Green yellow color.

    honeydew = Color((0.94, 1, 0.94))  # Honeydew color.

    hotpink = Color((1, 0.41, 0.71))  # Hot pink color.

    indianred = Color((0.8, 0.36, 0.36))  # Indian red color.

    indigo = Color((0.29, 0, 0.51))  # Indigo color.

    ivory = Color((1, 1, 0.94))  # Ivory color.

    khaki = Color((0.94, 0.9, 0.55))  # Khaki color.

    lavender = Color((0.9, 0.9, 0.98))  # Lavender color.

    lavenderblush = Color((1, 0.94, 0.96))  # Lavender blush color.

    lawngreen = Color((0.49, 0.99, 0))  # Lawn green color.

    lemonchiffon = Color((1, 0.98, 0.8))  # Lemon chiffon color.

    lightblue = Color((0.68, 0.85, 0.9))  # Light blue color.

    lightcoral = Color((0.94, 0.5, 0.5))  # Light coral color.

    lightcyan = Color((0.88, 1, 1))  # Light cyan color.

    lightgoldenrod = Color((0.98, 0.98, 0.82))  # Light goldenrod color.

    lightgray = Color((0.83, 0.83, 0.83))  # Light gray color.

    lightgreen = Color((0.56, 0.93, 0.56))  # Light green color.

    lightpink = Color((1, 0.71, 0.76))  # Light pink color.

    lightsalmon = Color((1, 0.63, 0.48))  # Light salmon color.

    lightseagreen = Color((0.13, 0.7, 0.67))  # Light sea green color.

    lightskyblue = Color((0.53, 0.81, 0.98))  # Light sky blue color.

    lightslategray = Color((0.47, 0.53, 0.6))  # Light slate gray color.

    lightsteelblue = Color((0.69, 0.77, 0.87))  # Light steel blue color.

    lightyellow = Color((1, 1, 0.88))  # Light yellow color.

    lime = Color((0, 1, 0))  # Lime color.

    limegreen = Color((0.2, 0.8, 0.2))  # Lime green color.

    linen = Color((0.98, 0.94, 0.9))  # Linen color.

    magenta = Color((1, 0, 1))  # Magenta color.

    maroon = Color((0.69, 0.19, 0.38))  # Maroon color.

    mediumaquamarine = Color((0.4, 0.8, 0.67))  # Medium aquamarine color.

    mediumblue = Color((0, 0, 0.8))  # Medium blue color.

    mediumorchid = Color((0.73, 0.33, 0.83))  # Medium orchid color.

    mediumpurple = Color((0.58, 0.44, 0.86))  # Medium purple color.

    mediumseagreen = Color((0.24, 0.7, 0.44))  # Medium sea green color.

    mediumslateblue = Color((0.48, 0.41, 0.93))  # Medium slate blue color.

    mediumspringgreen = Color((0, 0.98, 0.6))  # Medium spring green color.

    mediumturquoise = Color((0.28, 0.82, 0.8))  # Medium turquoise color.

    mediumvioletred = Color((0.78, 0.08, 0.52))  # Medium violet red color.

    midnightblue = Color((0.1, 0.1, 0.44))  # Midnight blue color.

    mintcream = Color((0.96, 1, 0.98))  # Mint cream color.

    mistyrose = Color((1, 0.89, 0.88))  # Misty rose color.

    moccasin = Color((1, 0.89, 0.71))  # Moccasin color.

    navajowhite = Color((1, 0.87, 0.68))  # Navajo white color.

    navyblue = Color((0, 0, 0.5))  # Navy blue color.

    oldlace = Color((0.99, 0.96, 0.9))  # Old lace color.

    olive = Color((0.5, 0.5, 0))  # Olive color.

    olivedrab = Color((0.42, 0.56, 0.14))  # Olive drab color.

    orange = Color((1, 0.65, 0))  # Orange color.

    orangered = Color((1, 0.27, 0))  # Orange red color.

    orchid = Color((0.85, 0.44, 0.84))  # Orchid color.

    palegoldenrod = Color((0.93, 0.91, 0.67))  # Pale goldenrod color.

    palegreen = Color((0.6, 0.98, 0.6))  # Pale green color.

    paleturquoise = Color((0.69, 0.93, 0.93))  # Pale turquoise color.

    palevioletred = Color((0.86, 0.44, 0.58))  # Pale violet red color.

    papayawhip = Color((1, 0.94, 0.84))  # Papaya whip color.

    peachpuff = Color((1, 0.85, 0.73))  # Peach puff color.

    peru = Color((0.8, 0.52, 0.25))  # Peru color.

    pink = Color((1, 0.75, 0.8))  # Pink color.

    plum = Color((0.87, 0.63, 0.87))  # Plum color.

    powderblue = Color((0.69, 0.88, 0.9))  # Powder blue color.

    purple = Color((0.63, 0.13, 0.94))  # Purple color.

    rebeccapurple = Color((0.4, 0.2, 0.6))  # Rebecca purple color.

    red = Color((1, 0, 0))  # Red color.

    rosybrown = Color((0.74, 0.56, 0.56))  # Rosy brown color.

    royalblue = Color((0.25, 0.41, 0.88))  # Royal blue color.

    saddlebrown = Color((0.55, 0.27, 0.07))  # Saddle brown color.

    salmon = Color((0.98, 0.5, 0.45))  # Salmon color.

    sandybrown = Color((0.96, 0.64, 0.38))  # Sandy brown color.

    seagreen = Color((0.18, 0.55, 0.34))  # Sea green color.

    seashell = Color((1, 0.96, 0.93))  # Seashell color.

    sienna = Color((0.63, 0.32, 0.18))  # Sienna color.

    silver = Color((0.75, 0.75, 0.75))  # Silver color.

    skyblue = Color((0.53, 0.81, 0.92))  # Sky blue color.

    slateblue = Color((0.42, 0.35, 0.8))  # Slate blue color.

    slategray = Color((0.44, 0.5, 0.56))  # Slate gray color.

    snow = Color((1, 0.98, 0.98))  # Snow color.

    springgreen = Color((0, 1, 0.5))  # Spring green color.

    steelblue = Color((0.27, 0.51, 0.71))  # Steel blue color.

    tan = Color((0.82, 0.71, 0.55))  # Tan color.

    teal = Color((0, 0.5, 0.5))  # Teal color.

    thistle = Color((0.85, 0.75, 0.85))  # Thistle color.

    tomato = Color((1, 0.39, 0.28))  # Tomato color.

    turquoise = Color((0.25, 0.88, 0.82))  # Turquoise color.

    violet = Color((0.93, 0.51, 0.93))  # Violet color.

    webgray = Color((0.5, 0.5, 0.5))  # Web gray color.

    webgreen = Color((0, 0.5, 0))  # Web green color.

    webmaroon = Color((0.5, 0, 0))  # Web maroon color.

    webpurple = Color((0.5, 0, 0.5))  # Web purple color.

    wheat = Color((0.96, 0.87, 0.7))  # Wheat color.

    white = Color((1, 1, 1))  # White color.

    whitesmoke = Color((0.96, 0.96, 0.96))  # White smoke color.

    yellow = Color((1, 1, 0))  # Yellow color.

    yellowgreen = Color((0.6, 0.8, 0.2))  # Yellow green color.


_rnd = random.Random()


class ColorUtils:

    @classmethod
    def gen_new_color(self, p_items, attr):

        def is_color_present(p_items, p_hue):
            i_count = 0
            for v in reversed(p_items):

                # five items - because of 1 / -0.05 +0.05
                if i_count > 5:
                    break

                f_hue = getattr(v, attr).h
                f_diff = math.fabs(p_hue - f_hue)

                i_count += 1
                f_template_diff = 0.1

                if f_diff < f_template_diff:
                    return True
            return False

        c = Color()
        hue = _rnd.random()
        i_limit = 0
        while is_color_present(p_items, hue) and i_limit < 40:
            hue -= 0.025
            if hue < 0:
                hue += 1.0
            i_limit = i_limit + 1

        c.hsv = hue, 0.7, 0.8
        return c


CONST_GROUP_COLORS = [
    ColorConstants.aqua,
    ColorConstants.blue,
    ColorConstants.brown,
    ColorConstants.fuchsia,
    ColorConstants.gold,
    ColorConstants.lime,
    ColorConstants.teal,
    ColorConstants.maroon,
    ColorConstants.orange,
    ColorConstants.pink
]
