# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# blender
import bpy
# local
from ..labels import ZsLabels


def _on_update_prop(self, context, callback):
    s_prop_name = self.path_from_id()
    p_path_parts = s_prop_name.split('[')
    if len(p_path_parts) > 0:
        s_prop_name = p_path_parts[0]

    for obj in context.objects_in_mode:
        if hasattr(obj, s_prop_name):
            p_list = getattr(obj, s_prop_name)
            for item in p_list:
                if item.layer_name == self.layer_name:
                    callback(item, self)
                    break


def _on_update_name(self, context):
    def callback(item, self):
        if item.name != self.name:
            item.name = self.name
    _on_update_prop(self, context, callback)


def _on_update_color(self, context):
    def callback(item, self):
        if item.group_color != self.group_color:
            item.group_color = self.group_color

    _on_update_prop(self, context, callback)


def _get_prop_list_name(on_update):
    return bpy.props.StringProperty(
        name="Name",
        update=on_update
    )


def _get_prop_list_layer():
    return bpy.props.StringProperty(
        name="LayerName",
        description="",
        default=""
    )


def _get_prop_list_group_color(on_update):
    return bpy.props.FloatVectorProperty(
        name=ZsLabels.PROP_GROUP_COLOR_NAME,
        subtype='COLOR_GAMMA',
        size=3,
        default=(0.0, 0.5, 0.0),
        min=0, max=1,
        update=on_update
    )


def _on_update_group_hide_count(self, context):
    if context.area:
        context.area.tag_redraw()
    pass


class ZSTSObjectListGroup(bpy.types.PropertyGroup):
    """
    Group of properties representing
    an item in the zen sets groups for OBJECT
    """
    name: _get_prop_list_name(on_update=None)
    layer_name: _get_prop_list_layer()
    group_color: _get_prop_list_group_color(on_update=None)
    group_count: bpy.props.IntProperty(name="GroupCount")
    group_hide_count: bpy.props.IntProperty(name="GroupHiddenCount", update=_on_update_group_hide_count)


class ZSTSSceneListGroup(bpy.types.PropertyGroup):
    """
    Group of properties representing
    an item in the zen sets groups for SCENE
    """
    name: _get_prop_list_name(on_update=_on_update_name)
    layer_name: _get_prop_list_layer()
    group_color: _get_prop_list_group_color(on_update=_on_update_color)
