# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# blender
from ..blender_zen_utils import ZenModeSwitcher


def export_zen_group_to_vertex_group(p_cls_mgr, p_obj, p_group, select=False):
    bm = p_cls_mgr._get_bm(p_obj)
    v_group = p_obj.vertex_groups[p_group.name] \
        if p_group.name in p_obj.vertex_groups else p_obj.vertex_groups.new(name=p_group.name)
    t_verts = [v.index for v in p_cls_mgr.get_bm_layer_items(p_obj, bm, p_group.layer_name)]
    t_all_verts = [v.index for v in bm.verts]

    if select:
        for v in bm.verts:
            v.select = v.index in t_verts
        bm.select_flush_mode()

    mode_switcher = ZenModeSwitcher()
    # we must previously remove anything from group, because Blender always append
    v_group.remove(t_all_verts)
    v_group.add(t_verts, 1.0, 'REPLACE')
    mode_switcher.return_to_edit_mode()


def export_zen_group_to_vertex_color(p_cls_mgr, p_obj, p_group, generate_new_layer, s_prefix):
    bm = p_cls_mgr._get_bm(p_obj)

    p_vert_color_layer = None
    if generate_new_layer:
        s_layer = s_prefix + p_group.name
        p_vert_color_layer = bm.loops.layers.color.new(s_layer) if s_layer not in bm.loops.layers.color.keys() else bm.loops.layers.color.get(s_layer)
    else:
        p_vert_color_layer = bm.loops.layers.color.verify()

    b_is_vert = p_cls_mgr.id_element == 'vert'
    b_is_edge = p_cls_mgr.id_element == 'edge'

    bm_layer_items = p_cls_mgr.get_bm_layer_items(p_obj, bm, p_group.layer_name)
    for item in bm_layer_items:
        loops = item.link_loops if (b_is_vert or b_is_edge) else item.loops
        for loop in loops:
            loop[p_vert_color_layer] = (p_group.group_color.r, p_group.group_color.g, p_group.group_color.b, 1)
