# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

""" Zen Sets Factories """

import bpy

from .elements.vert_sets import ZSVG_Factory
from .elements.vert_unisets import ZSUVG_Factory
from .elements.edge_sets import ZSEG_Factory
from .elements.edge_unisets import ZSUEG_Factory
from .elements.face_sets import ZSFG_Factory
from .elements.face_unisets import ZSUFG_Factory

from .elements.bl_vgroup_sets import ZSBLVG_Factory
from .elements.bl_fmaps_unisets import ZSUFM_Factory

from .objects.collection_object_sets import ZSTO_Factory
from .objects.simple.simple_object_sets import ZSOS_Factory
from .objects.simple.simple_object_parts import ZSOP_Factory

sets_factories = (
    ZSVG_Factory,
    ZSUVG_Factory,
    ZSEG_Factory,
    ZSUEG_Factory,
    ZSFG_Factory,
    ZSUFG_Factory,

    ZSBLVG_Factory,
    ZSUFM_Factory
)

obj_collection_factories = [
    ZSTO_Factory,
    ZSOS_Factory,
    ZSOP_Factory
]

obj_simple_factories = [
    ZSOS_Factory,
    ZSOP_Factory
]

context_factories = {
    'EDIT_MESH': sets_factories,
    'OBJECT': obj_collection_factories
}


t_sets_lookup = None
t_objects_lookup = None


def get_sets_edit_mgr(p_scene):
    global t_sets_lookup
    if t_sets_lookup is None:
        t_sets_lookup = {f.get_mgr().id_group: f.get_mgr() for f in sets_factories}

    return t_sets_lookup.get(p_scene.zen_sets_active_mode, None)


def get_sets_object_mgr(p_scene):
    global t_objects_lookup
    if t_objects_lookup is None:
        t_objects_lookup = {f.get_mgr().id_group: f.get_mgr() for f in obj_collection_factories}

    return t_objects_lookup.get(p_scene.zen_object_collections_mode, None)


def get_sets_mgr(p_scene):
    if bpy.context.mode == 'EDIT_MESH':
        return get_sets_edit_mgr(p_scene)
    elif bpy.context.mode == 'OBJECT':
        return get_sets_object_mgr(p_scene)

    return None


def get_sets_mgr_by_id(id):
    if bpy.context.mode in context_factories:
        _factories = context_factories[bpy.context.mode]
        for f in _factories:
            p_cls_mgr = f.get_mgr()
            if p_cls_mgr.id_group == id:
                return p_cls_mgr
    return None


def get_sets_ids():
    if bpy.context.mode in context_factories:
        _factories = context_factories[bpy.context.mode]
        return tuple(f.get_mgr().id_group for f in _factories)

    return tuple()
