# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

from enum import IntEnum


_LOOKUP_TABLE = {}


class ZsLookup(IntEnum):
    MetaInfo = 0,
    Filter = 1,
    ExtraInfoIndex = 2,
    ExtraInfoLayer = 3,
    CurrentGroupPairs = 4,
    ObjectHighlightedGroups = 5,


def get_lookup_table(p_cls_mgr):
    mgr_id = p_cls_mgr.id_group

    global _LOOKUP_TABLE
    if mgr_id not in _LOOKUP_TABLE:
        _LOOKUP_TABLE[mgr_id] = {}

    return _LOOKUP_TABLE[mgr_id]


def get_lookup_table_check(p_cls_mgr, context):
    lookup_table = get_lookup_table(p_cls_mgr)

    if p_cls_mgr.is_lookup_table_valid(lookup_table, context) is False:
        p_cls_mgr.build_lookup_table(context)

    return lookup_table
