# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# Copyright 2021, Alex Zhornyak

# blender
import bpy

from .basic_pie import ZsBasicPieCaller, ZsBasicBottomCaller, ZsBasicTopCaller, get_command_props
from ...blender_zen_utils import draw_ex_last_operator_properties
from ...labels import ZsLabels


class ZSTS_OT_PieCallerLeft(ZsBasicPieCaller):
    bl_idname = "zsts.pie_caller_left"
    bl_label = "Deselect | Unhide"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def get_template_items(cls, context):
        return {
            'Default': 'zsts.deselect_group',
            'CTRL': 'zsts.unhide_group',
            'SHIFT': 'zsts.invert_hide_group("INVOKE_DEFAULT")',
            'CTRL+SHIFT': 'zsts.invert_hide_group(submode="UNHIDE_ALL")'
        }

    @classmethod
    def get_template_display_items(self, context):
        return {
            'Default': ZsLabels.OT_DESELECT_ITEM_LABEL,
            'CTRL': ZsLabels.OT_UNHIDE_GROUP_LABEL,
            'SHIFT': ZsLabels.OT_INVERT_HIDE_GROUP_LABEL,
            'CTRL+SHIFT': 'Unhide All'
        }

    @classmethod
    def description(cls, context, properties):
        return (
            'Default - ' + ZsLabels.OT_DESELECT_ITEM_DESC +
            '\nCTRL - ' + ZsLabels.OT_UNHIDE_GROUP_DESC +
            '\nSHIFT - ' + ZsLabels.OT_INVERT_HIDE_GROUP_DESC +
            '\nCTRL+SHIFT - Unhide All Groups')

    def draw(self, context):
        layout = self.layout

        op_props = get_command_props(self.cmd_enum)

        layout.label(text=f'{op_props.bl_label}')

        p_template_items = self.get_template_items(context)
        if self.cmd_enum in p_template_items.values():
            draw_ex_last_operator_properties(context, op_props.op_cmd_short, layout)

    cmd_enum: bpy.props.StringProperty(options={'HIDDEN', 'SKIP_SAVE'})
    is_menu: bpy.props.BoolProperty(default=True, options={'HIDDEN', 'SKIP_SAVE'})


class ZSTS_OT_PieCallerTopLeft(ZsBasicPieCaller):
    bl_idname = "zsts.pie_caller_top_left"
    bl_label = "Delete Group | Empty"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def get_template_items(cls, context):
        return {
            'Default': 'zsts.del_group',
            'CTRL': 'zsts.delete_empty_groups'
        }

    cmd_enum: bpy.props.StringProperty(options={'HIDDEN', 'SKIP_SAVE'})
    is_menu: bpy.props.BoolProperty(default=True, options={'HIDDEN', 'SKIP_SAVE'})


class ZSTS_OT_PieCallerRight(ZsBasicPieCaller):
    bl_idname = "zsts.pie_caller_right"
    bl_label = "Select | Hide"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def get_template_items(cls, context):
        return {
            'Default': 'zsts.select_group',
            'CTRL': 'zsts.hide_group',
            'CTRL+SHIFT': 'zsts.select_ungroupped'
        }

    def draw(self, context):
        layout = self.layout

        op_props = get_command_props(self.cmd_enum)

        layout.label(text=f'{op_props.bl_label}')

        if self.cmd_enum in {'zsts.select_group', 'zsts.hide_group'}:
            draw_ex_last_operator_properties(context, self.cmd_enum, layout)

    cmd_enum: bpy.props.StringProperty(options={'HIDDEN', 'SKIP_SAVE'})
    is_menu: bpy.props.BoolProperty(default=True, options={'HIDDEN', 'SKIP_SAVE'})


class ZSTS_OT_PieCallerBottomLeft(ZsBasicPieCaller):
    bl_idname = "zsts.pie_caller_bottom_left"
    bl_label = "Remove"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def get_template_items(cls, context):
        return {
            'Default': 'zsts.remove_from_group("INVOKE_DEFAULT", mode="ACTIVE")',
            'SHIFT': 'zsts.remove_from_group("INVOKE_DEFAULT", mode="ALL")',
        }

    @classmethod
    def get_template_display_items(self, context):
        return {
            'Default': 'Remove',
            'SHIFT': 'Remove from All Groups'
        }

    @classmethod
    def description(cls, context, properties):
        return (
            'Default - Remove selected Elements from Active Group' +
            '\nSHIFT - Remove selected Elements from All Groups')

    def draw(self, context):
        layout = self.layout

        p_label = self.get_template_display_name(context)
        if p_label:
            layout.label(text=p_label)

    cmd_enum: bpy.props.StringProperty(options={'HIDDEN', 'SKIP_SAVE'})
    is_menu: bpy.props.BoolProperty(default=True, options={'HIDDEN', 'SKIP_SAVE'})


class ZSTS_OT_PieCallerBottomRight(ZsBasicPieCaller):
    bl_idname = "zsts.pie_caller_bottom_right"
    bl_label = "Append"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def get_template_items(cls, context):
        return {
            'Default': 'zsts.append_to_group',
            'SHIFT': 'zsts.assign_to_group',
        }

    def draw(self, context):
        layout = self.layout

        op_props = get_command_props(self.cmd_enum)

        layout.label(text=f'{op_props.bl_label}')

        p_template_items = self.get_template_items(context)
        if self.cmd_enum in p_template_items.values():
            draw_ex_last_operator_properties(context, self.cmd_enum, layout)

    cmd_enum: bpy.props.StringProperty(options={'HIDDEN', 'SKIP_SAVE'})
    is_menu: bpy.props.BoolProperty(default=True, options={'HIDDEN', 'SKIP_SAVE'})


class ZSTS_OT_PieCallerBottom(ZsBasicBottomCaller):
    bl_idname = "zsts.pie_caller_bottom"

    cmd_enum: bpy.props.StringProperty(options={'HIDDEN', 'SKIP_SAVE'})
    is_menu: bpy.props.BoolProperty(default=True, options={'HIDDEN', 'SKIP_SAVE'})


class ZSTS_OT_PieCallerTop(ZsBasicTopCaller):
    bl_idname = "zsts.pie_caller_top"

    cmd_enum: bpy.props.StringProperty(options={'HIDDEN', 'SKIP_SAVE'})
    is_menu: bpy.props.BoolProperty(default=True, options={'HIDDEN', 'SKIP_SAVE'})
