# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# blender
import bpy

import functools


def get_last_selected_smart_group(self):
    from .factories import get_sets_mgr
    p_scene = bpy.context.scene
    p_cls_mgr = get_sets_mgr(p_scene)
    if p_cls_mgr:

        p_list = p_cls_mgr.get_list(p_scene)
        idx = p_cls_mgr._index_of_layer(p_list, p_scene.zen_sets_last_smart_layer)
        if idx in range(len(p_list)):
            return p_list[idx].name

    return ''


def _change_collection_name(value):
    from .factories import get_sets_mgr
    p_scene = bpy.context.scene
    p_cls_mgr = get_sets_mgr(p_scene)
    if p_cls_mgr:
        p_list = p_cls_mgr.get_list(p_scene)
        idx = p_cls_mgr._index_of_layer(p_list, p_scene.zen_sets_last_smart_layer)
        if idx in range(len(p_list)):
            p_list[idx].name = value


def set_last_selected_smart_group(self, value):
    # Use only through 'timers.register' to solve undo operator chain
    bpy.app.timers.register(
        functools.partial(_change_collection_name, value))
