# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####


def is_uv_seam(uv, next_uv, other_uv, other_next_uv):
    ''' takes 4 uvs as input, corresponding to a BMLoop and its link_loop_radial counterpart of the neighbouring face'''

    a = uv == other_uv
    b = uv == other_next_uv
    c = next_uv == other_next_uv
    d = next_uv == other_uv

    # this little funky term makes sure to only count for split uv edges
    return not ((a or b) and (c or d))
