import bpy

from . import operators 
from . import ui 
from . import prop
from . UvSquares_master.uv_squares import UV_PT_UvSquaresByShape


bl_info = {
    "name": "Zen UV",
    "author": "Valeriy Yatsenko, Sergey Tyapkin, Viktor [VAN] Teplov",
    "version": (1,8),
    "description": "Optimize UV mapping workflow",
    "blender": (2, 80, 0),
    "location": "View3D > Sidebar > Zen UV",
    "warning": "",
    "category": "UV",
    "tracker_url": "https://discordapp.com/invite/wGpFeME",
    "wiki_url": "https://zen-masters.github.io/Zen-UV/"
}

classes = [
    ui,
    operators,
    prop
]

def register():

    for c in classes:
        c.register()
    
    if not hasattr(bpy.types, bpy.ops.uv.uv_squares_by_shape.idname()):
        bpy.utils.register_class(UV_PT_UvSquaresByShape)


def unregister():

    for c in classes:
        c.unregister()

  

if __name__ == "__main__":
    register()
