import os
import bpy
import bpy.utils.previews

global zenuv_icons

zenuv_icons = bpy.utils.previews.new()

def icon_register(fileName):
    name = fileName.split('.')[0]   # Don't include file extension
    icons_dir = os.path.dirname(__file__)
    zenuv_icons.load(name, os.path.join(icons_dir, fileName), 'IMAGE')
    # print(name, os.path.join(icons_dir, fileName))

def icon_get(name):
    return zenuv_icons[name].icon_id

# Register Icons
icons = [
    "unmark-seams_32.png",
    "mark-seams_32.png",
    "zen-uv_32.png",
    "zen-unwrap_32.png",
    "Discord-Logo-White_32.png"
    ]

for icon in icons:
    icon_register(icon)